/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.exports;

import com.nxp.s32ds.cle.cdt.project.info.core.exports.DefaultOptionProvider;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.IPIExporterDataProvider;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.ProjectInfoExportSettings;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.ProjectInfoPathProcessor;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.BuildOptionsType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.CoreDescriptionType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.CoresType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.Export;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.FilesType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.ObjectFactory;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.OptionListType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.OptionsType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.PathListType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.PathNameListType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.PathNameType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.PathsType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.ProcessorType;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.ToolchainOptionType;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class PIWriter {
    private static final String SPLITTER = " ";
    private static final String LINKER_FILE_EXTS = "ld,icf,dld";
    private final ProjectInfoExportSettings settings;
    private Collection<String> linkerCommandFiles;
    private final IPIExporterDataProvider dataProvider;

    public PIWriter(ProjectInfoExportSettings settings) {
        this(settings, new DefaultOptionProvider(settings));
    }

    public PIWriter(ProjectInfoExportSettings settings, IPIExporterDataProvider dataProvider) {
        this.settings = settings;
        this.dataProvider = dataProvider;
    }

    public Export createExport() throws CoreException {
        ObjectFactory of = new ObjectFactory();
        Export result = of.createExport();
        result.setOPTIONS(this.createOptions(of));
        result.setPROCESSOR(PIWriter.createProccessor(of, this.settings));
        result.setPATHS(this.createPaths(of, this.settings.getProject()));
        result.setFILES(this.createFiles(of));
        return result;
    }

    private OptionsType createOptions(ObjectFactory of) {
        OptionsType result = of.createOptionsType();
        OptionListType supportedBuildConfigurations = of.createOptionListType();
        result.setSupportedBuildConfigurations(supportedBuildConfigurations);
        supportedBuildConfigurations.getOption().addAll(this.getApplicableConfigurationsNames());
        result.setToolchainOption(this.createToolchain(of, this.settings));
        BuildOptionsType buildOptions = of.createBuildOptionsType();
        OptionListType asmOpts = of.createOptionListType();
        OptionListType ccOpts = of.createOptionListType();
        OptionListType linkerOpts = of.createOptionListType();
        OptionListType sptAsmOpts = of.createOptionListType();
        result.setBuildOptions(buildOptions);
        buildOptions.setCCoptList(ccOpts);
        buildOptions.setLinkerOptList(linkerOpts);
        buildOptions.setASMoptList(asmOpts);
        List<String> sptAsmOptsList = this.dataProvider.getSptAsmOpts();
        if (!sptAsmOptsList.isEmpty()) {
            sptAsmOpts.getOption().addAll(sptAsmOptsList);
            buildOptions.setSPTASMoptList(sptAsmOpts);
        }
        ccOpts.getOption().addAll(this.dataProvider.getCCOpts());
        asmOpts.getOption().addAll(this.dataProvider.getAsmOpts());
        linkerOpts.getOption().addAll(this.dataProvider.getLinkerOptions());
        this.linkerCommandFiles = this.dataProvider.getLinkerCommandFiles();
        if (this.dataProvider.mergeOptions()) {
            PIWriter.joinOptions(result);
        }
        return result;
    }

    private static void joinOptions(OptionsType result) {
        OptionListType toolChainOptList;
        List<String> optionAsm = result.getBuildOptions().getASMoptList().getOption();
        List<String> optionCCopt = result.getBuildOptions().getCCoptList().getOption();
        List<String> optionLinker = result.getBuildOptions().getLinkerOptList().getOption();
        String asmOption = String.join((CharSequence)SPLITTER, optionAsm);
        String cCompilerOption = String.join((CharSequence)SPLITTER, optionCCopt);
        String cLinkerOption = String.join((CharSequence)SPLITTER, optionLinker);
        optionAsm.clear();
        optionCCopt.clear();
        optionLinker.clear();
        optionAsm.add(asmOption);
        optionCCopt.add(cCompilerOption);
        optionLinker.add(cLinkerOption);
        OptionListType sptAsmOptList = result.getBuildOptions().getSPTASMoptList();
        if (sptAsmOptList != null) {
            List<String> optionSptAsm = sptAsmOptList.getOption();
            String sptAsmOption = String.join((CharSequence)SPLITTER, optionSptAsm);
            optionSptAsm.clear();
            optionSptAsm.add(sptAsmOption);
        }
        if ((toolChainOptList = result.getBuildOptions().getToolChainOptList()) != null) {
            List<String> optionToolChain = toolChainOptList.getOption();
            String toolChainOption = String.join((CharSequence)SPLITTER, optionToolChain);
            optionToolChain.clear();
            optionToolChain.add(toolChainOption);
        }
    }

    private static ProcessorType createProccessor(ObjectFactory of, ProjectInfoExportSettings settings) {
        ProcessorType result = of.createProcessorType();
        result.setDeviceID(settings.getDevice());
        PIWriter.setRevision(result, settings);
        result.setCoreNum(Byte.valueOf("1"));
        CoresType cores = of.createCoresType();
        result.setCores(cores);
        CoreDescriptionType coreDef = of.createCoreDescriptionType();
        coreDef.setCoreID(settings.getDeviceCore());
        cores.getCore().add(coreDef);
        result.setFLASHsize("0K");
        result.setSRAMsize("0K");
        return result;
    }

    private ToolchainOptionType createToolchain(ObjectFactory of, ProjectInfoExportSettings settings) {
        ToolchainOptionType result = of.createToolchainOptionType();
        result.setToolchainID(settings.getToolchain().getName());
        String selectedBuildConfiguration = this.getSelectedConfigurationName();
        result.setSelectedBuildConfiguration(selectedBuildConfiguration);
        return result;
    }

    private static void setRevision(ProcessorType result, ProjectInfoExportSettings settings) {
        String revision = settings.getDeviceRevision();
        if (revision == null) {
            return;
        }
        if (!revision.isEmpty()) {
            result.setRevision(revision);
        }
    }

    private PathsType createPaths(ObjectFactory of, IProject project) throws CoreException {
        PathsType result = of.createPathsType();
        if (this.settings.getAbsolutePaths().booleanValue()) {
            result.setProjectInfoPath(this.settings.getOutputFile().toAbsolutePath().toString());
        }
        this.setLinkerFiles(result);
        PathListType includes = of.createPathListType();
        includes.getPath().addAll(this.settings.getAbsolutePaths() != false ? this.makeAbsolute(this.dataProvider.getIncludePaths()) : this.dataProvider.getIncludePaths());
        result.setIncludePaths(includes);
        PathListType sources = of.createPathListType();
        sources.getPath().addAll(this.settings.getAbsolutePaths() != false ? this.makeAbsolute(this.dataProvider.getSourceCodePaths()) : this.dataProvider.getSourceCodePaths());
        result.setSourceCodePaths(sources);
        PathListType libs = of.createPathListType();
        for (String str : this.createPathSet("a")) {
            libs.getPath().add(str);
        }
        result.setLibPaths(libs);
        return result;
    }

    private List<String> makeAbsolute(List<String> paths) throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            IResource resource = this.settings.getProject().findMember(path);
            if (resource != null && resource.isVirtual()) {
                path = Paths.get(this.settings.getProject().getLocation().toOSString(), resource.getFullPath().removeFirstSegments(1).toOSString()).toString();
            }
            if (path == null) continue;
            result.add(ProjectInfoPathProcessor.makeAbsOrRel(path, this.settings.getAbsolutePaths(), this.settings.getConfiguration()));
        }
        return result;
    }

    private void setLinkerFiles(PathsType result) throws CoreException {
        List<String> list = result.getLinkerCommandFile();
        if (!this.linkerCommandFiles.isEmpty()) {
            for (String lFile : this.linkerCommandFiles) {
                String file = ProjectInfoPathProcessor.makeAbsOrRel(lFile, this.settings.getAbsolutePaths(), this.settings.getConfiguration());
                boolean fileAdded = false;
                for (String path : this.dataProvider.getFiles(LINKER_FILE_EXTS)) {
                    if (!path.contains(file)) continue;
                    fileAdded = true;
                    if (path.startsWith("link::")) {
                        list.add(path);
                        break;
                    }
                    list.add(file);
                    break;
                }
                if (fileAdded) continue;
                list.add(file);
            }
        } else {
            for (String path : this.dataProvider.getFiles(LINKER_FILE_EXTS)) {
                list.add(ProjectInfoPathProcessor.makeAbsOrRel(path, this.settings.getAbsolutePaths(), this.settings.getConfiguration()));
            }
        }
    }

    private Set<String> createPathSet(String exts) {
        return this.dataProvider.getFiles(exts).stream().map(s -> {
            File file = new File((String)s);
            return file.isDirectory() ? file.toString() : file.getParent();
        }).collect(Collectors.toSet());
    }

    private static PathNameListType addPathTypes(ObjectFactory of, List<String> strs) {
        PathNameListType files = of.createPathNameListType();
        for (String str : strs) {
            PathNameType pathType = of.createPathNameType();
            pathType.setValue(str);
            files.getPathName().add(pathType);
        }
        return files;
    }

    private FilesType createFiles(ObjectFactory of) {
        FilesType result = of.createFilesType();
        result.setGeneratedCs(PIWriter.addPathTypes(of, this.dataProvider.getFiles("c, cpp, spt")));
        result.setGeneratedHs(PIWriter.addPathTypes(of, this.dataProvider.getFiles("h")));
        result.setGeneratedASMs(PIWriter.addPathTypes(of, this.dataProvider.getFiles("s")));
        List<String> libs = this.dataProvider.getFiles("a");
        if (this.dataProvider instanceof DefaultOptionProvider) {
            DefaultOptionProvider defaultProvider = (DefaultOptionProvider)this.dataProvider;
            libs.addAll(defaultProvider.getLibFilesFromToolChain());
        }
        result.setLibraries(PIWriter.addPathTypes(of, libs));
        return result;
    }

    private List<String> getApplicableConfigurationsNames() {
        List<ICConfigurationDescription> configurationsIds = this.settings.getApplicableConfigurations();
        return configurationsIds.stream().map(b -> b.getName()).collect(Collectors.toList());
    }

    private String getSelectedConfigurationName() {
        return this.settings.getDataFromCombo();
    }
}

