/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.ui.xml.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.xml.settings.DisableState;
import com.nxp.swtools.efuse.xml.settings.VisibleState;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import org.simpleframework.xml.Attribute;

public abstract class ABaseUIComponentSetting {
    @Attribute(name="id", required=true)
    private String id;
    @Attribute(name="label", required=false)
    private String label;
    @Attribute(name="row", required=false)
    private String row;
    @Attribute(name="column", required=false)
    private String column;
    @Attribute(name="value", required=false)
    private String initValue;
    @Attribute(name="action", required=false)
    private String action;
    @Attribute(name="type", required=false)
    private String type;
    @Attribute(name="constraint_ref", required=false)
    private String constraintRef;
    @Attribute(name="read_only", required=false)
    private boolean readOnly = false;
    @Attribute(name="value_expr", required=false)
    private String valueExpr;
    @Attribute(name="fuse_word", required=false)
    private String parentFuseWordId;
    @Attribute(name="fuse_field", required=false)
    private String fuseFieldId;
    @Attribute(name="ecc_field", required=false)
    private boolean eccField;
    private SimpleBooleanProperty visibleProperty = new SimpleBooleanProperty(true);
    private Map<Integer, DisableState> disableStateConditions;
    private SimpleBooleanProperty disableProperty = new SimpleBooleanProperty(false);
    private String currentValue;
    @Nullable
    private FuseWord parentFuseWord;
    @Nullable
    private FuseField fuseField;
    @Nullable
    private VisibleState visibleStateCondition;
    @Nullable
    private DisableState disableStateCondition;

    public ABaseUIComponentSetting() {
        this.id = "";
        this.label = "";
        this.row = "";
        this.column = "";
        this.initValue = "";
        this.action = "";
        this.type = "";
        this.constraintRef = "";
        this.readOnly = false;
        this.valueExpr = "";
        this.parentFuseWordId = "";
        this.fuseFieldId = "";
        this.eccField = false;
        this.visibleStateCondition = null;
        this.disableStateCondition = null;
        this.disableStateConditions = new HashMap<Integer, DisableState>();
        this.currentValue = "";
        this.parentFuseWord = null;
        this.fuseField = null;
    }

    public ABaseUIComponentSetting(String id, ABaseUIComponentSetting setting) {
        this.id = id;
        this.label = setting.label;
        this.row = setting.row;
        this.column = setting.column;
        this.initValue = setting.initValue;
        this.action = setting.action;
        this.type = setting.type;
        this.constraintRef = setting.constraintRef;
        this.readOnly = setting.readOnly;
        this.valueExpr = setting.valueExpr;
        this.parentFuseWordId = setting.parentFuseWordId;
        this.fuseFieldId = setting.fuseFieldId;
        this.eccField = setting.eccField;
        this.visibleStateCondition = setting.visibleStateCondition;
        this.disableStateCondition = setting.disableStateCondition;
        this.disableStateConditions = new HashMap<Integer, DisableState>();
        this.currentValue = "";
        this.parentFuseWord = null;
        this.fuseField = null;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public int getRow() {
        return NumberFormatValidator.getIntValueFromString((String)this.row);
    }

    public int getColumn() {
        return NumberFormatValidator.getIntValueFromString((String)this.column);
    }

    public String getInitValue() {
        return this.initValue;
    }

    public String getAction() {
        return this.action;
    }

    public String getTypeComponentId() {
        return this.type;
    }

    public String[] getConstraintsReferences() {
        return this.constraintRef.split("\\;");
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getValueExpression() {
        return this.valueExpr;
    }

    public String getParentFuseWordID() {
        return this.parentFuseWordId;
    }

    public String getFuseFieldID() {
        return this.fuseFieldId;
    }

    public void setVisibleState(boolean state) {
        this.visibleProperty.set(state);
    }

    public boolean isVisible() {
        return this.visibleProperty.get();
    }

    public Map<Integer, DisableState> getConditionsForDisableState() {
        return this.disableStateConditions;
    }

    public void setDisableState(boolean state) {
        this.disableProperty.set(state);
    }

    public @Nullable VisibleState getVisibleStateCondition() {
        return this.visibleStateCondition;
    }

    public void setVisibleStateCondition(VisibleState visibleStateCondition) {
        this.visibleStateCondition = visibleStateCondition;
    }

    public @Nullable DisableState getDisableStateCondition() {
        return this.disableStateCondition;
    }

    public void setDisableStateCondition(DisableState disableStateCondition) {
        this.disableStateCondition = disableStateCondition;
    }

    public boolean isDisabled() {
        return this.disableProperty.get();
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public @Nullable FuseWord getParentFuseWord() {
        return this.parentFuseWord;
    }

    public void setParentFuseWord(FuseWord parentFuseWord) {
        this.parentFuseWord = parentFuseWord;
    }

    public @Nullable FuseField getFuseField() {
        return this.fuseField;
    }

    public void setFuseField(FuseField fuseField) {
        this.fuseField = fuseField;
    }

    public boolean isEccField() {
        return this.eccField;
    }

    public void setEccField(boolean eccField) {
        this.eccField = eccField;
    }

    public abstract long getValueToWrite();
}

