/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.ProjectSettingsUpdaterBase;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;

public abstract class BuildStepsUpdater
extends ProjectSettingsUpdaterBase {
    private static final String BUILD_STEP_VALUES_DELIMITER = " && ";

    protected void updateConfiguration(IConfiguration configuration) {
        ManagedBuildManager.saveBuildInfo((IProject)((IProject)configuration.getOwner()), (boolean)true);
    }

    protected String getBuildStepValue(String currentBuildStepValue, String buildStepValue, UpdateOperation operation) {
        Objects.requireNonNull(currentBuildStepValue, Messages.BuildStepsUpdater_error_config_build_step_value_is_null);
        Objects.requireNonNull(buildStepValue, Messages.BuildStepsUpdater_error_passed_build_step_value_is_null);
        Set currentValues = Arrays.stream(currentBuildStepValue.split(BUILD_STEP_VALUES_DELIMITER.trim())).map(String::trim).filter(value -> !value.isEmpty()).collect(Collectors.toSet());
        switch (operation) {
            case ADD: {
                currentValues.add(buildStepValue);
                break;
            }
            case REMOVE: {
                currentValues.remove(buildStepValue);
                break;
            }
            case REPLACE_EXISTING: {
                currentValues.clear();
                currentValues.add(buildStepValue);
                break;
            }
            case CLEAN_EXISTING: {
                currentValues.clear();
            }
        }
        return String.join((CharSequence)BUILD_STEP_VALUES_DELIMITER, currentValues);
    }
}

