/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.internal.ui;

import com.nxp.s32ds.debug.ide.internal.ui.SecureDebugDialogMessages;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SecureDebugDialog
extends TitleAreaDialog {
    private static final int SIGNIFICANT_SYMBOLS_NUMBER = 32;
    private static final Pattern PATTERN_HEX = Pattern.compile(String.format("^(0x)??(\\p{XDigit}{%d})$", 32));
    private static final char NULL_TERMINATOR_CHAR = '\u0000';
    private static final char HIDDEN_CHAR_PLACEHOLDER = '\u25cf';
    private Button butStoreKeyword;
    private Button butOK;
    private Button butShowPassword;
    private Text txtPassword;
    private String keyWord = "";
    private boolean storeKeyWord = false;
    private boolean resisableOnInit = true;

    public SecureDebugDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle(SecureDebugDialogMessages.SecureDebugDialogSecondaryTitle_message);
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = new Composite(parent, 2048);
        GridData horizontalFill = new GridData(4, 16, true, false);
        innerComposite.setLayoutData((Object)horizontalFill);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 15;
        innerComposite.setLayout((Layout)gridLayout);
        SWTUtils.createLabel(innerComposite, SecureDebugDialogMessages.SecureDebugDialogKeyword_message);
        this.txtPassword = SWTUtils.createWideText(innerComposite, 0x400804, true, 1);
        this.txtPassword.setEditable(true);
        this.txtPassword.addModifyListener(listener -> this.validate());
        this.butStoreKeyword = SWTUtils.createButtonWithHorizontalSpan(innerComposite, SecureDebugDialogMessages.SecureDebugDialogStoreKeyword_message, 32, 2);
        this.butShowPassword = SWTUtils.createButtonWithHorizontalSpan(innerComposite, SecureDebugDialogMessages.SecureDebugDialogShowKeyword_message, 32, 2);
        this.butShowPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SecureDebugDialog.this.butShowPassword.getSelection()) {
                    SecureDebugDialog.this.txtPassword.setEchoChar('\u0000');
                } else {
                    SecureDebugDialog.this.txtPassword.setEchoChar('\u25cf');
                }
            }
        });
        this.getShell().setText(SecureDebugDialogMessages.SecureDebugDialogTitle_message);
        this.setHelpAvailable(false);
        this.setMessage(null);
        return innerComposite;
    }

    private void validate() {
        String pass = this.txtPassword.getText();
        if (this.butOK != null) {
            if (pass.isEmpty()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(SecureDebugDialogMessages.SecureDebugDialogNoKeyword_message);
            } else if (!PATTERN_HEX.matcher(pass).matches()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(SecureDebugDialogMessages.SecureDebugDialogKeywordWrongFormat_message);
            } else {
                this.butOK.setEnabled(true);
                this.setErrorMessage(null);
            }
        }
    }

    protected boolean isResizable() {
        return this.resisableOnInit;
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        Point currentSize = super.getInitialSize();
        super.getShell().pack();
        Point newSize = super.getShell().getSize();
        super.getShell().setSize(currentSize.x, newSize.y);
        this.resisableOnInit = false;
        this.validate();
        return butBar;
    }

    protected void okPressed() {
        this.keyWord = this.txtPassword.getText();
        if (!this.keyWord.isEmpty()) {
            this.storeKeyWord = this.butStoreKeyword.getSelection();
        }
        super.okPressed();
    }

    public String getKeyword() {
        return this.keyWord;
    }

    public boolean getStoreKeyword() {
        return this.storeKeyWord;
    }
}

