/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.osgi.framework.Version;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="sw_comp_ref", strict=false)
@Order(attributes={"name", "version", "match_type", "until_version", "revisions"})
public class SWComponent {
    static final Logger LOGGER = LogManager.getLogger(SWComponent.class);
    @Attribute(name="name")
    private String name;
    @Nullable
    private String revisionsString;
    private List<String> revisionsList = Collections.emptyList();
    @Nullable
    private Version version;
    @Nullable
    private Version untilVersion;
    @Nullable
    private Match match;
    private boolean required = true;

    @Attribute(name="match_type", required=false)
    public void setMatchString(String matchString) {
        this.match = Match.getMatchByName(matchString);
        if (SWToolsProperties.isVerificationOn() && this.match == null) {
            LOGGER.severe(MessageFormat.format("[DATA] Specified match type: {0} is not supported", matchString));
        }
    }

    @Attribute(name="match_type", required=false)
    public @Attribute(name="match_type", required=false) String getMatchString() {
        if (this.match != null) {
            return this.match.getName();
        }
        return "";
    }

    @Attribute(name="version", required=false)
    private @Attribute(name="version", required=false) @Nullable String getVersionString() {
        return this.version != null ? this.version.toString() : null;
    }

    @Attribute(name="version", required=false)
    private void setVersionString(@Nullable String newVer) {
        this.version = !UtilsText.safeString((String)newVer).isEmpty() ? new Version(UtilsText.safeString((String)newVer)) : null;
    }

    @Attribute(name="until_version", required=false)
    private @Attribute(name="until_version", required=false) @Nullable String getUntilVersionString() {
        return this.untilVersion != null ? this.untilVersion.toString() : null;
    }

    @Attribute(name="until_version", required=false)
    private void setUntilVersionString(@Nullable String newVer) {
        this.untilVersion = !UtilsText.safeString((String)newVer).isEmpty() ? new Version(UtilsText.safeString((String)newVer)) : null;
    }

    @Attribute(name="revisions", required=false)
    public void setRevisionsString(@Nullable String revisionsString) {
        this.revisionsString = revisionsString;
        if (revisionsString != null && !revisionsString.isEmpty()) {
            String[] revisionsArray = revisionsString.split(",");
            this.revisionsList = new ArrayList<String>(revisionsArray.length);
            String[] stringArray = revisionsArray;
            int n = revisionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String revision = stringArray[n2];
                this.revisionsList.add(revision.trim());
                ++n2;
            }
        }
    }

    @Attribute(name="revisions", required=false)
    public @Attribute(name="revisions", required=false) @Nullable String getRevisionsString() {
        return this.revisionsString;
    }

    public List<String> getRevisionsList() {
        return CollectionsUtils.unmodifiableList(this.revisionsList);
    }

    public SWComponent(String name, String versionStr) {
        this.name = name;
        this.version = new Version(versionStr);
    }

    public SWComponent(String name, Version version, Match match) {
        this.name = name;
        this.version = version;
        this.match = match;
    }

    public SWComponent(String name, Version version, Match match, @Nullable Version untilVersion) {
        this.name = name;
        this.version = version;
        this.match = match;
        this.untilVersion = untilVersion;
    }

    public SWComponent(String name, Version version, Match match, @Nullable Version untilVersion, boolean required) {
        this.name = name;
        this.version = version;
        this.match = match;
        this.untilVersion = untilVersion;
        this.required = required;
    }

    public SWComponent(String name, Version version, Match match, @Nullable Version untilVersion, boolean required, @Nullable String revision) {
        this.name = name;
        this.version = version;
        this.match = match;
        this.untilVersion = untilVersion;
        this.required = required;
        this.setRevisionsString(revision);
    }

    public SWComponent(String name, Version version) {
        this.name = name;
        this.version = version;
    }

    public SWComponent(String name) {
        this.name = name;
        this.version = null;
    }

    @Deprecated
    protected SWComponent() {
        this("");
    }

    public String getName() {
        return this.name;
    }

    public @Nullable Version getVersion() {
        return this.version;
    }

    public @Nullable Version getUntilVersion() {
        return this.untilVersion;
    }

    public @Nullable Match getMatch() {
        return this.match;
    }

    public String getVersionStr() {
        return this.version != null ? UtilsText.safeString((String)this.version.toString()) : "";
    }

    public String getUntilVersionStr() {
        return this.untilVersion != null ? UtilsText.safeString((String)this.untilVersion.toString()) : "";
    }

    @Attribute(name="required", required=false)
    public @Attribute(name="required", required=false) boolean getRequired() {
        return this.required;
    }

    @Attribute(name="required", required=false)
    public void setRequired(boolean newValue) {
        this.required = newValue;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "name" + "=" + this.name + ", " + "version" + "=" + this.getVersionStr() + ", " + "required" + "=" + this.getRequired() + ", " + "revisions" + "=" + this.getRevisionsString() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.untilVersion);
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.revisionsString);
        result = 31 * result + Objects.hashCode(this.revisionsList);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SWComponent other = (SWComponent)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.untilVersion, other.untilVersion)) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        if (!Objects.equals(this.revisionsString, other.revisionsString)) {
            return false;
        }
        return Objects.equals(this.revisionsList, other.revisionsList);
    }

    public static enum Match {
        PERFECT("perfect"),
        EQUIVALENT("equivalent"),
        COMPATIBLE("compatible"),
        GREATER_OR_EQUAL("greaterOrEqual");

        private String name;

        private Match(String name) {
            this.name = name;
        }

        public static @Nullable Match getMatchByName(String matchName) {
            List<Match> matchModes = Arrays.asList(Match.values());
            return (Match)((Object)CollectionsUtils.nullableOptionalGet(matchModes.stream().filter(m -> m.getName().equals(matchName)).findAny()));
        }

        public String getName() {
            return this.name;
        }
    }
}

