/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.xml.UtilsXML;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.resourcetables.model.XSDUtils;
import com.nxp.swtools.resourcetables.model.data.AvailableResourceTablesRefResolver;
import com.nxp.swtools.resourcetables.model.data.ResourceTableData;
import com.nxp.swtools.resourcetables.model.data.XMLConstants;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.BoolSetting;
import com.nxp.swtools.resourcetables.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.EnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FloatSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.IStructuredSettingModel;
import com.nxp.swtools.resourcetables.model.data.setting.InfoSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IntegerSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.data.setting.StringSetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.xml.sax.SAXException;

@Root(name="resource_table", strict=false)
@Namespace(prefix="resource", reference="http://swtools.freescale.net/XSD/resource/1.0")
@Order(attributes={"id"})
public class ResourceTable
implements IID {
    private static final Logger LOGGER = LogManager.getLogger(ResourceTable.class);
    private static final String LOCAL_SCHEMA = XMLConstants.RESOURCE_SCHEMA_FILENAME;
    @Attribute(name="id")
    private String id;
    private Map<String, ISetting> userTypes = new LinkedHashMap<String, ISetting>();
    private Map<String, ISetting> definition = new LinkedHashMap<String, ISetting>();
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation;
    @Element(name="data")
    private ResourceTableData data = new ResourceTableData();

    @org.simpleframework.xml.Path(value="user_types")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private @org.simpleframework.xml.Path(value="user_types") @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)}) @ElementList(type=ArraySetting.class, required=false, inline=true) @ElementList(type=SetSetting.class, required=false, inline=true) @ElementList(type=DynamicEnumSetting.class, required=false, inline=true) @ElementList(type=InfoSetting.class, required=false, inline=true) @ElementList(type=EnumSetting.class, required=false, inline=true) @ElementList(type=ReferenceSetting.class, required=false, inline=true) @ElementList(type=StructSetting.class, required=false, inline=true) @ElementList(type=BoolSetting.class, required=false, inline=true) @ElementList(type=FloatSetting.class, required=false, inline=true) @ElementList(type=StringSetting.class, required=false, inline=true) @ElementList(type=IntegerSetting.class, required=false, inline=true) List<ISetting> getUserTypesList() {
        return CollectionsUtils.listFromMapValues(this.userTypes);
    }

    @org.simpleframework.xml.Path(value="user_types")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private void setUserTypesList(List<ISetting> userTypesList) {
        userTypesList.stream().forEachOrdered(userType -> this.addUserType((ISetting)userType));
    }

    @org.simpleframework.xml.Path(value="definition")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private @org.simpleframework.xml.Path(value="definition") @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)}) @ElementList(type=ArraySetting.class, required=false, inline=true) @ElementList(type=SetSetting.class, required=false, inline=true) @ElementList(type=DynamicEnumSetting.class, required=false, inline=true) @ElementList(type=InfoSetting.class, required=false, inline=true) @ElementList(type=EnumSetting.class, required=false, inline=true) @ElementList(type=ReferenceSetting.class, required=false, inline=true) @ElementList(type=StructSetting.class, required=false, inline=true) @ElementList(type=BoolSetting.class, required=false, inline=true) @ElementList(type=FloatSetting.class, required=false, inline=true) @ElementList(type=StringSetting.class, required=false, inline=true) @ElementList(type=IntegerSetting.class, required=false, inline=true) List<ISetting> getDefinitionList() {
        return CollectionsUtils.listFromMapValues(this.definition);
    }

    @org.simpleframework.xml.Path(value="definition")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private void setDefinitionList(List<ISetting> definitionList) {
        definitionList.stream().forEachOrdered(def -> this.addDefinition((ISetting)def));
    }

    @Deprecated
    protected ResourceTable() {
        this("");
    }

    public ResourceTable(String id) {
        this.schemaLocation = XMLConstants.RESOURCE_SCHEMA_LOC;
        this.id = id;
    }

    public void addUserType(ISetting newType) {
        if (this.userTypes.put(newType.getId(), newType) != null) {
            LOGGER.severe(MessageFormat.format("[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.", newType.getId(), this));
        }
    }

    public void addUserTypes(LinkedHashMap<String, ISetting> newUserTypes) {
        newUserTypes.values().stream().forEachOrdered(userType -> this.addUserType((ISetting)userType));
    }

    public void addData(AStoragePeriphsSetting newData) {
        this.data.addSetting(newData);
    }

    public void addData(Collection<AStoragePeriphsSetting> newData) {
        this.data.addSettings(newData);
    }

    public void addDefinition(ISetting newDef) {
        if (this.definition.put(newDef.getId(), newDef) != null) {
            LOGGER.severe(MessageFormat.format("[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.", newDef.getId(), this));
        }
    }

    public void addDefinitions(LinkedHashMap<String, ISetting> newDefs) {
        newDefs.values().stream().forEachOrdered(def -> this.addDefinition((ISetting)def));
    }

    public @Nullable ISetting find(String ... typeId) {
        ISetting refType = null;
        String[] stringArray = typeId;
        int n = typeId.length;
        int n2 = 0;
        while (n2 < n) {
            String splitIdPart = stringArray[n2];
            if (refType instanceof IStructuredSettingModel) {
                refType = ((IStructuredSettingModel)refType).getSetting(splitIdPart);
            } else {
                ISetting iSetting = refType = refType == null ? this.find(splitIdPart) : null;
            }
            if (refType == null) break;
            ++n2;
        }
        return refType;
    }

    private @Nullable ISetting find(String typeId) {
        ISetting type = null;
        type = this.definition.get(typeId);
        if (type == null) {
            type = this.userTypes.get(typeId);
        }
        return type;
    }

    public ResourceTableData getData() {
        return this.data;
    }

    public Map<String, ISetting> getDefinition() {
        return CollectionsUtils.unmodifiableMap(this.definition);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getSchemaLocation() {
        String[] locPair = this.schemaLocation.split(" ");
        if (2 != locPair.length) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("[DATA] Component resource with ID {0} specifies an invalid schema location {1}", this.id, this.schemaLocation));
            }
            return "";
        }
        String loc = locPair[1];
        return loc;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [id=" + this.id + ", userTypes(fst " + 3 + ")=" + CollectionsUtils.firstN(this.getUserTypesList(), (int)3) + ", definition(fst " + 3 + ")=" + CollectionsUtils.firstN(this.getDefinitionList(), (int)3) + "data=" + this.data + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.userTypes.hashCode();
        result = 31 * result + this.definition.hashCode();
        result = 31 * result + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceTable other = (ResourceTable)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.userTypes.equals(other.userTypes)) {
            return false;
        }
        if (!this.definition.equals(other.definition)) {
            return false;
        }
        return this.data.equals(other.data);
    }

    public static @Nullable ResourceTable loadResourceFromFile(File source) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream rtIs = UtilsDecryption.getFileInputStream((File)source);){
                Persister serializer = new Persister();
                ResourceTable result = (ResourceTable)serializer.read(ResourceTable.class, rtIs);
                if (SWToolsProperties.isVerificationOn()) {
                    try {
                        URL schema;
                        try {
                            schema = new URL(result.getSchemaLocation());
                            XSDUtils.verifySchemaVersion(schema, source);
                        }
                        catch (MalformedURLException e) {
                            LOGGER.log(Level.SEVERE, "[DATA] Invalid schema URL in component resource file " + source.getAbsolutePath(), e);
                            schema = null;
                        }
                        UtilsXML.validXml((InputStream)UtilsDecryption.getFileInputStream((File)source), (URL)schema, (Path)ResourceTable.getFallbackSchemaLocation());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "[DATA] Missing schema for component resource file " + source.getAbsolutePath(), e);
                    }
                    catch (SAXException e) {
                        LOGGER.log(Level.SEVERE, "[DATA] Invalid component resource file " + source.getAbsolutePath(), e);
                    }
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[TOOL] Error loading component resource file " + source.getAbsolutePath(), e);
            return null;
        }
    }

    private static Path getFallbackSchemaLocation() {
        return Paths.get(Platform.isRunning() ? PEConfiguration.getSystemDirectory() : "", "resources", "schemas", LOCAL_SCHEMA);
    }

    public void resolve(AvailableResourceTablesRefResolver sdkRefResolver) {
        sdkRefResolver.resolve(this, this.definition);
    }
}

