/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.resourcetables.model.data.ComponentLoadingStatus;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(name="register", strict=false)
public class Register {
    private static final String NO_VALUE_ERROR_MESSAGE = "[DATA] [REGISTER] [{0}] Value is not specified in register binding.";
    private static final String NO_DEFINITION_ERROR_MESSAGE = "[DATA] [REGISTER] [{0}] There is no name of {1} specified in register binding.";
    private static final String TWO_DEFINITIONS_ERROR_MESSAGE = "[DATA] [REGISTER] [{0}] There are two definitions of {1} name specified in register binding.";
    private static final Logger LOGGER = LogManager.getLogger(Register.class);
    @Nullable
    private Expression peripheralExpr;
    @Nullable
    private Expression nameExpr;
    @Nullable
    private Expression bitfieldExpr;
    @Nullable
    private Expression enableExpr;
    @Nullable
    private Expression maskExpr;
    @Attribute(name="peripheral", required=false)
    @Nullable
    private @Attribute(name="peripheral", required=false) @Nullable String peripheral;
    @Attribute(name="name", required=false)
    private String name;
    @Attribute(name="bitfield", required=false)
    private String bitfield;
    @Attribute(name="value", required=false)
    private String value;
    @Attribute(name="unknown_bits_expr", required=false)
    @Nullable
    private @Attribute(name="unknown_bits_expr", required=false) @Nullable String unknownBitsMask;
    @Nullable
    private Expression valueExpr;
    @Nullable
    private Expression unknownBitsMaskExpr;
    @Nullable
    private Expression reverseValueExpr;
    @Nullable
    private Expression reverseValueEnableExpr;

    @Attribute(name="reverse_value", required=false)
    public @Attribute(name="reverse_value", required=false) String getReverseValueExprString() {
        return this.reverseValueExpr != null ? this.reverseValueExpr.formatOutput(FormatOptions.DEFAULT) : "";
    }

    @Attribute(name="reverse_value", required=false)
    public void setReverseValueExprString(String newExpression) {
        if (!UtilsText.isEmpty((String)newExpression)) {
            this.reverseValueExpr = Expression.create((String)newExpression);
        }
    }

    @Attribute(name="reverse_value_enable", required=false)
    public @Attribute(name="reverse_value_enable", required=false) String getReverseValueEnableExprString() {
        return this.reverseValueEnableExpr != null ? this.reverseValueEnableExpr.formatOutput(FormatOptions.DEFAULT) : "";
    }

    @Attribute(name="reverse_value_enable", required=false)
    public void setReverseValueEnableExprString(String newExpression) {
        if (!UtilsText.isEmpty((String)newExpression)) {
            this.reverseValueEnableExpr = Expression.create((String)newExpression);
        }
    }

    @Attribute(name="mask", required=false)
    public @Attribute(name="mask", required=false) String getMaskExprString() {
        return this.maskExpr != null ? this.maskExpr.formatOutput(FormatOptions.DEFAULT) : "";
    }

    @Attribute(name="mask", required=false)
    public void setMaskExprString(String newExpression) {
        if (!UtilsText.isEmpty((String)newExpression)) {
            this.maskExpr = Expression.create((String)newExpression);
        }
    }

    public Register(String name, String bitfield, String value) {
        this.name = name;
        this.bitfield = bitfield;
        this.value = value;
    }

    @Attribute(name="peripheral_expr", required=false)
    public void setPeripheralExprString(String expressionString) {
        this.peripheralExpr = Expression.create((String)expressionString);
    }

    @Attribute(name="peripheral_expr", required=false)
    public @Attribute(name="peripheral_expr", required=false) @Nullable String getPeripheralExprString() {
        return this.peripheralExpr != null ? this.peripheralExpr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="name_expr", required=false)
    public void setNameExprString(String expressionString) {
        this.nameExpr = Expression.create((String)expressionString);
    }

    @Attribute(name="name_expr", required=false)
    public @Attribute(name="name_expr", required=false) @Nullable String getNameExprString() {
        return this.nameExpr != null ? this.nameExpr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="bitfield_expr", required=false)
    public void setBitfieldExprString(String expressionString) {
        this.bitfieldExpr = Expression.create((String)expressionString);
    }

    @Attribute(name="bitfield_expr", required=false)
    public @Attribute(name="bitfield_expr", required=false) @Nullable String getBitfieldExprString() {
        return this.bitfieldExpr != null ? this.bitfieldExpr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="enable", required=false)
    public void setEnableExprString(String expressionString) {
        this.enableExpr = Expression.create((String)expressionString);
    }

    @Attribute(name="enable", required=false)
    public @Attribute(name="enable", required=false) @Nullable String getEnableExprString() {
        return this.enableExpr != null ? this.enableExpr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.bitfield, this.value, this.peripheral, this.peripheralExpr, this.nameExpr, this.bitfieldExpr, this.reverseValueExpr, this.reverseValueEnableExpr);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Register register = (Register)obj;
        if (!this.name.equalsIgnoreCase(register.getName())) {
            return false;
        }
        if (!this.bitfield.equalsIgnoreCase(register.getBitfield())) {
            return false;
        }
        if (!this.value.equalsIgnoreCase(register.getValue())) {
            return false;
        }
        if (!Objects.equals(this.peripheral, register.peripheral)) {
            return false;
        }
        if (!Objects.equals(this.peripheralExpr, register.peripheralExpr)) {
            return false;
        }
        if (!Objects.equals(this.nameExpr, register.nameExpr)) {
            return false;
        }
        if (!Objects.equals(this.bitfieldExpr, register.bitfieldExpr)) {
            return false;
        }
        if (!Objects.equals(this.reverseValueExpr, register.reverseValueExpr)) {
            return false;
        }
        return Objects.equals(this.reverseValueEnableExpr, register.reverseValueEnableExpr);
    }

    public Register() {
        this("", "", "");
    }

    public @Nullable String getPeripheral() {
        return this.peripheral;
    }

    public String getName() {
        return this.name;
    }

    public String getBitfield() {
        return this.bitfield;
    }

    public String getValue() {
        return this.value;
    }

    public @Nullable Expression getPeripheralExpr() {
        return this.peripheralExpr;
    }

    public @Nullable Expression getNameExpr() {
        return this.nameExpr;
    }

    public @Nullable Expression getBitfieldExpr() {
        return this.bitfieldExpr;
    }

    public @Nullable Expression getValueExpr() {
        return this.valueExpr != null ? this.valueExpr : (this.valueExpr = Expression.tryCreate((String)this.value));
    }

    public @Nullable Expression getUknownBitsMaskExpr() {
        if (this.unknownBitsMaskExpr != null) {
            return this.unknownBitsMaskExpr;
        }
        String unknownBitsMaskLoc = this.unknownBitsMask;
        if (unknownBitsMaskLoc == null) {
            return null;
        }
        this.unknownBitsMaskExpr = Expression.tryCreate((String)unknownBitsMaskLoc);
        return this.unknownBitsMaskExpr;
    }

    public @Nullable Expression getReverseValueExpr() {
        return this.reverseValueExpr;
    }

    public @Nullable Expression getReverseValueEnableExpr() {
        return this.reverseValueEnableExpr;
    }

    public @Nullable Expression getMaskExpr() {
        return this.maskExpr;
    }

    @Validate
    public void verify() {
        if (!UtilsText.isEmpty((String)this.peripheral) && this.peripheralExpr != null) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(TWO_DEFINITIONS_ERROR_MESSAGE, ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), "peripheral"));
        }
        if (!UtilsText.isEmpty((String)this.name) && this.nameExpr != null) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(TWO_DEFINITIONS_ERROR_MESSAGE, ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), "register"));
        }
        if (!UtilsText.isEmpty((String)this.bitfield) && this.bitfieldExpr != null) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(TWO_DEFINITIONS_ERROR_MESSAGE, ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), "bitfield"));
        }
        if (UtilsText.isEmpty((String)this.name) && this.nameExpr == null) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(NO_DEFINITION_ERROR_MESSAGE, ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), "register"));
        }
        if (UtilsText.isEmpty((String)this.bitfield) && this.bitfieldExpr == null) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(NO_DEFINITION_ERROR_MESSAGE, ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), "bitfield"));
        }
        if (this.getValueExpr() == null) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(NO_VALUE_ERROR_MESSAGE, ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent()));
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + "peripheral=" + this.getPeripheral() + ", peripheral_expr=" + this.getPeripheralExprString() + ", name=" + this.getName() + ", name_expr=" + this.getNameExprString() + ", bitfield=" + this.getBitfield() + ", bitfield_expr=" + this.getBitfieldExprString() + ", value=" + this.getValue() + ", reverse_value=" + this.getReverseValueExprString() + ", reverse_value_enable=" + this.getReverseValueEnableExprString() + "]";
    }
}

