/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.resourcetables.model.config.ICacheable;
import java.util.Map;
import java.util.Stack;
import java.util.function.Supplier;

public class CacheHelper {
    public static final Object VALUE_NULL = new Object(){

        public String toString() {
            return "NULL";
        }
    };
    public static Stack<CollectionsUtils.Pair<String, ICacheable>> dependencyStack = new Stack();

    public static synchronized <T> T getValueCaching(ICacheable cacheable, String key, Supplier<T> valueSupplier) {
        Map<String, Object> cache = cacheable.getCache();
        Object cachedValue = cache.get(key);
        if (cachedValue != null) {
            Object result;
            Object object = result = cachedValue == VALUE_NULL ? null : cachedValue;
            if (!dependencyStack.isEmpty()) {
                cacheable.getDependencyMap().add((Object)key, dependencyStack.peek());
            }
            return (T)result;
        }
        dependencyStack.add((CollectionsUtils.Pair<String, ICacheable>)new CollectionsUtils.Pair((Object)key, (Object)cacheable));
        try {
            T result;
            try {
                result = valueSupplier.get();
            }
            catch (DoNotCacheValue e) {
                Object returnValue;
                Object object = returnValue = e.getValue();
                dependencyStack.pop();
                if (!dependencyStack.isEmpty()) {
                    cacheable.getDependencyMap().add((Object)key, dependencyStack.peek());
                }
                return (T)object;
            }
            Object valueToSave = result == null ? VALUE_NULL : result;
            cache.put(key, valueToSave);
            T t = result;
            return t;
        }
        finally {
            dependencyStack.pop();
            if (!dependencyStack.isEmpty()) {
                cacheable.getDependencyMap().add((Object)key, dependencyStack.peek());
            }
        }
    }

    public static synchronized boolean isKeyCached(ICacheable cacheable, String key) {
        return cacheable.getCache().containsKey(key);
    }

    public static class DoNotCacheValue
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private Object value = VALUE_NULL;

        public DoNotCacheValue(Object value) {
            this.setValue(value);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

