/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.internal.core;

import com.nxp.s32ds.debug.ide.volkano.CommandBuilder;
import com.nxp.s32ds.debug.ide.volkano.internal.core.VolkanoActivator;
import com.nxp.s32ds.debug.ide.volkano.internal.core.VolkanoMessage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class CommandBuilderImpl
implements CommandBuilder {
    private File ccsFolder = null;
    private IStringVariableManager variableManager;
    private static final String COMMAND_TOOL = "volkano.exe";
    private static final String COMMAND_UTIL = "volkano_utils.exe";
    private static final String COMMAND_ARG_CMD = "-cmd";
    private static final String COMMAND_ARG_PWD = "-pw";
    private static final String COMMAND_ARG_NEW_PWD = "-new_pwd";
    private static final String COMMAND_ARG_ADKP = "-input_key";
    private static final String COMMAND_ARG_UID = "-uid";
    private static final String COMMAND_ARG_KEY = "-key";
    private static final String COMMAND_ARG_KEYBIN = "-keybin";
    private static final String COMMAND_DISCOVER = "discover";
    private static final String COMMAND_GEN_WRAP_KEY = "generate_wrapkey";
    private static final String COMMAND_EXPORT_WRAP_KEY = "export_wrapkey";
    private static final String COMMAND_WRAP_ADKP = "wrap_key";
    private static final String COMMAND_REGISTER_ADKP = "register_adkp";
    private static final String COMMAND_REGISTER_KUID = "register_kuid";
    private static final String COMMAND_DELETE_RECORD = "delete_record";
    private static final String COMMAND_GET_VERSION = "--version";
    private static final String COMMAND_UPDATE_PWD = "update_pwd";
    private static final String DATABASE_FILE_NAME = "volkano.db";
    private static final String DEFAULT_WRAP_KEY_BIN = "wrap_key.bin";
    public static final String BUNDLE_ID = "com.nxp.s32ds.debug.ide.volkano";
    private String ccsLocationVariable = "";

    public CommandBuilderImpl() {
        this.variableManager = VariablesPlugin.getDefault().getStringVariableManager();
    }

    public CommandBuilderImpl(String location) {
        this.ccsLocationVariable = location;
        this.variableManager = VariablesPlugin.getDefault().getStringVariableManager();
    }

    @Override
    public IStatus resolveEnvironment() throws CoreException {
        if (this.ccsLocationVariable == null || this.ccsLocationVariable.isEmpty()) {
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), VolkanoMessage.Volkano_error_ccs_location_variable);
        }
        String ccsLocationValue = this.variableManager.performStringSubstitution(this.ccsLocationVariable);
        Path pathCCS = Paths.get(ccsLocationValue, new String[0]).normalize();
        this.ccsFolder = pathCCS.toFile();
        return Status.OK_STATUS;
    }

    @Override
    public ProcessBuilder getBuilderFetchVersionCmd() throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_GET_VERSION);
    }

    @Override
    public ProcessBuilder getBuilderDiscoverCommand(String pwd) throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_ARG_CMD, COMMAND_DISCOVER, COMMAND_ARG_PWD, pwd);
    }

    @Override
    public ProcessBuilder getBuilderGenerateWrapKeyCmd() throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_ARG_CMD, COMMAND_GEN_WRAP_KEY);
    }

    @Override
    public ProcessBuilder getBuilderExportWrapKeyCmd() throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_ARG_CMD, COMMAND_EXPORT_WRAP_KEY);
    }

    @Override
    public ProcessBuilder getBuilderCreateWrapingADKPCmd(String key, String binFilePath) throws CoreException {
        return this.getBuilderForArgs(COMMAND_UTIL, COMMAND_ARG_CMD, COMMAND_WRAP_ADKP, COMMAND_ARG_ADKP, key, COMMAND_ARG_KEYBIN, binFilePath);
    }

    @Override
    public ProcessBuilder getBuilderRegisterAdkpByUidCmd(String uid, String wrapAdkp, String pwd) throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_ARG_CMD, COMMAND_REGISTER_ADKP, COMMAND_ARG_UID, uid, COMMAND_ARG_KEY, wrapAdkp, COMMAND_ARG_PWD, pwd);
    }

    @Override
    public ProcessBuilder getBuilderRegisterKuidByUidCmd(String uid, String kuid, String pwd) throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_ARG_CMD, COMMAND_REGISTER_KUID, COMMAND_ARG_UID, uid, COMMAND_ARG_KEY, kuid, COMMAND_ARG_PWD, pwd);
    }

    @Override
    public ProcessBuilder getBuilderDeleteRecordByUidCmd(String uid) throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_ARG_CMD, COMMAND_DELETE_RECORD, COMMAND_ARG_UID, uid);
    }

    @Override
    public ProcessBuilder getBuilderSetInitialPassword(String pwd) throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_ARG_CMD, COMMAND_UPDATE_PWD, COMMAND_ARG_NEW_PWD, pwd);
    }

    @Override
    public ProcessBuilder getBuilderChangePassword(String currentPwd, String newPwd) throws CoreException {
        return this.getBuilderForArgs(COMMAND_TOOL, COMMAND_ARG_CMD, COMMAND_UPDATE_PWD, COMMAND_ARG_NEW_PWD, newPwd, COMMAND_ARG_PWD, currentPwd);
    }

    public ProcessBuilder getBuilderForArgs(String cmdTool, String ... command) throws CoreException {
        if (this.ccsFolder == null || !this.ccsFolder.exists()) {
            throw new CoreException((IStatus)new Status(4, BUNDLE_ID, VolkanoMessage.Volkano_cssFolder_not_found_error));
        }
        Path path = Paths.get(this.ccsFolder.getAbsolutePath(), cmdTool);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(path.toString());
        cmd.addAll(Arrays.asList(command));
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.directory(this.ccsFolder);
        return builder;
    }

    @Override
    public File getBuilderLocation() {
        return this.ccsFolder;
    }

    @Override
    public IStatus performRemoveDataBase() {
        Path dbPath = Paths.get(this.ccsFolder.getAbsolutePath(), DATABASE_FILE_NAME);
        File dbFile = dbPath.toFile();
        if (!dbFile.exists()) {
            String msg = NLS.bind((String)VolkanoMessage.Volkano_error_db_cannot_be_found, (Object)dbPath);
            return new Status(4, BUNDLE_ID, msg);
        }
        dbFile.delete();
        return Status.OK_STATUS;
    }

    @Override
    public String getDefaultWrapKeyPath() {
        return String.valueOf(this.ccsFolder.getAbsolutePath()) + File.separator + DEFAULT_WRAP_KEY_BIN;
    }

    @Override
    public String getDefaultWrapKeyFileName() {
        return DEFAULT_WRAP_KEY_BIN;
    }
}

