/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano;

import com.nxp.s32ds.debug.ide.volkano.internal.core.VolkanoActivator;
import com.nxp.s32ds.debug.ide.volkano.internal.core.VolkanoMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class VolkanoUtil {
    private static final String HEX_PATTERN = "-?[0-9a-fA-F]+";
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final int bytePair = 2;

    public static IStatus isHex(String input, String fieldName) {
        Pattern compile = Pattern.compile(HEX_PATTERN);
        Matcher matcher = compile.matcher(input);
        if (!matcher.matches()) {
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), NLS.bind((String)VolkanoMessage.Volkano_hex_format_error, (Object)fieldName));
        }
        return Status.OK_STATUS;
    }

    public static boolean isHex(char input) {
        return Character.isDigit(input) || Character.isISOControl(input) || "abcdef".contains(String.valueOf(input).toLowerCase());
    }

    public static boolean isIPv4(char input) {
        return Character.isDigit(input) || Character.isISOControl(input) || ".".contains(String.valueOf(input).toLowerCase());
    }

    public static IStatus validateSize(String input, int byteCount, String fieldName) {
        int length = byteCount * 2;
        if (input.length() > length) {
            String msg = NLS.bind((String)VolkanoMessage.Volkano_validation_error_lenght_more_byte, (Object)fieldName, (Object)String.valueOf(byteCount));
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), msg);
        }
        if (input.length() < length) {
            String msg = NLS.bind((String)VolkanoMessage.Volkano_validation_error_lenght_less_byte, (Object)fieldName, (Object)String.valueOf(byteCount));
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), msg);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateIPv4(String address) {
        if (address.isEmpty()) {
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), VolkanoMessage.Volkano_error_ipv4_empty);
        }
        Pattern compile = Pattern.compile(IPADDRESS_PATTERN);
        Matcher matcher = compile.matcher(address);
        if (!matcher.matches()) {
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), VolkanoMessage.Volkano_error_ipv4_wrong);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateInput(String value, int length, String fieldName) {
        IStatus status = VolkanoUtil.isEmpty(value, fieldName);
        if (!status.isOK()) {
            return status;
        }
        status = VolkanoUtil.isHex(value, fieldName);
        if (!status.isOK()) {
            return status;
        }
        return VolkanoUtil.validateSize(value, length, fieldName);
    }

    private static IStatus isEmpty(String value, String fieldName) {
        if (value.isEmpty()) {
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), NLS.bind((String)VolkanoMessage.Volkano_validation_error_empty_input, (Object)fieldName));
        }
        return Status.OK_STATUS;
    }
}

