/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.Repository;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerMarker;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import com.nxp.s32ds.rcp.modular.internal.core.ModularUtils;
import com.nxp.s32ds.rcp.modular.internal.core.RepositoryUtils;
import com.nxp.s32ds.rcp.modular.internal.core.exception.ModularException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class ModularMetaModelReader {
    private final ProvisioningSession session;

    public ModularMetaModelReader(ProvisioningSession provisioningSession) {
        this.session = provisioningSession;
    }

    public Collection<URI> getEnabledRepositories() {
        IEclipsePreferences pref = ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.rcp.modular.core");
        String string = pref.get("storedRepositories", null);
        HashSet<Repository> repositories = new HashSet<Repository>();
        RepositoryUtils.readRepo(string, repositories);
        return repositories.stream().map(r -> RepositoryUtils.localRepoURIFixer(r.getLocation())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<ModularPack> getLastedPackfromUri(Collection<URI> uris, IProvisioningAgent agent, IProgressMonitor progressMonitor) throws OperationCanceledException {
        HashSet<ModularPack> modularObjects = new HashSet<ModularPack>();
        if (agent != null && uris != null) {
            IMetadataRepositoryManager metaRepositorymanager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)(uris.size() * 3)).checkCanceled();
            for (URI uri : uris) {
                IMetadataRepository repository = ModularUtils.loadMetadataRepository(uri, metaRepositorymanager, artifactRepositoryManager, (IProgressMonitor)subMonitor);
                if (repository == null) continue;
                IQueryResult query = repository.query(QueryUtil.ALL_UNITS, (IProgressMonitor)subMonitor);
                if (query != null) {
                    for (IInstallableUnit q : query) {
                        if (!q.getProperties().containsKey("com.nxp.s32ds.pack.id")) continue;
                        try {
                            ModularUtils.createModularPackByIInstableUnit(q, (IQueryResult<IInstallableUnit>)query, (IProgressMonitor)subMonitor.split(1), uri).ifPresent(pack -> ModularMetaModelReader.addPackToCollection(modularObjects, pack));
                        }
                        catch (ModularException e) {
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            ModularInstallerMarker.createMarker((IResource)root, e.getMessage());
                            ModularInstallerActivator.getInstance().logError(e.getMessage());
                        }
                    }
                }
                subMonitor.worked(1);
            }
            return modularObjects;
        }
        return Collections.emptySet();
    }

    private static void addPackToCollection(Set<ModularPack> modularObjects, ModularPack pack) {
        if (!modularObjects.contains(pack)) {
            modularObjects.add(pack);
        } else {
            ModularInstallerActivator.getInstance().logWarning(ModularMessages.bind((String)ModularMessages.ModularUtils_DuplicatePack, (Object)(String.valueOf(pack.getName()) + "," + pack.getVersion())));
            ModularUtils.addLastPack(modularObjects, pack);
        }
    }

    public Collection<ModularPack> getInstalledUnit(IProgressMonitor progressMonitor) {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.session.getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        return ModularUtils.getInstalledUnit(profileRegistry, progressMonitor);
    }
}

