/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerMarker;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

public class LoadRepositoryOperation
implements IRunnableWithProgress {
    private URI uri;
    private IArtifactRepositoryManager artifactRepositoryManager;
    private IMetadataRepositoryManager metaRepositorymanager;
    private IMetadataRepository loadRepository;
    private final boolean useTimeOut;
    private final int timeout;

    public LoadRepositoryOperation(String name, URI uri, IMetadataRepositoryManager metaRepositorymanager, IArtifactRepositoryManager artifactRepositoryManager, boolean useTimeout, int timeout) {
        this.uri = uri;
        this.artifactRepositoryManager = artifactRepositoryManager;
        this.metaRepositorymanager = metaRepositorymanager;
        this.useTimeOut = useTimeout;
        this.timeout = timeout;
    }

    public void run(IProgressMonitor monitor) {
        final SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                if (this.useTimeOut) {
                    Job job = new Job(ModularMessages.ModularUtils_TimeoutJobName){

                        protected IStatus run(IProgressMonitor iProgressMonitor) {
                            try {
                                Thread.sleep(LoadRepositoryOperation.this.timeout * 1000);
                            }
                            catch (InterruptedException e) {
                                ModularInstallerActivator.getInstance().logError(e.getMessage());
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            convert.setCanceled(true);
                            String host = LoadRepositoryOperation.this.uri.getHost();
                            if (host == null) {
                                host = LoadRepositoryOperation.this.uri.toString();
                            }
                            ModularInstallerActivator.getInstance().logWarning(NLS.bind((String)ModularMessages.ModularUtils_LoadRepositoryTimeoutWarningMessage, (Object)host));
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            ModularInstallerMarker.createMarker((IResource)root, NLS.bind((String)ModularMessages.ModularUtils_LoadRepositoryTimeoutWarningMessage, (Object)host));
                        }
                    });
                    job.schedule();
                }
                this.artifactRepositoryManager.loadRepository(this.uri, (IProgressMonitor)convert.split(50));
                this.loadRepository = this.metaRepositorymanager.loadRepository(this.uri, (IProgressMonitor)convert.split(50));
                String name = this.metaRepositorymanager.getRepositoryProperty(this.uri, "p2.nickname");
                if ((name == null || name.length() == 0) && (name = this.loadRepository.getName()) != null && name.length() > 0) {
                    this.metaRepositorymanager.setRepositoryProperty(this.uri, "p2.nickname", name);
                }
            }
            catch (OperationCanceledException | ProvisionException e) {
                ModularInstallerActivator.getInstance().logError(e.getMessage());
                convert.done();
            }
        }
        finally {
            convert.done();
        }
    }

    public IMetadataRepository getMetadataRepository() {
        return this.loadRepository;
    }
}

