/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.crosstriggering;

import com.nxp.s32ds.cle.runtime.hardware.registry.HardwareCompatibilityDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.HardwareCompatibilityDescriptors;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.crosstriggering.CrossTriggeringCommonHandler;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.CrossTriggeringButtonsCondition;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.CrossTriggeringSelectionDialog;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.CrossTriggeringState;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.memento.CrossTriggeringContextMemento;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CrossTriggeringSetupHandler
extends CrossTriggeringCommonHandler {
    private static final String SETUP_COMMAND = "xt_set sources %s destinations %s";

    @Override
    protected String generateCommand(ExecutionEvent event) {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        CrossTriggeringSelectionDialog dialog = new CrossTriggeringSelectionDialog(activeShell);
        if (dialog.open() == 0) {
            ArrayList<String> srcSelection = new ArrayList<String>();
            ArrayList<String> dstSelection = new ArrayList<String>();
            List<CrossTriggeringState> states = dialog.getCrossTriggeringStates();
            if (!states.isEmpty()) {
                new CrossTriggeringContextMemento(dialog.getWorkingDeviceId()).saveToMemento(states);
                for (CrossTriggeringState stateObj : states) {
                    String deviceCoreId = this.extractDeviceCoreId(stateObj.getDeviceCoreId());
                    if (stateObj.isSource()) {
                        srcSelection.add(deviceCoreId);
                    }
                    if (!stateObj.isDestination()) continue;
                    dstSelection.add(deviceCoreId);
                }
                if (srcSelection.isEmpty() || dstSelection.isEmpty()) {
                    return null;
                }
                String sources = String.join((CharSequence)" ", srcSelection);
                String destinations = String.join((CharSequence)" ", dstSelection);
                return String.format(SETUP_COMMAND, sources, destinations);
            }
        }
        return null;
    }

    @Override
    protected void afterCommandProceeding() {
        state = CrossTriggeringCommonHandler.State.CONFIGURED;
        CrossTriggeringButtonsCondition.enableRunButton(true);
        CrossTriggeringButtonsCondition.enableSuspendButton(true);
        CrossTriggeringButtonsCondition.enableStopButton(true);
    }

    private String extractDeviceCoreId(String deviceCoreId) {
        HardwareCompatibilityDescriptor hwCompatibility = HardwareCompatibilityDescriptors.getCompatibleHardwareByComponent((String)"s32debugger", (String)deviceCoreId);
        return hwCompatibility == null ? deviceCoreId : hwCompatibility.getHardwareTarget();
    }
}

