/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.ui;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnections;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.storage.sensitive.info.StorageDispatcher;
import com.nxp.s32ds.cle.runtime.storage.sensitive.info.StorageDispatchers;
import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.core.connection.Messages;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DebuggerTabMessages;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import com.nxp.s32ds.debug.ide.ui.DebuggerTabMessages;
import com.nxp.s32ds.debug.ide.ui.ErrorMessages;
import com.nxp.s32ds.debug.ide.ui.S32DebugProbeFirmwareUpdater;
import com.nxp.s32ds.debug.ide.ui.S32DebuggerHardwareDialog;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import com.nxp.s32ds.ext.jfx.ui.FxFileDialog;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class S32DebuggerTab
extends AbstractLaunchConfigurationTab {
    private static final String EMPTY_STRING = "";
    private static final int COMBOS_WIDTH_HINT = 550;
    private static final int TEXT_NEAR_COMBOS_WIDTH_HINT = 564;
    private static final int TEXT_COMMANDS_HEIGHT = 60;
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "com.nxp.s32ds.debug.ide.ui.internal.debuggertab";
    private Group hardware;
    private Label device;
    private Label core;
    private String deviceCoreId;
    private Text initializationScript;
    private Button initialCore;
    private Group debugProbeConnection;
    private Combo debugInterface;
    private Combo deviceUSB;
    private Button refresh;
    private Button btnTestConnection;
    private Text hostNameOrIp;
    private Text commandConnectionServerIp;
    private Text commandConnectionServerPort;
    private Composite parentDebugProbeConnection;
    private Group targetCommunicationSpeed;
    private Text jtagSpeed;
    private Text remoteTimeout;
    private Button resetAndDelay;
    private Text delay;
    private Group gdbServer;
    private Button launchServer;
    private Text serverPort;
    private Button enableLog;
    private Group gdbClient;
    private Button btnClientSelection;
    private Text txtClientExecutable;
    private Text txtClientCommands;
    private Group semihosting;
    private Button enableSemihosting;
    private Text semihostingPort;
    private Group secureDebugger;
    private Button btnEnableSecureDebugging;
    private Combo cmbSecureType;
    private Button btnResetDataStored;
    private boolean doLaunchServer = true;
    private boolean isLogEnabled = false;
    private boolean isSemihostingEnabled = true;
    private boolean ccsRemoteSupported = false;
    private Button forceThreadListUpdateOnSuspend;
    private String launchConfigurationName;
    private String deviceRevision;
    private DeviceConnection[] activeConnections;
    private boolean firstActivated;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createHardwareGroup(composite);
        this.createDebugProbeConnectionGroup(composite);
        this.createTargetCommunicationSpeedGroup(composite);
        this.createGdbServerGroup(composite);
        this.createGdbClientGroup(composite);
        this.createSemihostingGroup(composite);
        this.createSecureDebuggingGroup(composite);
        this.launchConfigurationName = EMPTY_STRING;
        this.firstActivated = true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        super.activated(workingCopy);
        if (this.firstActivated) {
            S32DebugProbeFirmwareUpdater.updateFW106IfNeeded();
            this.firstActivated = false;
        }
    }

    public boolean isCcsRemoteSupported() {
        return this.ccsRemoteSupported;
    }

    public void setCcsRemoteSupported(boolean ccsRemoteSupported) {
        this.ccsRemoteSupported = ccsRemoteSupported;
    }

    private void createHardwareGroup(Composite parent) {
        this.hardware = SWTUtils.createGroup((Composite)parent, (int)5, (String)DebuggerTabMessages.DebuggerTab_hardware_group);
        SWTUtils.createLabel((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_device_label);
        this.device = SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_not_specified_label, (int)150);
        SWTUtils.createLabel((Composite)this.hardware, (String)S32DebuggerTabMessages.S32DebuggerTab_core_label);
        this.core = SWTUtils.createLabel((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_not_specified_label);
        GridDataFactory.swtDefaults().grab(true, false).minSize(250, 0).applyTo((Control)this.core);
        Button selectDeviceAndCore = SWTUtils.createButton((Composite)this.hardware, (String)S32DebuggerTabMessages.S32DebuggerTab_select_device_and_core_button, (int)0);
        selectDeviceAndCore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.handleSelectDevice();
            }
        });
        Composite local = SWTUtils.createGridCellComposite((Composite)this.hardware, (int)5, (int)4);
        SWTUtils.createLabel((Composite)local, (String)DebuggerTabMessages.DebuggerTab_initialization_script_label);
        this.initializationScript = SWTUtils.createWideText((Composite)local, (int)2052, (boolean)true, (int)1);
        this.initializationScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        Button browse = SWTUtils.createButton((Composite)local, (String)DebuggerTabMessages.DebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.browseButtonSelected(DebuggerTabMessages.DebuggerTab_browse_initialization_script_title, S32DebuggerTab.this.initializationScript);
            }
        });
        Button variables = SWTUtils.createButton((Composite)local, (String)DebuggerTabMessages.DebuggerTab_variable_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.variablesButtonSelected(S32DebuggerTab.this.initializationScript);
            }
        });
        this.initialCore = SWTUtils.createButton((Composite)local, (String)DebuggerTabMessages.DebuggerTab_initial_core, (int)32);
        this.initialCore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.initialCoreStateChanged(S32DebuggerTab.this.activeConnections[0].isUsbConnection());
            }
        });
    }

    private void initialCoreStateChanged(boolean isUsbConnection) {
        boolean areInitialCoreSettingsEnabled = this.initialCore.getSelection();
        boolean isRemoteProbeEnabled = false;
        this.debugInterface.setEnabled(areInitialCoreSettingsEnabled);
        this.jtagSpeed.setEnabled(areInitialCoreSettingsEnabled);
        this.remoteTimeout.setEnabled(areInitialCoreSettingsEnabled);
        this.resetAndDelay.setEnabled(areInitialCoreSettingsEnabled);
        this.launchServer.setEnabled(areInitialCoreSettingsEnabled);
        this.enableSemihosting.setEnabled(areInitialCoreSettingsEnabled);
        if (this.commandConnectionServerIp != null && this.commandConnectionServerPort != null) {
            isRemoteProbeEnabled = !this.commandConnectionServerIp.getText().equals("127.0.0.1");
            this.commandConnectionServerIp.setEnabled(areInitialCoreSettingsEnabled);
            this.commandConnectionServerPort.setEnabled(areInitialCoreSettingsEnabled);
        }
        if (areInitialCoreSettingsEnabled) {
            this.deviceUSB.setEnabled(!isRemoteProbeEnabled && isUsbConnection);
            this.refresh.setEnabled(!isRemoteProbeEnabled && isUsbConnection);
            this.hostNameOrIp.setEnabled(!isUsbConnection);
            this.delay.setEnabled(this.resetAndDelay.getSelection());
            this.launchServer.setSelection(this.doLaunchServer);
            this.enableSemihosting.setSelection(this.isSemihostingEnabled);
            this.enableLog.setSelection(this.isLogEnabled);
            this.setBtnTestConnection(isUsbConnection);
        } else {
            this.deviceUSB.setEnabled(false);
            this.refresh.setEnabled(false);
            this.hostNameOrIp.setEnabled(false);
            this.delay.setEnabled(false);
            this.doLaunchServer = this.launchServer.getSelection();
            this.launchServer.setSelection(false);
            this.isSemihostingEnabled = this.enableSemihosting.getSelection();
            this.enableSemihosting.setSelection(false);
            this.isLogEnabled = this.enableLog.getSelection();
            this.enableLog.setSelection(false);
            this.btnEnableSecureDebugging.setSelection(false);
            this.btnTestConnection.setEnabled(false);
        }
        this.enableLog.setEnabled(this.launchServer.getSelection());
        this.updateSecureDebuggingState(areInitialCoreSettingsEnabled);
        this.scheduleUpdateJob();
    }

    private void createDebugProbeConnectionGroup(Composite parent) {
        this.parentDebugProbeConnection = parent;
        this.debugProbeConnection = SWTUtils.createGroup((Composite)parent, (int)4, (String)DebuggerTabMessages.DebuggerTab_debug_probe_connection_group);
        SWTUtils.createLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_interface_label);
        this.debugInterface = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.debugProbeConnection, (int)8, (int)550, (int)3);
        DebuggerConnections.getDebuggerConnectionDeviceDescriptors((String)"s32debugger").stream().sorted((d1, d2) -> d1.getPriority() - d2.getPriority()).forEach(descriptor -> this.debugInterface.add(descriptor.getConnectionName()));
        if (this.debugInterface.getItemCount() > 0) {
            this.debugInterface.select(0);
        }
        this.debugInterface.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.debugInterfaceChanged(S32DebuggerTab.this.debugInterface.getText());
                S32DebuggerTab.this.remoteProbeConnectionChanged();
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_usb_device);
        this.deviceUSB = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.debugProbeConnection, (int)8, (int)550, (int)1);
        this.deviceUSB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.refresh = SWTUtils.createButtonWithHorizontalSpan((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_refresh_button, (int)0, (int)1);
        this.refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebuggerConnectionDescriptor devDescriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName((String)S32DebuggerTab.this.debugInterface.getText());
                String connectionId = devDescriptor.getConnectionName();
                DebuggerConnectionAccessor conAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)connectionId);
                if (conAccessor != null) {
                    S32DebuggerTab.this.updateUSBDevices(conAccessor, devDescriptor);
                    S32DebuggerTab.this.scheduleUpdateJob();
                }
            }
        });
        this.btnTestConnection = SWTUtils.createButtonWithHorizontalSpan((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_test_connection_button, (int)0, (int)1);
        this.btnTestConnection.setEnabled(false);
        this.btnTestConnection.addListener(13, event -> {
            String connectionString = DebuggerUtils.getConnectionStringForDeviceConnection((String)this.getActiveConnectionData());
            try {
                RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.debug.ide.s32debugger.ui.testConnectionStatusHandler", (IStatus)new Status(1, S32DebuggerCoreActivator.getDefault().getBundleId(), EMPTY_STRING), (Object)connectionString);
            }
            catch (CoreException coreException) {
                S32DebuggerCoreActivator.getDefault().logError(S32DebuggerErrorMessages.S32DebuggerCannotHandleStatusCall_message);
            }
        });
        SWTUtils.createLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_hostname_or_ip_label);
        this.hostNameOrIp = SWTUtils.createTextWithWidthHint((Composite)this.debugProbeConnection, (int)2048, (int)564, (int)2);
        this.hostNameOrIp.addListener(1, event -> {
            if (event.keyCode == 45 && this.hostNameOrIp.getText().contains(".")) {
                event.doit = false;
            }
            if (event.keyCode == 32) {
                event.doit = false;
            }
        });
        this.hostNameOrIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (S32DebuggerTab.this.activeConnections != null) {
                    S32DebuggerTab.this.activeConnections[0].setDeviceConnectionData(S32DebuggerTab.this.hostNameOrIp.getText());
                }
                S32DebuggerTab.this.setBtnTestConnection(false);
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createAdvancedSettings(S32DebuggerParams debuggerParams) {
        if (this.commandConnectionServerIp != null) {
            return;
        }
        Composite advancedSectionComposite = SWTUtils.createGridCellCompositeWithVerticalAndHorizontalMargin((Composite)this.debugProbeConnection, (int)5, (int)1, (int)5, (int)5);
        ExpandableComposite advancedSectionExpandable = new ExpandableComposite(advancedSectionComposite, 16386);
        advancedSectionExpandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Composite parentComposite = S32DebuggerTab.this.parentDebugProbeConnection.getParent();
                if (parentComposite instanceof ScrolledComposite) {
                    ScrolledComposite scrolledComposite = (ScrolledComposite)parentComposite;
                    scrolledComposite.setMinSize(scrolledComposite.getContent().computeSize(-1, -1));
                    scrolledComposite.layout(true, true);
                }
            }
        });
        Composite advanced = SWTUtils.createGridCellComposite((Composite)advancedSectionExpandable, (int)200, (int)1);
        advanced.setVisible(false);
        advancedSectionExpandable.setText(DebuggerTabMessages.DebuggerTab_advanced_section_expandable);
        advancedSectionExpandable.setClient((Control)advanced);
        Composite localCommandConnectionServerIpAndPort = SWTUtils.createGridCellCompositeWithVerticalAndHorizontalMargin((Composite)advanced, (int)4, (int)4, (int)5, (int)5);
        Label commandConnectionServerIpLabel = SWTUtils.createLabelWithHorizontalIndent((Composite)localCommandConnectionServerIpAndPort, (String)DebuggerTabMessages.DebuggerTab_command_connection_server_ip_label, (int)20);
        this.commandConnectionServerIp = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)localCommandConnectionServerIpAndPort, (int)2052, (int)5, (int)90);
        this.commandConnectionServerIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.remoteProbeConnectionChanged();
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.commandConnectionServerIp.setText(debuggerParams.getCommandConnectionServerIp());
        Label commandConnectionServerPortLabel = SWTUtils.createLabelWithHorizontalIndent((Composite)localCommandConnectionServerIpAndPort, (String)DebuggerTabMessages.DebuggerTab_command_connection_server_port_label, (int)5);
        commandConnectionServerIpLabel.setToolTipText(DebuggerTabMessages.DebuggerTab_command_connection_server_ip_tooltip);
        this.commandConnectionServerPort = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)localCommandConnectionServerIpAndPort, (int)2052, (int)5, (int)50);
        this.commandConnectionServerPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.commandConnectionServerPort.setText(debuggerParams.getCommandConnectionServerPort());
        commandConnectionServerPortLabel.setToolTipText(DebuggerTabMessages.DebuggerTab_command_connection_server_port_tooltip);
    }

    private void debugInterfaceChanged(String selectedInterface) {
        DebuggerConnectionDescriptor devDescriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName((String)selectedInterface);
        boolean isUsbUsed = !devDescriptor.isEthernetConnection();
        String connectionId = devDescriptor.getConnectionName();
        DebuggerConnectionAccessor conAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)connectionId);
        this.deviceUSB.setEnabled(isUsbUsed);
        this.refresh.setEnabled(isUsbUsed);
        this.hostNameOrIp.setEnabled(!isUsbUsed);
        this.setBtnTestConnection(isUsbUsed);
        DeviceConnection connection = new DeviceConnection(connectionId, !isUsbUsed);
        this.activeConnections = new DeviceConnection[]{connection};
        if (conAccessor != null) {
            String baseSpeed = conAccessor.getBaseSpeed();
            if (!baseSpeed.isEmpty()) {
                this.jtagSpeed.setText(baseSpeed);
            } else {
                this.jtagSpeed.setText("16000");
            }
            if (isUsbUsed) {
                String curDevice = this.deviceUSB.getText();
                this.updateUSBDevices(conAccessor, devDescriptor);
                this.setUSBDevice(curDevice);
                if (this.deviceUSB.getSelectionIndex() == -1) {
                    this.deviceUSB.select(0);
                }
            } else {
                connection.setDeviceConnectionData(this.hostNameOrIp.getText());
            }
        } else {
            S32DebuggerCoreActivator.getDefault().logError(NLS.bind((String)Messages.Debugger_no_device_accessor, (Object)connectionId));
        }
        this.scheduleUpdateJob();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        S32DebuggerAttributesValidator validator = new S32DebuggerAttributesValidator();
        S32DebuggerParams debuggerParams = S32DebuggerParams.getParams((ILaunchConfiguration)config);
        ArrayList errorsAndWarnings = validator.validateDebuggerParameters(debuggerParams, false);
        ArrayList errors = (ArrayList)errorsAndWarnings.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (errors.size() != 0) {
            this.setErrorMessage(((IStatus)errors.get(0)).getMessage());
            return false;
        }
        if (errorsAndWarnings.size() != 0) {
            this.setWarningMessage(((IStatus)errorsAndWarnings.get(0)).getMessage());
            return true;
        }
        return true;
    }

    private void createTargetCommunicationSpeedGroup(Composite parent) {
        this.targetCommunicationSpeed = SWTUtils.createGroup((Composite)parent, (int)5, (String)DebuggerTabMessages.DebuggerTab_target_communication_speed_group);
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_jtag_speed_label);
        int widthHint = 50;
        this.jtagSpeed = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)widthHint, (int)1);
        this.jtagSpeed.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabelWithHorizontalIndent((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_timeout_label, (int)25);
        this.remoteTimeout = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)widthHint, (int)1);
        this.remoteTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_timeout_unit_of_measure_label);
        this.resetAndDelay = SWTUtils.createButton((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_reset_and_delay_button, (int)32);
        this.resetAndDelay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.delay.setEnabled(((Button)e.getSource()).getSelection());
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.delay = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)widthHint, (int)1);
        this.delay.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_delay_unit_of_measure_label);
    }

    private void createGdbServerGroup(Composite parent) {
        this.gdbServer = SWTUtils.createGroup((Composite)parent, (int)2, (String)DebuggerTabMessages.DebuggerTab_gdb_server_group);
        this.launchServer = SWTUtils.createButtonWithHorizontalSpan((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_launch_server_button, (int)32, (int)2);
        this.launchServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isServerLaunched = S32DebuggerTab.this.launchServer.getSelection();
                S32DebuggerTab.this.enableLog.setEnabled(isServerLaunched);
                if (!isServerLaunched) {
                    S32DebuggerTab.this.isLogEnabled = S32DebuggerTab.this.enableLog.getSelection();
                    S32DebuggerTab.this.enableLog.setSelection(false);
                } else {
                    S32DebuggerTab.this.enableLog.setSelection(S32DebuggerTab.this.isLogEnabled);
                }
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label serverPortNumberLabel = SWTUtils.createLabel((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_server_port_number_label);
        serverPortNumberLabel.setToolTipText(DebuggerTabMessages.DebuggerTab_server_port_tooltip);
        this.serverPort = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)this.gdbServer, (int)2052, (int)5, (int)40);
        this.serverPort.setTextLimit(5);
        this.serverPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String serverPortText = S32DebuggerTab.this.serverPort.getText().trim();
                if (serverPortText.isEmpty()) {
                    S32DebuggerTab.this.semihostingPort.setText(S32DebuggerTab.EMPTY_STRING);
                } else {
                    Integer serverPortNumber = null;
                    try {
                        serverPortNumber = Integer.parseInt(serverPortText);
                        S32DebuggerTab.this.semihostingPort.setText(Integer.toString(serverPortNumber + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        S32DebuggerTab.this.semihostingPort.setText(S32DebuggerTab.EMPTY_STRING);
                    }
                }
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.enableLog = SWTUtils.createButton((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_enable_log, (int)32);
        this.enableLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createGdbClientGroup(Composite parent) {
        this.gdbClient = SWTUtils.createGroup((Composite)parent, (int)5, (String)DebuggerTabMessages.DebuggerTab_gdb_client_group);
        SWTUtils.createLabel((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_executable_label);
        this.txtClientExecutable = SWTUtils.createWideText((Composite)this.gdbClient, (int)2052, (boolean)true, (int)1);
        this.txtClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.btnClientSelection = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_select_executable, (int)0);
        this.btnClientSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstResult;
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(S32DebuggerTab.this.getShell(), (ILabelProvider)new LabelProvider());
                dialog.setTitle(DebuggerTabMessages.DebuggerTab_select_executable_dialog);
                dialog.setMessage(DebuggerTabMessages.DebuggerTab_selection_dialog_text_hint);
                dialog.setMultipleSelection(false);
                DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)S32DebuggerTab.this.deviceCoreId);
                Collection gdbClients = CoreDebuggerDescriptors.getClientPaths((String)deviceCoreDescriptor.getCoreId(), (String)S32DebuggerTab.this.getDebuggerID());
                dialog.setHelpAvailable(false);
                dialog.setIgnoreCase(true);
                dialog.setElements((Object[])gdbClients.toArray(new String[gdbClients.size()]));
                if (dialog.open() == 0 && (firstResult = dialog.getFirstResult()) instanceof String) {
                    S32DebuggerTab.this.txtClientExecutable.setText((String)dialog.getFirstResult());
                }
            }
        });
        this.btnClientSelection.setEnabled(false);
        Button browse = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.browseButtonSelected(DebuggerTabMessages.DebuggerTab_browse_gdb_client_title, S32DebuggerTab.this.txtClientExecutable);
            }
        });
        Button variables = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_variable_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.variablesButtonSelected(S32DebuggerTab.this.txtClientExecutable);
            }
        });
        SWTUtils.createLabelWithVerticalAlignment((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_commands_label, (int)1);
        this.txtClientCommands = SWTUtils.createWideTextWithHeightHint((Composite)this.gdbClient, (int)2626, (boolean)true, (int)4, (int)60);
        this.txtClientCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.forceThreadListUpdateOnSuspend = SWTUtils.createButtonWithHorizontalSpan((Composite)this.gdbClient, (String)S32DebuggerTabMessages.S32DebuggerTab_force_thread_list_update_on_suspend, (int)32, (int)5);
        this.forceThreadListUpdateOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createSemihostingGroup(Composite parent) {
        this.semihosting = SWTUtils.createGroup((Composite)parent, (int)2, (String)S32DebuggerTabMessages.S32DebuggerTab_semihosting_group);
        this.enableSemihosting = SWTUtils.createButtonWithHorizontalSpan((Composite)this.semihosting, (String)S32DebuggerTabMessages.S32DebuggerTab_enable_semihosting_button, (int)32, (int)2);
        this.enableSemihosting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.semihosting, (String)S32DebuggerTabMessages.S32DebuggerTab_semihosting_port_label);
        this.semihostingPort = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)this.semihosting, (int)2052, (int)5, (int)40);
        this.semihostingPort.setTextLimit(5);
        this.semihostingPort.setEnabled(false);
        this.semihostingPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createSecureDebuggingGroup(Composite parent) {
        this.secureDebugger = SWTUtils.createGroup((Composite)parent, (int)3, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_group);
        this.btnEnableSecureDebugging = SWTUtils.createButtonWithHorizontalSpan((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_button, (int)32, (int)3);
        this.btnEnableSecureDebugging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useSecureDebugging = S32DebuggerTab.this.btnEnableSecureDebugging.getSelection();
                S32DebuggerTab.this.checkClearSecureDataState(S32DebuggerTab.this.launchConfigurationName, useSecureDebugging);
                if (useSecureDebugging) {
                    S32DebuggerTab.this.cmbSecureType.setEnabled(true);
                    if (S32DebuggerTab.this.cmbSecureType.getText().isEmpty()) {
                        S32DebuggerTab.this.cmbSecureType.select(0);
                    }
                } else {
                    S32DebuggerTab.this.cmbSecureType.setEnabled(false);
                }
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_type);
        this.cmbSecureType = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.secureDebugger, (int)8, (int)550, (int)1);
        this.cmbSecureType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.cmbSecureType.add(DebuggerTabMessages.DebuggerTab_secure_debugging_PwD);
        if ("win32".equals(Platform.getOS())) {
            this.cmbSecureType.add(DebuggerTabMessages.DebuggerTab_secure_debugging_C_R);
        }
        this.cmbSecureType.setEnabled(false);
        this.btnResetDataStored = SWTUtils.createButtonWithHorizontalSpan((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_clear_lc_data, (int)8, (int)1);
        this.btnResetDataStored.setEnabled(false);
        this.btnResetDataStored.addListener(13, event -> {
            StorageDispatcher dispatcher = StorageDispatchers.getStorageDispatcher();
            if (dispatcher != null && dispatcher.resetProtectedSettings(this.launchConfigurationName)) {
                this.btnResetDataStored.setEnabled(false);
            } else {
                DebuggerCoreActivator.getInstance().logError(ErrorMessages.CannotResetLCStorageData_error_message);
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        String str;
        FxFileDialog dialog;
        block3: {
            dialog = new FxFileDialog(this.getControl().getParent(), this.getShell(), 4096);
            dialog.setText(title);
            try {
                String pathScriptFolder = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.getScriptFolderVariable());
                dialog.setFilterPath(Paths.get(pathScriptFolder, new String[0]).normalize().toString());
            }
            catch (CoreException coreException) {
                str = text.getText().trim();
                int lastSeparatorIndex = str.lastIndexOf(File.separator);
                if (lastSeparatorIndex == -1) break block3;
                dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
            }
        }
        str = dialog.open();
        if (str != null) {
            text.setText(str);
        }
    }

    private void remoteProbeConnectionChanged() {
        DebuggerConnectionDescriptor devDescriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName((String)this.debugInterface.getText());
        boolean isUsbConnection = !devDescriptor.isEthernetConnection();
        boolean isLocalConnection = true;
        if (this.commandConnectionServerIp != null) {
            isLocalConnection = this.commandConnectionServerIp.getText().equals("127.0.0.1");
        }
        this.deviceUSB.setEnabled(isUsbConnection && isLocalConnection);
        this.refresh.setEnabled(isUsbConnection && isLocalConnection);
        this.setBtnTestConnection(isUsbConnection);
    }

    protected String getScriptFolderVariable() {
        return "${S32DS_INITIALIZATION_SCRIPTS_DIR}";
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.setText(dialog.getVariableExpression());
        }
    }

    public String getName() {
        return TAB_NAME;
    }

    public String getId() {
        return TAB_ID;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerParams.applyDefaults((ILaunchConfigurationWorkingCopy)lc);
    }

    private static void setDefaultElementForCombo(Combo combo, String text) {
        String[] comboItems = combo.getItems();
        if (!text.isEmpty()) {
            int i = 0;
            while (i < comboItems.length) {
                if (text.contains(comboItems[i])) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
        combo.select(0);
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        this.launchConfigurationName = lc.getName();
        S32DebuggerParams debuggerParams = S32DebuggerParams.getParams((ILaunchConfiguration)lc);
        this.deviceCoreId = debuggerParams.getDeviceCoreId();
        if (!EMPTY_STRING.equals(this.deviceCoreId)) {
            this.deviceRevision = debuggerParams.getDeviceRevision();
            DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)this.deviceCoreId);
            if (deviceCoreDescriptor != null && deviceCoreDescriptor.getCcsRemoteSupport()) {
                this.createAdvancedSettings(debuggerParams);
            }
            this.setDeviceUINames(deviceCoreDescriptor);
        } else {
            this.device.setText(DebuggerTabMessages.DebuggerTab_not_specified_label);
            this.core.setText(DebuggerTabMessages.DebuggerTab_not_specified_label);
            this.deviceRevision = null;
        }
        this.btnClientSelection.setEnabled(!this.deviceCoreId.isEmpty());
        this.initializationScript.setText(debuggerParams.getInitializationScript());
        this.initialCore.setSelection(debuggerParams.isInitialCore());
        boolean isUsbConnection = this.initializeConnectionData(debuggerParams.getDevicePort());
        this.deviceUSB.setEnabled(isUsbConnection);
        this.refresh.setEnabled(isUsbConnection);
        this.hostNameOrIp.setEnabled(!isUsbConnection);
        this.jtagSpeed.setText(debuggerParams.getJtagSpeedKHz());
        this.remoteTimeout.setText(debuggerParams.getRemoteTimeoutInSeconds());
        this.resetAndDelay.setSelection(debuggerParams.isDoResetAndDelay());
        this.delay.setText(debuggerParams.getDelayInMSeconds());
        this.doLaunchServer = debuggerParams.isDoLaunchServer();
        this.launchServer.setSelection(this.doLaunchServer);
        this.serverPort.setText(debuggerParams.getServerPort());
        this.isLogEnabled = debuggerParams.isLogEnabled();
        this.enableLog.setSelection(debuggerParams.isLogEnabled());
        this.txtClientExecutable.setText(debuggerParams.getClientExecutable());
        this.txtClientCommands.setText(debuggerParams.getClientCommands());
        this.isSemihostingEnabled = debuggerParams.isSemihostingEnabled();
        this.enableSemihosting.setSelection(this.isSemihostingEnabled);
        this.semihostingPort.setText(debuggerParams.getSemihostingPort());
        this.forceThreadListUpdateOnSuspend.setSelection(debuggerParams.isForceThreadListUpdateOnSuspend());
        boolean useSecureDebugging = debuggerParams.isUseSecureDebugging();
        this.btnEnableSecureDebugging.setSelection(useSecureDebugging);
        this.cmbSecureType.setEnabled(useSecureDebugging);
        if (useSecureDebugging) {
            String secureType = debuggerParams.getSecureDebuggingType();
            if ("CR".equals(secureType)) {
                S32DebuggerTab.setDefaultElementForCombo(this.cmbSecureType, DebuggerTabMessages.DebuggerTab_secure_debugging_C_R);
            } else {
                S32DebuggerTab.setDefaultElementForCombo(this.cmbSecureType, DebuggerTabMessages.DebuggerTab_secure_debugging_PwD);
            }
        }
        this.initialCoreStateChanged(isUsbConnection);
        this.checkClearSecureDataState(this.launchConfigurationName, useSecureDebugging);
        ArrayList readErrors = debuggerParams.getReadErrors();
        if (!readErrors.isEmpty()) {
            AttributeReadingUtils.handleAttributeReadingFailure((IStatus)S32DebuggerErrorStatuses.getAttributesReadingFailedStatus((List)readErrors));
        }
        this.scheduleUpdateJob();
    }

    public void performApply(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerParams debuggerParams = new S32DebuggerParams();
        debuggerParams.setDeviceCoreId(this.deviceCoreId);
        debuggerParams.setDeviceRevision(this.deviceRevision);
        debuggerParams.setInitializationScript(this.initializationScript.getText().trim());
        debuggerParams.setInitialCore(this.initialCore.getSelection());
        if (this.activeConnections != null && debuggerParams.isInitialCore()) {
            debuggerParams.setDevicePort(this.getActiveConnectionData());
        } else {
            debuggerParams.setDevicePort(EMPTY_STRING);
        }
        debuggerParams.setJtagSpeedKHz(this.jtagSpeed.getText().trim());
        debuggerParams.setRemoteTimeoutInSeconds(this.remoteTimeout.getText().trim());
        debuggerParams.setDoResetAndDelay(this.resetAndDelay.getSelection());
        debuggerParams.setDelayInMSeconds(this.delay.getText().trim());
        debuggerParams.setDoLaunchServer(this.launchServer.getSelection());
        debuggerParams.setServerPort(this.serverPort.getText().trim());
        debuggerParams.setClientExecutable(this.txtClientExecutable.getText().trim());
        debuggerParams.setClientCommands(this.txtClientCommands.getText());
        debuggerParams.setForceThreadListUpdateOnSuspend(this.forceThreadListUpdateOnSuspend.getSelection());
        debuggerParams.setLogEnabled(this.enableLog.getSelection());
        debuggerParams.setSemihostingEnabled(this.enableSemihosting.getSelection());
        debuggerParams.setSemihostingPort(this.semihostingPort.getText().trim());
        if (this.commandConnectionServerIp != null && this.commandConnectionServerPort != null) {
            debuggerParams.setCommandConnectionServerIp(this.commandConnectionServerIp.getText().trim());
            debuggerParams.setCommandConnectionServerPort(this.commandConnectionServerPort.getText().trim());
        }
        boolean useSecureDebugging = this.btnEnableSecureDebugging.getSelection();
        debuggerParams.setUseSecureDebugging(useSecureDebugging);
        if (useSecureDebugging) {
            String secureType = this.cmbSecureType.getText();
            if (DebuggerTabMessages.DebuggerTab_secure_debugging_C_R.equals(secureType)) {
                debuggerParams.setSecureDebuggingType("CR");
            } else {
                debuggerParams.setSecureDebuggingType("PWD");
            }
        } else {
            debuggerParams.setSecureDebuggingType(EMPTY_STRING);
        }
        debuggerParams.applyParams(lc);
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    private void addUSBDevices(Collection<DeviceConnection> activeConnections, String deviceToSelect) {
        activeConnections.stream().forEach(connection -> {
            this.deviceUSB.add(connection.getDeviceUiFriendlyName());
            if (connection.getDeviceConnectionData().equals(deviceToSelect)) {
                this.deviceUSB.select(this.deviceUSB.getItemCount() - 1);
            }
        });
        if (this.deviceUSB.getSelectionIndex() == -1) {
            this.deviceUSB.select(0);
        }
        this.activeConnections = (DeviceConnection[])activeConnections.stream().toArray(DeviceConnection[]::new);
    }

    private void updateUSBDevices(DebuggerConnectionAccessor conAccessor, DebuggerConnectionDescriptor conDescriptor) {
        boolean hasDevices;
        this.deviceUSB.removeAll();
        Collection devices = conAccessor.getActiveDeviceConnections(conDescriptor);
        boolean bl = hasDevices = !devices.isEmpty();
        if (hasDevices) {
            this.addUSBDevices(conAccessor.getActiveDeviceConnections(conDescriptor), null);
        }
        this.setBtnTestConnection(true);
    }

    private void setUSBDevice(String oldDevice) {
        String[] stringArray = this.deviceUSB.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String curDevice = stringArray[n2];
            if (oldDevice.equals(curDevice)) {
                this.deviceUSB.select(this.deviceUSB.indexOf(curDevice));
                break;
            }
            ++n2;
        }
    }

    protected String getDebuggerID() {
        return "s32debugger";
    }

    private void handleSelectDevice() {
        S32DebuggerHardwareDialog dialog = new S32DebuggerHardwareDialog(this.getShell(), DebuggerTabMessages.DebuggerTab_select_target_device_and_core_dialog, this.getDebuggerID());
        if (dialog.open() != 0) {
            return;
        }
        EntityDescriptor selectedDescriptor = dialog.getDescriptor();
        if (selectedDescriptor == null || !(selectedDescriptor instanceof DeviceCoreDescriptor)) {
            S32DebuggerCoreActivator.getDefault().logError(ErrorMessages.S32DebuggerHWDialog_unexpected_null_result_error_message);
            return;
        }
        DeviceCoreDescriptor deviceCoreDescriptor = (DeviceCoreDescriptor)selectedDescriptor;
        this.deviceCoreId = deviceCoreDescriptor.getId();
        this.deviceRevision = dialog.getDeviceRevision();
        this.setDeviceUINames(deviceCoreDescriptor);
        this.updateSecureDebuggingState(this.initialCore.getSelection());
        String initScript = DeviceCoreDebuggerDescriptors.getInitScript((String)this.deviceCoreId, (String)this.getDebuggerID());
        if (initScript.isEmpty() && (initScript = DebuggerDescriptors.getDeviceCoreDebuggerConfigurationScript((String)this.getDebuggerID(), (String)this.deviceCoreId)).isEmpty()) {
            initScript = DebuggerDescriptors.getDeviceDebuggerConfigurationScript((String)this.getDebuggerID(), (String)deviceCoreDescriptor.getDeviceId());
        }
        this.initializationScript.setText(initScript);
        this.txtClientExecutable.setText(CoreDebuggerDescriptors.getClientPath((String)deviceCoreDescriptor.getCoreId(), (String)this.getDebuggerID()));
        this.btnClientSelection.setEnabled(!this.deviceCoreId.isEmpty());
        String registeredClientCommand = (String)S32DebuggerCoreActivator.getDeviceClientCommands().get(deviceCoreDescriptor.getId());
        if (registeredClientCommand != null) {
            this.txtClientCommands.setText(registeredClientCommand);
        } else {
            this.txtClientCommands.setText(EMPTY_STRING);
        }
    }

    private void setDeviceUINames(DeviceCoreDescriptor deviceCoreDescriptor) {
        if (deviceCoreDescriptor != null) {
            String coreName = deviceCoreDescriptor.getName();
            String clusterId = deviceCoreDescriptor.getClusterId();
            if (!clusterId.isEmpty()) {
                String clusterName = DeviceDescriptors.getDeviceRegistry().getClusterDescriptor(deviceCoreDescriptor.getClusterId()).getName();
                this.core.setText(NLS.bind((String)S32DebuggerTabMessages.S32DebuggerTab_core_with_cluster_description, (Object)coreName, (Object)clusterName));
            } else {
                this.core.setText(coreName);
            }
            DeviceDescriptor dDescriptor = DeviceDescriptors.getDeviceDescriptor((String)deviceCoreDescriptor.getDeviceId());
            if (dDescriptor != null) {
                if (this.deviceRevision == null || this.deviceRevision.isEmpty()) {
                    this.device.setText(dDescriptor.getName());
                } else {
                    this.device.setText(String.valueOf(dDescriptor.getName()) + "_" + this.deviceRevision);
                }
            }
        }
    }

    private void checkClearSecureDataState(String lcName, boolean enableButton) {
        if (enableButton) {
            StorageDispatcher dispatcher = StorageDispatchers.getStorageDispatcher();
            if (dispatcher != null && dispatcher.getProtectedSettings(lcName) != null) {
                this.btnResetDataStored.setEnabled(true);
            }
        } else {
            this.btnResetDataStored.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean initializeConnectionData(String connectionString) {
        DebuggerConnectionDescriptor devDescriptor;
        DebuggerConnectionAccessor devAccessor;
        String connectionId;
        this.deviceUSB.removeAll();
        this.hostNameOrIp.setText(EMPTY_STRING);
        boolean isUsbConnection = false;
        String friendlyName = null;
        DeviceConnection connection = DeviceConnection.createFromFullConnectionString((String)connectionString);
        if (connection != null) {
            connectionId = connection.getDeviceConnectionId();
            devAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)connectionId);
            if (devAccessor == null) {
                S32DebuggerCoreActivator.getDefault().logError(NLS.bind((String)Messages.Debugger_no_device_accessor, (Object)connectionId));
                return false;
            }
            devDescriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName((String)connectionId);
            friendlyName = connection.getDeviceUiFriendlyName();
        } else {
            Optional descriptorOpt = DebuggerConnections.getDebuggerConnectionDeviceDescriptors((String)"s32debugger").stream().sorted((d1, d2) -> d1.getPriority() - d2.getPriority()).findFirst();
            if (!descriptorOpt.isPresent()) {
                S32DebuggerCoreActivator.getDefault().logError(Messages.Debugger_no_device_descriptors);
                return false;
            }
            devDescriptor = (DebuggerConnectionDescriptor)descriptorOpt.get();
            devAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)devDescriptor.getConnectionName());
            connection = new DeviceConnection(devDescriptor.getConnectionName(), devDescriptor.isEthernetConnection());
            connectionId = connection.getDeviceConnectionId();
        }
        S32DebuggerTab.setDefaultElementForCombo(this.debugInterface, connectionId);
        isUsbConnection = connection.isUsbConnection();
        if (!isUsbConnection) {
            this.hostNameOrIp.setText(connection.getDeviceConnectionData());
            this.activeConnections = new DeviceConnection[]{connection};
            return isUsbConnection;
        }
        Collection devicesActive = devAccessor.getActiveDeviceConnections(devDescriptor);
        if (!devicesActive.isEmpty()) {
            this.addUSBDevices(devicesActive, friendlyName);
            return isUsbConnection;
        }
        if (!connection.getDeviceConnectionData().isEmpty()) {
            connection.setDeviceConnectionData(EMPTY_STRING);
        }
        if (!connection.getDeviceUiFriendlyName().isEmpty()) {
            connection.setDeviceUiFriendlyName(EMPTY_STRING);
        }
        this.activeConnections = new DeviceConnection[]{connection};
        return isUsbConnection;
    }

    private String getActiveConnectionData() {
        int index;
        String connectionData = null;
        if (this.activeConnections[0].isUsbConnection() && (index = this.deviceUSB.getSelectionIndex()) != -1) {
            connectionData = this.activeConnections[index].getFullConnectionString();
        }
        if (connectionData == null) {
            connectionData = this.activeConnections[0].getFullConnectionString();
        }
        return connectionData;
    }

    private void updateSecureDebuggingState(boolean initialSelected) {
        if (!EMPTY_STRING.equals(this.deviceCoreId)) {
            DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)this.deviceCoreId);
            if (deviceCoreDescriptor != null) {
                String deviceId = deviceCoreDescriptor.getDeviceId();
                this.btnEnableSecureDebugging.setEnabled(initialSelected && DebuggerDescriptors.getDeviceDebuggerSecureDebuggingAvailable((String)this.getDebuggerID(), (String)deviceId));
            }
        } else {
            this.btnEnableSecureDebugging.setEnabled(false);
        }
        if (!this.btnEnableSecureDebugging.isEnabled()) {
            this.btnEnableSecureDebugging.setSelection(false);
        }
        this.cmbSecureType.setEnabled(this.btnEnableSecureDebugging.getSelection());
    }

    private void setBtnTestConnection(boolean isUsbUsed) {
        boolean isLocalhostIp = true;
        if (this.commandConnectionServerIp != null) {
            isLocalhostIp = this.commandConnectionServerIp.getText().equals("127.0.0.1");
        }
        if (isUsbUsed) {
            this.btnTestConnection.setEnabled(isLocalhostIp && this.deviceUSB.getSelectionIndex() != -1);
        } else {
            this.btnTestConnection.setEnabled(isLocalhostIp && DebuggerUtils.validateIpOrHost((String)this.hostNameOrIp.getText().trim()));
        }
    }
}

