/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.ui;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.MultipleElf;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DebuggerCMainTabMessages;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.launch.ui.CMainTab2;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class S32DebuggerCMainTab
extends CMainTab2 {
    private Composite composite;
    private MultipleElf multipleElf;
    private Group group;
    private static final String DEFAULT_CORE = "Cortex";

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.composite = (Composite)this.getControl();
        this.group = new Group(this.composite, 0);
        this.group.setLayout((Layout)new GridLayout());
        this.group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.group.setText(S32DebuggerCMainTabMessages.S32DebuggerCMainTab_Additional_object_files_group_text);
        this.multipleElf = new MultipleElf((Composite)this.group, (ScrolledComposite)parent, new Runnable(){

            @Override
            public void run() {
                S32DebuggerCMainTab.this.scheduleUpdateJob();
            }
        });
    }

    public void performApply(ILaunchConfigurationWorkingCopy lc) {
        super.performApply(lc);
        lc.setAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.multiple.elf", this.multipleElf.getValueForAttribute());
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.group.setVisible(false);
        S32DebuggerParams debuggerParams = S32DebuggerParams.getParams((ILaunchConfiguration)config);
        String deviceCoreId = debuggerParams.getDeviceCoreId();
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        if (!deviceCoreId.isEmpty() && deviceCoreDescriptor != null) {
            String coreId = deviceCoreDescriptor.getCoreId();
            this.group.setVisible(coreId.contains(DEFAULT_CORE));
        }
        this.multipleElf.initializeFrom(config);
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean isValid = super.isValid(config);
        if (!isValid) {
            return isValid;
        }
        List<MultipleElf.MultipleElfElement> elements = MultipleElf.getElements(config);
        for (MultipleElf.MultipleElfElement element : elements) {
            IStatus status = element.getStatus();
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            if (Collections.frequency(elements, element) <= 1) continue;
            this.setErrorMessage(String.format(S32DebuggerCMainTabMessages.S32DebuggerCMainTab_The_object_with_path_has_already_been_added, element.getPath()));
            return false;
        }
        return true;
    }
}

