/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.entities.toolchains;

import com.nxp.s32ds.cle.cdt.internal.migration.CdtMigrationActivator;
import com.nxp.s32ds.cle.cdt.migration.entities.toolchains.ToolMigrationCompaibilities;
import com.nxp.s32ds.cle.runtime.migration.entity.MigrationEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractToolchainConfigurationMigrationEntity
implements MigrationEntity {
    private static final String BUNDLE_ID = "com.nxp.s32ds.cle.cdt.migration";
    private static final String DEFAULT_SYSROOT_OPTION = "--sysroot=\"${S32DS_ARM32_NEWLIB_DIR}\"";
    private Map<String, List<IOption>> expToolsOptions = new HashMap<String, List<IOption>>();
    private Map<String, Object> expToolChainOptions = new HashMap<String, Object>();
    Function<ITool, List<IOption>> function = new Function<ITool, List<IOption>>(){

        @Override
        public List<IOption> apply(ITool t) {
            return Arrays.asList(t.getOptions());
        }
    };

    public IStatus migrate(String sourceId, String targetId, Map<String, Object> attributes, IProgressMonitor monitor) {
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        if (project == null || !project.exists()) {
            return Status.CANCEL_STATUS;
        }
        Optional<IToolChain> optTargetToolchain = Stream.of(ManagedBuildManager.getRealToolChains()).filter(p -> p.getId().equals(this.getToolchainId())).findAny();
        if (!optTargetToolchain.isPresent()) {
            return Status.CANCEL_STATUS;
        }
        Optional<IToolChain> extTargetToolchain = Stream.of(ManagedBuildManager.getExtensionToolChains()).filter(p -> p.getId().equals(targetId)).findAny();
        if (!extTargetToolchain.isPresent()) {
            return Status.CANCEL_STATUS;
        }
        IToolChain targetToolchain = null;
        Optional<ToolChain> optChildTargetToolchain = ((ToolChain)optTargetToolchain.get()).getIdenticalList().stream().filter(p -> p.getId().equals(targetId)).findFirst();
        if (!optChildTargetToolchain.isPresent()) {
            return Status.CANCEL_STATUS;
        }
        targetToolchain = (IToolChain)optChildTargetToolchain.get();
        IToolChain targetChildToolchain = extTargetToolchain.get();
        this.exportOptionsValues(project, sourceId);
        IStatus status = AbstractToolchainConfigurationMigrationEntity.convertToolChain(project, sourceId, targetId, targetToolchain, targetChildToolchain);
        if (!status.isOK()) {
            return status;
        }
        this.setToolOptionValues(project, sourceId);
        try {
            this.setToolChainOptionValues(project, sourceId);
        }
        catch (BuildException e) {
            return new Status(4, BUNDLE_ID, e.getMessage());
        }
        this.setLibraryOption(project, sourceId);
        this.setSysrootOption(project, sourceId);
        this.notifyOptionHandler(project, sourceId);
        AbstractToolchainConfigurationMigrationEntity.updateConfigurationId(project, sourceId);
        return Status.OK_STATUS;
    }

    public IStatus applicable(String sourceId, String targetId, Map<String, Object> attributes) {
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        if (project == null || !project.exists()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void exportOptionsValues(IProject project, String sourceId) {
        IConfiguration[] configurations;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configurations = buildInfo.getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            if (configuration.getBaseId().equals(sourceId)) {
                IOption[] iOptionArray = configuration.getToolChain().getOptions();
                int n3 = iOptionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IOption option = iOptionArray[n4];
                    String key = option.getId();
                    if (option.getBaseId() != null) {
                        key = option.getBaseId();
                    }
                    this.expToolChainOptions.put(key, option.getValue());
                    ++n4;
                }
                this.expToolsOptions = Stream.of(configuration.getTools()).collect(Collectors.toMap(IBuildObject::getBaseId, this.function));
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    private void setToolOptionValues(IProject project, String sourceId) {
        IConfiguration[] configurations;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configurations = buildInfo.getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                IConfiguration configuration = iConfigurationArray[n2];
                if (!configuration.getBaseId().equals(sourceId)) break block8;
                ITool[] iToolArray = configuration.getTools();
                int n3 = iToolArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    block10: {
                        List<IOption> list;
                        ITool tool;
                        block9: {
                            tool = iToolArray[n4];
                            list = this.expToolsOptions.get(tool.getBaseId());
                            if (list != null) break block9;
                            String migrationCompatibilityToolId = ToolMigrationCompaibilities.getCompatibilityToolId(tool.getBaseId());
                            if (migrationCompatibilityToolId != null) {
                                list = this.expToolsOptions.get(migrationCompatibilityToolId);
                            }
                            if (list == null) break block10;
                        }
                        for (IOption option : list) {
                            IOption optionById = tool.getOptionById(option.getId());
                            if (optionById != null && option.getValue() != null) {
                                optionById.setValue(option.getValue());
                                continue;
                            }
                            IOption newOption = tool.createOption(option.getSuperClass(), option.getId(), option.getName(), option.isExtensionElement());
                            newOption.setValue(option.getValue());
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    private static IStatus convertToolChain(IProject project, String sourceId, String targetId, IToolChain targetToolchain, IToolChain targetChildToolchain) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject managedProject = buildInfo.getManagedProject();
        IConfiguration[] configurations = buildInfo.getManagedProject().getConfigurations();
        managedProject.getProjectType().setConvertToId(targetId);
        try {
            IConfiguration[] iConfigurationArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration configuration = iConfigurationArray[n2];
                if (configuration.getBaseId().equals(sourceId)) {
                    String targetChildToolchainId = ManagedBuildManager.calculateChildId((String)targetChildToolchain.getId(), null);
                    IFolderInfo rootFolderInfo = configuration.getRootFolderInfo();
                    rootFolderInfo.changeToolChain(targetToolchain, targetChildToolchainId, targetChildToolchain.getName());
                }
                ++n2;
            }
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
        catch (BuildException e) {
            return new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void setToolChainOptionValues(IProject project, String sourceId) throws BuildException {
        IConfiguration[] configurations;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configurations = buildInfo.getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            if (configuration.getBaseId().equals(sourceId)) {
                IOption[] iOptionArray = configuration.getToolChain().getOptions();
                int n3 = iOptionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IOption option = iOptionArray[n4];
                    for (Map.Entry<String, Object> targetOption : this.expToolChainOptions.entrySet()) {
                        if (!option.getId().equals(targetOption.getKey())) continue;
                        if (1 == option.getValueType() || 2 == option.getValueType()) {
                            ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)configuration.getToolChain(), (IOption)option, (String)String.valueOf(targetOption.getValue()));
                            continue;
                        }
                        if (option.getValueType() == 0) {
                            ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)configuration.getToolChain(), (IOption)option, (boolean)Boolean.parseBoolean(String.valueOf(targetOption.getValue())));
                            continue;
                        }
                        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)configuration.getToolChain(), (IOption)option, (String)String.valueOf(targetOption.getValue()));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    public IStatus setLibraryOption(IProject project, String sourceId) {
        IConfiguration[] configurations;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configurations = buildInfo.getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option;
            IConfiguration cfg = iConfigurationArray[n2];
            if (cfg.getBaseId().equals(sourceId) && (option = cfg.getToolChain().getOptionById(this.getOptionLibraryId())) != null) {
                Object oldLibValue = this.expToolChainOptions.get(this.getOptionLibrary63Id());
                if (oldLibValue instanceof String) {
                    String libraryValue = this.getOptionLibraryValue((String)oldLibValue);
                    ManagedBuildManager.setOption((IConfiguration)cfg, (IHoldsOptions)cfg.getToolChain(), (IOption)option, (String)libraryValue);
                } else {
                    ManagedBuildManager.setOption((IConfiguration)cfg, (IHoldsOptions)cfg.getToolChain(), (IOption)option, (String)this.getOptionLibraryValueDef());
                }
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        return Status.OK_STATUS;
    }

    private void setSysrootOption(IProject project, String sourceId) {
        IConfiguration[] configurations;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configurations = buildInfo.getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            if (cfg.getBaseId().equals(sourceId)) {
                String sysrootOptionId = this.getOptionSysrootId();
                Optional<IOption> sysrootOption = Arrays.stream(cfg.getToolChain().getOptions()).filter(opt -> sysrootOptionId.equals(opt.getBaseId())).findFirst();
                sysrootOption.ifPresent(option -> {
                    Object defaultValue = option.getDefaultValue();
                    if (defaultValue instanceof String) {
                        ManagedBuildManager.setOption((IConfiguration)cfg, (IHoldsOptions)cfg.getToolChain(), (IOption)option, (String)((String)defaultValue));
                    } else {
                        ManagedBuildManager.setOption((IConfiguration)cfg, (IHoldsOptions)cfg.getToolChain(), (IOption)option, (String)DEFAULT_SYSROOT_OPTION);
                    }
                });
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    public void notifyOptionHandler(IProject project, String sourceId) {
        IConfiguration[] configurations;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configurations = buildInfo.getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            if (cfg.getBaseId().equals(sourceId)) {
                ManagedBuildManager.performValueHandlerEvent((IConfiguration)cfg, (int)4);
            }
            ++n2;
        }
    }

    private static IStatus updateConfigurationId(IProject project, String sourceConfigId) {
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, true);
        if (description == null) {
            CdtMigrationActivator.getInstance().logWarning(NLS.bind((String)"Cannot find ICProjectDescription for project {0}", (Object)project.getName()));
            return Status.OK_STATUS;
        }
        ICConfigurationDescription[] configurations = description.getConfigurations();
        if (configurations.length == 0) {
            CdtMigrationActivator.getInstance().logWarning(NLS.bind((String)"Cannot find any ICConfigurationDescription for project {0}", (Object)project.getName()));
            return Status.OK_STATUS;
        }
        ICConfigurationDescription config = Arrays.stream(configurations).filter(c -> sourceConfigId.equals(c.getId().substring(0, c.getId().lastIndexOf(46)))).findFirst().orElse(null);
        if (config != null) {
            String newConfigId = config.getId().replaceAll(".bare", ".bare.gnu.9.2");
            try {
                description.createConfiguration(newConfigId, config.getName(), config);
                description.removeConfiguration(config);
                CoreModel.getDefault().setProjectDescription(project, description);
            }
            catch (WriteAccessException e) {
                return CdtMigrationActivator.getInstance().createError("Error during update configuration", e);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    public abstract String getOptionSysrootId();

    public abstract String getOptionLibraryId();

    public abstract String getOptionLibrary63Id();

    public abstract String getToolchainId();

    public abstract String getOptionLibraryValue(String var1);

    public abstract String getOptionLibraryValueDef();
}

