/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.entities.lc;

import com.nxp.s32ds.cle.cdt.migration.entities.lc.AbstractLaunchConfigurationMigrationEntity;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerLaunchConfigurationMigrationEntity
extends AbstractLaunchConfigurationMigrationEntity {
    private static final String COM_NXP_S32DS_DEBUG_IDE_S32DEBUGGER_CORE_CORE = "com.nxp.s32ds.debug.ide.s32debugger.core.core";
    private static final String COM_NXP_S32DS_DEBUG_IDE_S32DEBUGGER_CORE_DEVICE = "com.nxp.s32ds.debug.ide.s32debugger.core.device";
    private static final String COM_NXP_S32DS_DEBUG_IDE_S32DEBUGGER_CORE_DEVICE_CORE_ID = "com.nxp.s32ds.debug.ide.s32debugger.core.deviceCoreId";
    private static final String ATTR_S32_DEB = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String S32_DEBUGGER_CONFIG_TYPE = "com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType";
    private static final String S32_DEBUGGER = "s32debugger";

    @Override
    public String getConfigurationName() {
        return S32_DEBUGGER_CONFIG_TYPE;
    }

    @Override
    protected String getDebuggerId() {
        return S32_DEBUGGER;
    }

    @Override
    protected IStatus migrateWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, IProject project, String targetToolchain) throws CoreException {
        String deviceCoreId = workingCopy.getAttribute(COM_NXP_S32DS_DEBUG_IDE_S32DEBUGGER_CORE_DEVICE_CORE_ID, "");
        if (deviceCoreId.isEmpty() && (deviceCoreId = S32DebuggerLaunchConfigurationMigrationEntity.getbackwardCompatibilityDeviceCoreId(workingCopy)).isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        String gdbClientValue = LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)this.getDebuggerId(), (String)targetToolchain);
        workingCopy.setAttribute(ATTR_S32_DEB, gdbClientValue);
        return Status.OK_STATUS;
    }

    private static String getbackwardCompatibilityDeviceCoreId(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        String deviceId = workingCopy.getAttribute(COM_NXP_S32DS_DEBUG_IDE_S32DEBUGGER_CORE_DEVICE, "");
        String coreName = workingCopy.getAttribute(COM_NXP_S32DS_DEBUG_IDE_S32DEBUGGER_CORE_CORE, "");
        if (deviceId.isEmpty() || coreName.isEmpty()) {
            return "";
        }
        List deviceCoreDescriptorsByDeviceId = DeviceDescriptors.getDeviceRegistry().getDeviceCoreDescriptorsByDeviceId(deviceId);
        Optional<DeviceCoreDescriptor> findAny = deviceCoreDescriptorsByDeviceId.stream().filter(coreDiscriptor -> coreName.equals(coreDiscriptor.getName())).findAny();
        if (!findAny.isPresent()) {
            return "";
        }
        String deviceCoreId = findAny.get().getId();
        if (deviceCoreId.isEmpty()) {
            return "";
        }
        return deviceCoreId;
    }
}

