/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.refactoring;

import com.nxp.s32ds.ext.ide.core.internal.ExtIdeCoreActivator;
import com.nxp.s32ds.ext.ide.internal.validation.core.Messages;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RenameUtils {
    static final String PROJECT_NAME_REGEX = "( .*[ \\/.\"_\\\\])|(:.*[}\\/._\\\\])|(\\/.*[}\\/.\"_])|(>.*[<.\\/_\\\\])|(\".*[ \\/.\"_\\\\])|(\\\\.*[}\\/.\"_\\\\])";

    public static String renameProjectOccurencesInFileName(String name, String search, String replace) {
        int leftSearchBoundary = 0;
        StringBuilder newName = new StringBuilder();
        while (leftSearchBoundary < name.length()) {
            int index = name.indexOf(search, leftSearchBoundary);
            if (index == -1) {
                newName.append(name.substring(leftSearchBoundary));
                break;
            }
            if (RenameUtils.isProjectName(name, search, index)) {
                newName.append(name.substring(leftSearchBoundary, index)).append(replace);
            } else {
                newName.append(name.substring(leftSearchBoundary, index + search.length()));
            }
            leftSearchBoundary = index + search.length();
        }
        return newName.toString();
    }

    public static boolean isProjectName(String line, String oldName, int indexOfOldNameInLine) {
        String newLine = " " + line + " ";
        String oldNameWithNeighborSymbols = "";
        try {
            oldNameWithNeighborSymbols = newLine.substring(indexOfOldNameInLine, indexOfOldNameInLine + oldName.length() + 2);
        }
        catch (IndexOutOfBoundsException ex) {
            ExtIdeCoreActivator.getInstance().logWarning(Messages.RenameUtils_cannot_determine_is_project_name, ex);
            return false;
        }
        Pattern pattern = Pattern.compile(PROJECT_NAME_REGEX);
        Matcher matcher = pattern.matcher(oldNameWithNeighborSymbols);
        return matcher.find();
    }

    public static IStatus renameFile(IFile file, String search, String replace, IProgressMonitor monitor) {
        String oldName;
        String newName;
        if (file == null || search == null || replace == null) {
            return Status.CANCEL_STATUS;
        }
        if (search.equals(replace)) {
            return Status.OK_STATUS;
        }
        if (file.exists() && !(newName = RenameUtils.renameProjectOccurencesInFileName(oldName = file.getName(), search, replace)).equals(oldName)) {
            IPath path = file.getFullPath().removeLastSegments(1).append(newName);
            try {
                file.move(path, false, monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }
}

