/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.checker;

import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class CheckerService
implements IResourceChangeListener,
ICProjectDescriptionListener {
    private Map<String, IResourceChecker> checkers;
    private Map<String, URI> projectLocationMap = new HashMap<String, URI>();
    private Map<String, List<IWorkingSet>> projectWorkingSetsMap = new HashMap<String, List<IWorkingSet>>();
    private static CheckerService instance;
    private static final String BUNDLE_ID = "com.nxp.s32ds.ext.cdt.core";
    private static final String CHECKER_EXTENSION_POINT_NAME = "com.nxp.s32ds.ext.cdt.core.s32dsCheckers";
    private static final String OTHER_PROJECTS_WORKING_SET_NAME = "Other Projects";

    private CheckerService() {
    }

    public static synchronized CheckerService getInstance() {
        if (instance == null) {
            instance = new CheckerService();
        }
        return instance;
    }

    public void init() {
        WorkspaceJob chekerInitJob = new WorkspaceJob("Initialize Resources Checkers"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                return CheckerService.this.loadCheckerExtensions();
            }
        };
        chekerInitJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                CheckerService.this.addResourceChangeListener();
                CheckerService.this.addCProjectDescriptionListener();
            }
        });
        chekerInitJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        chekerInitJob.schedule();
    }

    private void check(final IProject project) {
        String subTaskName = NLS.bind((String)"Checking {0} ", (Object)project.getName());
        WorkspaceJob chekerJob = new WorkspaceJob(subTaskName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                MultiStatus ms = new MultiStatus(CheckerService.BUNDLE_ID, 0, "", null);
                if (project.isOpen()) {
                    for (Map.Entry<String, IResourceChecker> checkerEntries : CheckerService.this.checkers.entrySet()) {
                        try {
                            IStatus checkStatus = checkerEntries.getValue().check((IResource)project, monitor);
                            if (checkStatus == null) continue;
                            ms.add(checkStatus);
                        }
                        catch (Exception e) {
                            Status status = new Status(4, CheckerService.BUNDLE_ID, e.getMessage(), (Throwable)e);
                            ms.add((IStatus)status);
                        }
                    }
                }
                return ms;
            }
        };
        chekerJob.setRule((ISchedulingRule)project);
        chekerJob.schedule();
    }

    private IStatus loadCheckerExtensions() {
        MultiStatus mt = new MultiStatus(BUNDLE_ID, 0, "", null);
        this.checkers = new HashMap<String, IResourceChecker>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(CHECKER_EXTENSION_POINT_NAME);
        if (point == null) {
            String msg = NLS.bind((String)"Could not find extension point id: {0}", (Object)CHECKER_EXTENSION_POINT_NAME);
            mt.add((IStatus)new Status(4, BUNDLE_ID, msg));
            return mt;
        }
        IExtension[] extensions = point.getExtensions();
        if (extensions == null || extensions.length == 0) {
            return Status.OK_STATUS;
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("checker")) {
                    try {
                        String id = el.getAttribute("id");
                        IResourceChecker checker = (IResourceChecker)el.createExecutableExtension("class");
                        this.checkers.put(id, checker);
                    }
                    catch (CoreException coreException) {
                        String msg = NLS.bind((String)"Could not create executable extension id: {0}", (Object)el.getAttribute("id"));
                        mt.add((IStatus)new Status(4, BUNDLE_ID, msg));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return mt;
    }

    private void addResourceChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void addCProjectDescriptionListener() {
        CoreModel.getDefault().addCProjectDescriptionListener((ICProjectDescriptionListener)this, 1);
    }

    public Map<String, IResourceChecker> getCheckers() {
        return this.checkers;
    }

    public void clearRunner() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        CoreModel.getDefault().removeCProjectDescriptionListener((ICProjectDescriptionListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 8: {
                this.handlePreBuildEvent(event);
                break;
            }
            case 4: {
                this.handlePreDeleteEvent(event);
                break;
            }
            case 1: {
                this.handlePostChangeEvent(event);
                break;
            }
        }
    }

    private void handlePreBuildEvent(IResourceChangeEvent event) {
        if (event.getDelta() == null) {
            return;
        }
        try {
            event.getDelta().accept(delta -> {
                if (delta.getResource() instanceof IProject && this.hasChangesToCheck(delta)) {
                    IProject project = (IProject)delta.getResource();
                    if (project.isOpen()) {
                        this.check(project);
                    }
                    return false;
                }
                return true;
            });
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }

    private boolean hasChangesToCheck(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childrenDelta = iResourceDeltaArray[n2];
            if (this.hasChangesToCheck(childrenDelta)) {
                return true;
            }
            ++n2;
        }
        if (delta.getFlags() == 131072) {
            return false;
        }
        return delta.getFlags() != 0;
    }

    private void handlePreDeleteEvent(IResourceChangeEvent event) {
        IResource resource = event.getResource();
        if (resource != null && resource.getType() == 4) {
            this.registerProjectLocation(resource);
            this.registerProjectWorkingSets(resource);
        }
    }

    private void registerProjectLocation(IResource resource) {
        if (resource.getLocationURI() != null) {
            this.projectLocationMap.put(resource.getName(), resource.getLocationURI());
        }
    }

    private void registerProjectWorkingSets(IResource resource) {
        IWorkingSet[] workingSets;
        IWorkingSet[] iWorkingSetArray = workingSets = CheckerService.getWorkingSetManager().getWorkingSets();
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (!OTHER_PROJECTS_WORKING_SET_NAME.equals(workingSet.getName()) && Arrays.asList(workingSet.getElements()).contains(resource)) {
                if (!this.projectWorkingSetsMap.containsKey(resource.getName())) {
                    this.projectWorkingSetsMap.put(resource.getName(), new ArrayList());
                }
                this.projectWorkingSetsMap.get(resource.getName()).add(workingSet);
            }
            ++n2;
        }
    }

    private static IWorkingSetManager getWorkingSetManager() {
        return PlatformUI.getWorkbench().getWorkingSetManager();
    }

    private void handlePostChangeEvent(IResourceChangeEvent event) {
        if (event.getDelta() == null) {
            return;
        }
        try {
            event.getDelta().accept(delta -> {
                IResourceDelta[] childDeltas;
                if (1 == delta.getKind() && delta.getResource() instanceof IProject) {
                    IProject project = (IProject)delta.getResource();
                    this.check(project);
                }
                IResourceDelta[] iResourceDeltaArray = childDeltas = delta.getAffectedChildren();
                int n = childDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta childDelta = iResourceDeltaArray[n2];
                    int flags = childDelta.getFlags();
                    switch (flags) {
                        case 0: {
                            this.handleDeletedProject(childDelta);
                            break;
                        }
                        case 131072: {
                            this.handleDeletedProject(childDelta);
                            break;
                        }
                        case 16384: {
                            IProject project;
                            if (!(delta.getResource() instanceof IProject) || !(project = (IProject)delta.getResource()).isOpen()) break;
                            this.check(project);
                            break;
                        }
                    }
                    ++n2;
                }
                return true;
            });
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }

    private void handleDeletedProject(IResourceDelta resourceDelta) {
        List<IWorkingSet> workingSets;
        IResource resource = resourceDelta.getResource();
        if (!(resource instanceof IProject)) {
            return;
        }
        URI locationURI = this.unregisterProjectLocation(resource);
        if (locationURI != null) {
            URI workspaceLocationURI = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
            File workspaceFolder = new File(workspaceLocationURI.getPath());
            File file = new File(locationURI.getPath());
            File projectParentFolder = file.getParentFile();
            String[] childfiles = projectParentFolder.list();
            if (workspaceFolder.compareTo(projectParentFolder) != 0 && childfiles != null && childfiles.length == 0) {
                try {
                    Files.delete(projectParentFolder.toPath());
                }
                catch (IOException e) {
                    Status status = new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                }
            }
        }
        if ((workingSets = this.unregisterProjectWorkingSets(resource)) != null) {
            for (IWorkingSet workingSet : workingSets) {
                CheckerService.removeProjectFromWorkingSet(resource, workingSet);
                if (!CheckerService.isEmpty(workingSet)) continue;
                CheckerService.getWorkingSetManager().removeWorkingSet(workingSet);
            }
        }
    }

    private URI unregisterProjectLocation(IResource resource) {
        return this.projectLocationMap.remove(resource.getName());
    }

    private List<IWorkingSet> unregisterProjectWorkingSets(IResource resource) {
        return this.projectWorkingSetsMap.remove(resource.getName());
    }

    private static void removeProjectFromWorkingSet(IResource resource, IWorkingSet workingSet) {
        ArrayList<IAdaptable> projects = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        projects.remove(resource);
        workingSet.setElements(projects.toArray(new IAdaptable[0]));
    }

    private static boolean isEmpty(IWorkingSet workingSet) {
        if (OTHER_PROJECTS_WORKING_SET_NAME.equals(workingSet.getName())) {
            return false;
        }
        IAdaptable[] elements = workingSet.getElements();
        if (elements.length == 0) {
            return true;
        }
        int deletedCount = 0;
        IAdaptable[] iAdaptableArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable element = iAdaptableArray[n2];
            if (element instanceof IProject && !((IProject)element).exists()) {
                ++deletedCount;
            }
            ++n2;
        }
        return deletedCount >= elements.length && CheckerService.getWorkingSetManager().getWorkingSet(workingSet.getName()) != null;
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        if (event.getProject().isOpen()) {
            this.check(event.getProject());
        }
    }
}

