/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.controller.AController;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.periphs.controller.UiValueIdHolder;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.mcu.EmptyMcu;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.mcu.McuFactory;
import com.nxp.swtools.periphs.model.resources.AProcessorFilterForPeripherals;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.DependencyResponseConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.IStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.QuickSelectionHelper;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.config.SettingConfigCopyWrapper;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.ComponentOperationTypeEnum;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.Mode;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.resourcetables.properties.Properties;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.profiler.Profiler;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public abstract class APeriphController
extends AController {
    protected static final Logger LOGGER = LogManager.getLogger(APeriphController.class);
    protected IFunctionalGroup functionalGroup;
    protected IMcu mcu;
    protected PeriphsProfile profile;
    @Nullable
    protected ISettingConfig clipboard = null;
    protected AProcessorFilterForPeripherals toolFilter;

    protected IMcu getMcuFromSharedConfig(ISharedConfiguration sharedConfig) {
        ICommonConfig commonConfig = sharedConfig.getCommonConfig();
        EmptyMcu mcuLoc = null;
        if (!commonConfig.getMcu().isEmpty()) {
            IMcu currentMcu = this.getMcu();
            if (Objects.nonNull(currentMcu) && commonConfig.getMcuIdentification().equals(currentMcu.getMcuIdentification()) && !SWToolsProperties.isVerificationOn() && !(currentMcu instanceof EmptyMcu)) {
                mcuLoc = currentMcu;
            } else if (this.isMcuSupported(commonConfig)) {
                ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                BigInteger index = Profiler.getInstance((Object)"Peripherals").start(APeriphController.class, (Object)MessageFormat.format("MCU creation of \"{0}\"", commonConfig.getMcu()));
                mcuLoc = McuFactory.create((ISupportedDerivativesForSwTools)derivatives, (ICommonConfig)commonConfig, (AProcessorFilterForPeripherals)this.toolFilter);
                Profiler.getInstance((Object)"Peripherals").stop(index, APeriphController.class, null);
            }
        } else {
            mcuLoc = new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_McuNotSelectedMessage));
        }
        if (mcuLoc == null) {
            StoragePeriphsTool peripherals = sharedConfig.getTools().getPeripherals();
            mcuLoc = peripherals != null && peripherals.isEnabled() ? new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_McuNotSupportedAndToolEnabled)) : (SWToolsProperties.isVerificationOn() ? new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_CorruptedMcuData)) : new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_McuNotSupported)));
        }
        return mcuLoc;
    }

    protected List<String> getAvailablePeripherals(IFunctionalGroup funcGroup, Mode mode) {
        return new ArrayList<String>();
    }

    protected abstract void resolveAssigns(IChild var1);

    public Collection<String> getAvailablePeripherals(IFunctionalGroup funcGroup, IConfigurationComponent configComp) {
        return new ArrayList<String>();
    }

    public boolean hasModeWithMasterPeripheralNotDefined(IConfigurationComponent configurationComponent, String funcGroupName) {
        return false;
    }

    public boolean isAnyPeripheralAvailable(String funcGroupName, IConfigurationComponent configComp) {
        return false;
    }

    public Collection<String> getUsablePeripherals(IFunctionalGroup funcGroup, IConfigurationComponent configurationComponent) {
        return new ArrayList<String>();
    }

    public List<String> filterPeripheralsForCore(String core, Collection<String> peripherals) {
        return new ArrayList<String>();
    }

    public List<ConfigurationComponentTypeId> getComponents() {
        return new ArrayList<ConfigurationComponentTypeId>(this.mcu.getAvailableComponents().getConfigCompTypeIds());
    }

    public @Nullable IComponentConfig getConfiguredComponent(String type) {
        return (IComponentConfig)this.profile.getConfiguredComponents().get(type);
    }

    public abstract boolean isMcuSupported(ICommonConfig var1);

    protected APeriphController(AProcessorFilterForPeripherals toolFilter) {
        this.toolFilter = toolFilter;
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.mcu = this.getMcuFromSharedConfig(sharedConfig);
        this.profile = new PeriphsProfile(this.mcu, sharedConfig);
        this.functionalGroup = APeriphController.createFunctionalGroup(this.profile.getChildContext(), this.mcu);
        this.addAutoAddingInstances(this.functionalGroup);
    }

    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel) {
        this.handleSettingChange(eventType, eventOriginator, actionLabel, true, true);
    }

    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel, IChild updatedChild, boolean clearCache) {
        this.handleSettingChange(eventType, eventOriginator, actionLabel, true, updatedChild, clearCache);
    }

    @Deprecated
    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel, boolean setDirty, IChild updatedChild) {
        this.handleArrays(updatedChild);
        this.handleSettingChange(eventType, eventOriginator, actionLabel, setDirty, true);
    }

    @Deprecated
    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel, IChild updatedChild) {
        this.handleSettingChange(eventType, eventOriginator, actionLabel, true, updatedChild);
    }

    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel, boolean setDirty, @Nullable IChild updatedChild, boolean clearCache) {
        if (updatedChild != null) {
            this.handleArrays(updatedChild);
        }
        this.handleSettingChange(eventType, eventOriginator, actionLabel, setDirty, clearCache);
    }

    protected void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel, boolean setDirty, boolean clearCache) {
        boolean inInitialisation = false;
        if (eventType == 4) {
            Properties.disableVerification();
            inInitialisation = true;
        }
        this.handleSettingChangeSpecificImplementation(eventType, eventOriginator, actionLabel, setDirty, clearCache);
        if (inInitialisation) {
            Properties.enableVerification();
        }
    }

    protected abstract void handleSettingChangeSpecificImplementation(int var1, @Nullable Object var2, @Nullable String var3, boolean var4, boolean var5);

    public IFunctionalGroup getFunctionalGroup() {
        return this.functionalGroup;
    }

    public abstract void reloadFromSharedConfig();

    public Collection<String> getUsedNamesInGroupsWithSamePrefix(String prefix) {
        return new ArrayList<String>();
    }

    public @Nullable Categories getCategories() {
        return this.getMcu().getCategories();
    }

    public IMcu getMcu() {
        return this.mcu;
    }

    public PeriphsProfile getProfile() {
        return this.profile;
    }

    public void setComponentInstancesEnabled(Collection<IComponentInstanceConfig> configs, boolean enabled, Object caller) {
        this.setComponentInstancesEnabledSpecificImplementation(configs, enabled);
        String actionLabel = enabled ? Messages.get().Controller_Action_EnableComponentInstance : Messages.get().Controller_Action_DisableComponentInstance;
        this.handleSettingChange(1, caller, actionLabel);
    }

    public void setComponentInstancesEnabledSpecificImplementation(Collection<IComponentInstanceConfig> configs, boolean enabled) {
        configs.forEach(cic -> {
            cic.setEnabled(enabled);
            this.profile.synchronizeFunctionalGroups(this.getFunctionalGroup(), null, null, ComponentOperationTypeEnum.ENABLE_DISABLE);
        });
    }

    public abstract List<ConfigurationComponentTypeId> getComponentsOfPeripheral(String var1);

    public List<String> getActiveCorePeripherals() {
        return new ArrayList<String>();
    }

    public List<IComponentInstanceConfig> getComponentInstanceConfigs(String peripheralInstanceName) {
        return (List)this.getFunctionalGroup().getInstances().values().stream().filter(c -> Objects.nonNull(c) && c.isPeripheralUsed(peripheralInstanceName)).collect(CollectorsUtils.toList());
    }

    public @Nullable ConfigurationComponentTypeId getConfigurationComponentTypeId(String id) {
        return (ConfigurationComponentTypeId)CollectionsUtils.findAny((Collection)this.mcu.getAvailableComponents().getConfigCompTypeIds(), x -> id.equals(x.getConfigurationComponent().getId()));
    }

    public boolean setValue(ScalarConfig child, String newVal, Object caller) {
        return this.setValue(child, newVal, true, caller);
    }

    public boolean setValue(ScalarConfig child, String newVal, boolean handleChanges, Object caller) {
        boolean result = child.setValue(newVal);
        if (result) {
            APeriphController.unsetParentQuickSelections((IChild)child);
            if (child.isSynchronizationEnabled()) {
                this.profile.getSettingsToSyncByChild((IChild)child).forEach(x -> x.synchronizeValue((IChild)child));
            } else {
                child.synchronizeValue(null);
            }
            this.resolveAssigns((IChild)child);
            if (handleChanges) {
                this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)child), caller, UtilsText.safeString((String)Messages.get().Controller_Action_SetValueOfSetting), (IChild)child, false);
            }
        }
        return result;
    }

    public @Nullable ConfigurationComponent getConfigurationComponent(String id) {
        return (ConfigurationComponent)CollectionsUtils.findAny((Collection)this.profile.getActiveComponents().getConfigComps(), x -> id.equals(x.getId()));
    }

    public List<UiValueIdHolder> getEnumItems(ISettingConfig settingConfig) {
        ArrayList items = null;
        if (settingConfig instanceof ScalarConfig) {
            items = ((ScalarConfig)settingConfig).getEnumItems();
        } else {
            LOGGER.severe("[DATA] Setting is not instance of an enumsetting: " + settingConfig.getModelData().getId());
            items = new ArrayList();
        }
        return (List)items.stream().filter(x -> x.isAvailable(settingConfig.getExpressionContext()) && x.isEnabled(settingConfig.getExpressionContext())).map(x -> new UiValueIdHolder(x.getUIName(settingConfig.getExpressionContext()), x.getId(), x.getResolvedDescription(settingConfig.getExpressionContext()))).collect(CollectorsUtils.toList());
    }

    public UiValueIdHolder getEnumItemById(ISettingConfig settingConfig, String itemId) {
        SetSetting.Item item = null;
        if (settingConfig instanceof ScalarConfig) {
            List items = ((ScalarConfig)settingConfig).getEnumItems();
            item = (SetSetting.Item)CollectionsUtils.nullableOptionalGet(items.stream().filter(x -> x.getId().equals(itemId)).findFirst());
        } else {
            LOGGER.severe("[TOOL] Setting is not an enum: " + settingConfig.getModelData().getId());
        }
        if (item == null) {
            return new UiValueIdHolder("", itemId, "");
        }
        return new UiValueIdHolder(item.getUIName(settingConfig.getExpressionContext()), item.getId(), item.getResolvedDescription(settingConfig.getExpressionContext()));
    }

    public void setSetPresence(SetConfig.SetPresence setPresence, boolean newVal, Object caller) {
        this.setSetPresence(setPresence, newVal, true, caller);
    }

    public void setSetPresence(SetConfig.SetPresence setPresence, boolean newVal, boolean handleChanges, Object caller) {
        setPresence.setValue(newVal);
        this.resolveAssigns((IChild)setPresence);
        APeriphController.unsetParentQuickSelections((IChild)setPresence);
        if (handleChanges) {
            this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)setPresence), caller, UtilsText.safeString((String)Messages.get().Controller_Action_SetValueOfSet), (IChild)setPresence, false);
        }
    }

    protected static void unsetParentQuickSelections(IChild child) {
        ChildProviderHelper.unsetParentQuickSelections((IChild)child);
    }

    public boolean canCopy(ISettingConfig setting) {
        return false;
    }

    public void paste(ISettingConfig setting, String clipboardString) {
        if (!this.canPaste(setting, clipboardString)) {
            return;
        }
        if (!SettingConfigCopyWrapper.containsCopyWrapper((String)clipboardString)) {
            LOGGER.log(Level.WARNING, "Clipboard does not contain copy wrapper");
            return;
        }
        SettingConfigCopyWrapper copyWrapper = SettingConfigCopyWrapper.deserialize((Reader)new StringReader(clipboardString));
        if (copyWrapper == null) {
            return;
        }
        AStoragePeriphsSetting settingStorage = copyWrapper.getSettingStorage();
        IChildProvidable parent = setting.getChildContext().getParent();
        if (parent != null && settingStorage != null) {
            ISettingConfig otherSettingConfig = this.profile.getConfigFactory().createSettingConfig(settingStorage.getName(), setting.getModelData(), parent.getChildContext(), settingStorage, (ICommonMcu)this.getMcu());
            setting.applyOther(otherSettingConfig);
            if (setting instanceof IChildProvidable) {
                ((IChildProvidable)setting).handleUniqueIntegers();
            }
            if (setting.isSynchronizationEnabled()) {
                this.profile.getSettingsToSyncByChild((IChild)setting).forEach(x -> x.synchronizeValue((IChild)setting));
            } else {
                setting.synchronizeValue(null);
            }
            this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)setting), (Object)this, "Paste of stored setting into another setting", true, true);
        }
    }

    public boolean canPaste(ISettingConfig setting, String clipboardString) {
        StructConfig pastedStruct;
        StructConfig clipboardStruct;
        if (!SettingConfigCopyWrapper.containsCopyWrapper((String)clipboardString)) {
            return false;
        }
        SettingConfigCopyWrapper copyWrapper = SettingConfigCopyWrapper.deserialize((Reader)new StringReader(clipboardString));
        if (copyWrapper == null) {
            return false;
        }
        IChildProvidable parent = setting.getChildContext().getParent();
        if (parent == null) {
            return false;
        }
        AStoragePeriphsSetting settingStorage = copyWrapper.getSettingStorage();
        if (settingStorage == null) {
            return false;
        }
        if (!Objects.equals(setting.getStorageSetting().getClass(), settingStorage.getClass())) {
            return false;
        }
        if (!Objects.equals(setting.getTypeName(), copyWrapper.getSettingType())) {
            return false;
        }
        if (!Objects.equals(setting.getConfigurationComponentType(), copyWrapper.getComponentType())) {
            return false;
        }
        ISettingConfig otherSettingConfig = this.profile.getConfigFactory().createSettingConfig(settingStorage.getName(), setting.getModelData(), parent.getChildContext(), settingStorage, (ICommonMcu)this.getMcu());
        if (!Objects.equals(otherSettingConfig.getClass(), setting.getClass())) {
            return false;
        }
        if (setting instanceof StructConfig && !ChildProviderHelper.typesOfChildrenEquals((IStructuredSettingConfig)(clipboardStruct = (StructConfig)otherSettingConfig), (StructConfig)(pastedStruct = (StructConfig)setting))) {
            return false;
        }
        if (setting instanceof ArrayConfig) {
            pastedStruct = (ArrayConfig)setting;
            clipboardStruct = (ArrayConfig)otherSettingConfig;
            if (!pastedStruct.getName().equals(clipboardStruct.getName())) {
                return false;
            }
        }
        return true;
    }

    public @Nullable String copy(ISettingConfig setting) {
        SettingConfigCopyWrapper copyWrapper = new SettingConfigCopyWrapper(setting);
        return copyWrapper.serialize();
    }

    public void pasteAsNewItem(ArrayConfig array, String clipboardString) {
        if (!this.canPasteAsNewItem(array, clipboardString)) {
            return;
        }
        if (!SettingConfigCopyWrapper.containsCopyWrapper((String)clipboardString)) {
            LOGGER.log(Level.WARNING, "Clipboard does not contain copy wrapper");
            return;
        }
        SettingConfigCopyWrapper copyWrapper = SettingConfigCopyWrapper.deserialize((Reader)new StringReader(clipboardString));
        if (copyWrapper == null) {
            return;
        }
        AStoragePeriphsSetting settingStorage = copyWrapper.getSettingStorage();
        IChildProvidable parent = array.getChildContext().getParent();
        if (parent != null && settingStorage != null) {
            ISettingConfig addedItem = array.addNewItem();
            ISettingConfig otherSettingConfig = this.profile.getConfigFactory().createSettingConfig(settingStorage.getName(), array.getInstanceSetting(), parent.getChildContext(), settingStorage, (ICommonMcu)this.getMcu());
            addedItem.applyOther(otherSettingConfig);
            if (addedItem instanceof IChildProvidable) {
                ((IChildProvidable)addedItem).handleUniqueIntegers();
            }
            if (array.isSynchronizationEnabled()) {
                this.profile.getSettingsToSyncByChild((IChild)array).forEach(x -> x.synchronizeValue((IChild)array));
            } else {
                addedItem.synchronizeValue(null);
            }
            this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)array), (Object)this, "Paste of stored setting into another setting", true, true);
        }
    }

    public boolean canPasteAsNewItem(ArrayConfig array, String clipboardString) {
        if (!array.canAddItem()) {
            return false;
        }
        if (!SettingConfigCopyWrapper.containsCopyWrapper((String)clipboardString)) {
            return false;
        }
        SettingConfigCopyWrapper copyWrapper = SettingConfigCopyWrapper.deserialize((Reader)new StringReader(clipboardString));
        if (copyWrapper == null) {
            return false;
        }
        AStoragePeriphsSetting settingStorage = copyWrapper.getSettingStorage();
        IChildProvidable parent = array.getChildContext().getParent();
        if (parent == null) {
            return false;
        }
        if (settingStorage == null) {
            return false;
        }
        boolean idEquals = Objects.equals(copyWrapper.getSettingId(), array.getInstanceSetting().getId());
        boolean typeEquals = Objects.equals(copyWrapper.getSettingType(), array.getInstanceSetting().getTypeName());
        boolean componentEquals = Objects.equals(copyWrapper.getComponentType(), array.getConfigurationComponentType());
        return idEquals && typeEquals && componentEquals;
    }

    public void addItem(ArrayConfig arrayConfig, Object caller) {
        this.addItem(arrayConfig, true, caller);
    }

    public void addItem(ArrayConfig arrayConfig, boolean handleChanges, Object caller) {
        Profiler profiler;
        BigInteger index = profiler.start(Controller.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : MessageFormat.format("Adding item to the array \"{0}\"", arrayConfig)));
        this.addItemSpecificImplementation(arrayConfig);
        APeriphController.unsetParentQuickSelections((IChild)arrayConfig);
        profiler.stop(index, APeriphController.class, null);
        if (handleChanges) {
            this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)arrayConfig), caller, UtilsText.safeString((String)Messages.get().Controller_Action_AddItemToArray), (IChild)arrayConfig);
        }
    }

    protected @Nullable ISettingConfig addItemSpecificImplementation(ArrayConfig arrayConfig) {
        try {
            ISettingConfig itemAdded = arrayConfig.addNewItem();
            if (arrayConfig.isSynchronizationEnabled()) {
                this.profile.getSettingsToSyncByChild((IChild)arrayConfig).forEach(x -> x.synchronizeValue((IChild)arrayConfig));
            } else {
                itemAdded.synchronizeValue(null);
            }
            return itemAdded;
        }
        catch (ExpressionException ex) {
            ex.log();
            return null;
        }
    }

    public boolean moveItemFront(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        Profiler profiler;
        BigInteger index = profiler.start(APeriphController.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : MessageFormat.format("Move item \"{0}\" left in the array \"{1}\"", childConfig, arrayConfig)));
        try {
            if (arrayConfig.moveFront(childConfig)) {
                if (arrayConfig.isSynchronizationEnabled()) {
                    this.profile.getSettingsToSyncByChild((IChild)arrayConfig).forEach(x -> x.synchronizeValue((IChild)arrayConfig));
                } else {
                    arrayConfig.synchronizeValue(null);
                }
                this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)arrayConfig), caller, UtilsText.safeString((String)Messages.get().Controller_Action_MoveItem));
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        profiler.stop(index, APeriphController.class, null);
        return false;
    }

    public boolean moveItemBack(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        Profiler profiler;
        BigInteger index = profiler.start(APeriphController.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : MessageFormat.format("Move item \"{0}\" right in the array \"{1}\"", childConfig, arrayConfig)));
        try {
            if (arrayConfig.moveBack(childConfig)) {
                if (arrayConfig.isSynchronizationEnabled()) {
                    this.profile.getSettingsToSyncByChild((IChild)arrayConfig).forEach(x -> x.synchronizeValue((IChild)arrayConfig));
                }
                this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)arrayConfig), caller, UtilsText.safeString((String)Messages.get().Controller_Action_MoveItem));
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        profiler.stop(index, APeriphController.class, null);
        return false;
    }

    public boolean moveItemBeginning(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        Profiler profiler;
        BigInteger index = profiler.start(APeriphController.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : MessageFormat.format("Move item \"{0}\" to beginning of the array \"{1}\"", childConfig, arrayConfig)));
        try {
            if (arrayConfig.moveBeginning(childConfig)) {
                if (arrayConfig.isSynchronizationEnabled()) {
                    this.profile.getSettingsToSyncByChild((IChild)arrayConfig).forEach(x -> x.synchronizeValue((IChild)arrayConfig));
                }
                this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)arrayConfig), caller, UtilsText.safeString((String)Messages.get().Controller_Action_MoveItem));
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        profiler.stop(index, APeriphController.class, null);
        return false;
    }

    public boolean moveItemEnd(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        Profiler profiler;
        BigInteger index = profiler.start(APeriphController.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : MessageFormat.format("Move item \"{0}\" to end of the array \"{1}\"", childConfig, arrayConfig)));
        try {
            if (arrayConfig.moveEnd(childConfig)) {
                if (arrayConfig.isSynchronizationEnabled()) {
                    this.profile.getSettingsToSyncByChild((IChild)arrayConfig).forEach(x -> x.synchronizeValue((IChild)arrayConfig));
                }
                this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)arrayConfig), caller, UtilsText.safeString((String)Messages.get().Controller_Action_MoveItem));
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        profiler.stop(index, APeriphController.class, null);
        return false;
    }

    public boolean removeItem(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        return this.removeItem(arrayConfig, childConfig, true, caller);
    }

    public boolean removeItem(ArrayConfig arrayConfig, ISettingConfig childConfig, boolean handleChanges, Object caller) {
        Profiler profiler;
        BigInteger index = profiler.start(APeriphController.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : MessageFormat.format("Remove item '{0}' from array '{0}'", childConfig, arrayConfig)));
        try {
            boolean removedItem = this.removeItemSpecificImplementation(arrayConfig, childConfig);
            if (removedItem) {
                if (arrayConfig.isSynchronizationEnabled()) {
                    List childrenToSync = this.profile.getSettingsToSyncByChild((IChild)arrayConfig);
                    childrenToSync.remove(arrayConfig);
                    for (IChild child : childrenToSync) {
                        ArrayConfig array = (ArrayConfig)child;
                        IChild childToRemove = array.getChild(childConfig.getName());
                        if (childToRemove == null) continue;
                        array.remove((ISettingConfig)childToRemove);
                    }
                }
                APeriphController.unsetParentQuickSelections((IChild)arrayConfig);
                if (handleChanges) {
                    this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)arrayConfig), caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveItemFromArray), (IChild)arrayConfig);
                }
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        finally {
            profiler.stop(index, Controller.class, null);
        }
        return false;
    }

    protected boolean removeItemSpecificImplementation(ArrayConfig arrayConfig, ISettingConfig childConfig) {
        return arrayConfig.remove(childConfig);
    }

    public void setAllSettingsTo(String value, List<IChild> settings, ArrayConfig config, Object caller) {
        for (IChild setting : settings) {
            if (setting instanceof ScalarConfig) {
                ScalarConfig scalarConfig = (ScalarConfig)setting;
                if (scalarConfig.getType() == ScalarConfig.Type.INFO || scalarConfig.getType() == ScalarConfig.Type.VARIABLE) continue;
                scalarConfig.setValue(value);
                continue;
            }
            if (!(setting instanceof SetConfig.SetPresence)) continue;
            ((SetConfig.SetPresence)setting).setValue(Boolean.valueOf(value).booleanValue());
        }
        this.handleSettingChange(APeriphController.getEventTypeWhenSettingChangesValue((IChild)config), caller, Messages.get().Controller_Action_SettingAllItemsTo);
    }

    public void applyQuickSelection(String quickSelUiName, IPresettable presettable, Object caller) {
        IQuickSelection quickSelection = (IQuickSelection)CollectionsUtils.nullableOptionalGet(QuickSelectionHelper.getAvailableQuickSelections((IPresettable)presettable).stream().filter(x -> x.getUIName(presettable.getExpressionContext()).equals(quickSelUiName)).findFirst());
        if (quickSelection != null) {
            this.applyQuickSelectionSpecificImplementation(presettable, quickSelection);
            this.syncPresettedSettings(presettable);
            this.handleSettingChange(4, caller, UtilsText.safeString((String)Messages.get().Controller_Action_ApplyQuickSelection));
        }
    }

    protected void applyQuickSelectionSpecificImplementation(IPresettable presettable, IQuickSelection quickSelection) {
        this.getProfile().clearCache();
        presettable.setQuickSelection(quickSelection);
        presettable.applySelectedQuickSelection();
        this.getProfile().clearCache();
        if (presettable instanceof IChildProvidable) {
            ((IChildProvidable)presettable).handleUniqueIntegers();
        }
        APeriphController.unsetParentQuickSelections((IChild)presettable);
    }

    protected static FunctionalGroup createFunctionalGroup(ChildContext childContext, IMcu mcu) {
        if (APeriphController.isMcuSupported(mcu)) {
            return new FunctionalGroup(childContext, (ICommonMcu)mcu);
        }
        return new FunctionalGroup(childContext, (ICommonMcu)mcu){

            public @NonNull String getError() {
                return ((EmptyMcu)this.mcu).getReason();
            }

            public String getName() {
                return ((EmptyMcu)this.mcu).getReason();
            }
        };
    }

    public static boolean isMcuSupported(IMcu mcuToCheck) {
        return !(mcuToCheck instanceof EmptyMcu);
    }

    public boolean isMcuSupported() {
        return APeriphController.isMcuSupported(this.mcu);
    }

    public void performBulkChange(Map<String, String> changes, Object caller) {
        Runnable runnable = () -> {
            for (Map.Entry entry : changes.entrySet()) {
                String id = (String)entry.getKey();
                String value = (String)entry.getValue();
                IChild foundChild = ChildProviderHelper.getChild((ChildContext)this.profile.getChildContext(), (String)id);
                if (foundChild == null) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Node with id {0} does not exist!", id);
                }
                if (foundChild instanceof ScalarConfig) {
                    this.setValue((ScalarConfig)foundChild, value, false, caller);
                }
                if (foundChild instanceof SetConfig.SetPresence) {
                    this.setSetPresence((SetConfig.SetPresence)foundChild, Boolean.parseBoolean(value), false, caller);
                }
                if (foundChild instanceof ArrayConfig) {
                    ArrayConfig array = (ArrayConfig)foundChild;
                    ArrayList children = new ArrayList(array.getChildren());
                    int newSize = Integer.parseInt(value);
                    int diff = Math.abs(newSize - children.size());
                    int i = 0;
                    while (i < diff) {
                        if (newSize > children.size()) {
                            this.addItem(array, false, caller);
                        } else {
                            ISettingConfig lastChild = (ISettingConfig)children.get(children.size() - 1);
                            this.removeItem(array, lastChild, false, caller);
                        }
                        children = new ArrayList(array.getChildren());
                        ++i;
                    }
                }
                if (!(foundChild instanceof StructConfig)) continue;
                LOGGER.log(Level.WARNING, "[TOOL] Node with id {0} is not a settable!", id);
            }
            this.handleSettingChange(2, caller, "Bulk change", true, true);
        };
        this.runTransaction(runnable);
    }

    public void setFunctionalGroup(IFunctionalGroup functionalGroup, Object caller) {
        this.setFunctionalGroup(functionalGroup, true, caller);
    }

    public void setFunctionalGroup(IFunctionalGroup functionalGroup, boolean fireEvent, Object caller) {
        if (!this.profile.getFunctionalGroups().contains(functionalGroup)) {
            LOGGER.severe("[TOOL] Trying to set active configuration which is not in the active profile");
        } else {
            this.functionalGroup = functionalGroup;
            if (fireEvent) {
                this.fireListeners(new ToolEvent.Builder(1).setOriginator(caller).build());
            }
        }
    }

    public void changeMode(IComponentInstanceConfig componentInstanceConfig, String uiName, Object caller) {
        Runnable runnable = () -> {
            try {
                Mode mode = APeriphController.getMode(componentInstanceConfig, uiName);
                if (mode != null) {
                    componentInstanceConfig.changeMode(mode);
                    if (mode.getMasterPeripheral() == null) {
                        componentInstanceConfig.setPeripheral(null);
                    }
                    RegistersModelSingleton.getInstance().setRegenerationNeeded();
                    this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_ChangeMode));
                }
            }
            catch (ExpressionException ex) {
                ex.log();
            }
        };
        this.runTransaction(runnable);
    }

    public void changeMode(String componentType, String componentName, String uiName, Object caller) {
        IComponentInstanceConfig componentInstanceConfig = this.getComponentInstance(componentType, componentName);
        if (componentInstanceConfig != null) {
            this.changeMode(componentInstanceConfig, uiName, caller);
        }
    }

    public void changeMode(String uuid, String uiName, Object caller) {
        IComponentInstanceConfig componentInstanceConfig = this.getComponentInstance(uuid);
        if (componentInstanceConfig != null) {
            this.changeMode(componentInstanceConfig, uiName, caller);
        }
    }

    public boolean renameComponentInstance(IComponentInstanceConfig componentInstanceConfig, String newName, Object caller, boolean notifyChange) {
        if (componentInstanceConfig.getUiName().equals(newName)) {
            return false;
        }
        if (!componentInstanceConfig.getUiName().equalsIgnoreCase(newName) && !this.isNameUsable(newName)) {
            return false;
        }
        IFunctionalGroup functionalGroupLoc = componentInstanceConfig.getChildContext().getFunctionalGroup();
        if (functionalGroupLoc != null) {
            this.profile.synchronizeFunctionalGroups(functionalGroupLoc, componentInstanceConfig.getName(), newName, ComponentOperationTypeEnum.RENAME);
            functionalGroupLoc.renameInstance(componentInstanceConfig.getName(), newName);
        } else {
            LOGGER.log(Level.WARNING, "[TOOL] Instance with UUID {0} has no functional group assigneed when rename operation begin", componentInstanceConfig.getUUID());
        }
        if (notifyChange) {
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RenameComponent));
        }
        return true;
    }

    public boolean isNameUsable(String name) {
        return APeriphController.isNameValid(name) && this.isNameUnique(this.functionalGroup.createIdentifier(name));
    }

    public static boolean isNameValid(String name) {
        return UtilsText.isIdentifier((CharSequence)name);
    }

    private boolean isNameUnique(String name) {
        return this.getProfile().countSameIdentifierOccurences(this.functionalGroup.getIdPrefix(), name) == 0;
    }

    public void setPeripheral(String componentType, String componentName, String peripheral, Object caller) {
        IComponentInstanceConfig component = this.getComponentInstance(componentType, componentName);
        if (component != null) {
            this.setPeripheralSpecificImplementation(component, peripheral);
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_ChangePeripheral));
        }
    }

    public void setPeripheral(String uuid, String peripheral, Object caller) {
        IComponentInstanceConfig component = this.getComponentInstance(uuid);
        if (component != null) {
            this.setPeripheralSpecificImplementation(component, peripheral);
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_ChangePeripheral));
        }
    }

    protected void setPeripheralSpecificImplementation(IComponentInstanceConfig instance, String peripheral) {
        instance.setPeripheral(peripheral);
    }

    private static @Nullable Mode getMode(IComponentInstanceConfig componentInstanceConfig, String uiName) {
        for (Mode mode : componentInstanceConfig.getComponent().getScenarios()) {
            if (!uiName.equals(mode.getUIName(componentInstanceConfig.getExpressionContext())) || !mode.isAvailable(componentInstanceConfig.getExpressionContext())) continue;
            return mode;
        }
        return null;
    }

    public @Nullable IComponentInstanceConfig getComponentInstance(String type, String name) {
        return this.functionalGroup.getComponentInstance(type, name);
    }

    public @Nullable IComponentInstanceConfig getComponentInstance(String uuid) {
        return this.functionalGroup.getInstanceByUUID(uuid);
    }

    public List<IComponentInstanceConfig> getComponentInstancesByPeripheral(String peripheral) {
        return this.functionalGroup.getInstancesByPeripheral(peripheral);
    }

    public abstract @Nullable IComponentInstanceConfig createComponentInstance(String var1, @Nullable String var2, String var3, Object var4);

    public abstract @Nullable IComponentInstanceConfig createComponentInstanceFromTemplate(ComponentTemplate var1, @Nullable String var2, String var3, Object var4);

    public boolean canCreateInstances(IConfigurationComponent selectedConfigComp, String funcGroup) {
        int maxComponentInstances = selectedConfigComp.getComponentMaxInstancesNumber(this.getFunctionalGroup().getExpressionContext());
        int currentCompInstNumber = this.getComponentInstancesCountInFunctionalGroup(selectedConfigComp.getId(), funcGroup);
        return maxComponentInstances == -1 || currentCompInstNumber < maxComponentInstances;
    }

    private int getFunctionalGroupsLimit() {
        IComponentConfig systemComponentConfig = this.profile.getSystemComponentConfig();
        return systemComponentConfig != null ? systemComponentConfig.getComponent().getComponentMaxFunctionalGroupsNumber(systemComponentConfig.getExpressionContext()) : -1;
    }

    public int getMaximumNumberOfFunctionalGroups() {
        return this.getFunctionalGroupsLimit() != -1 ? this.getFunctionalGroupsLimit() : 20;
    }

    public int getComponentInstancesCountInFunctionalGroup(String componentId, String funcGroup) {
        IFunctionalGroup reqFcGroup = this.profile.getFunctionalGroup(funcGroup);
        if (reqFcGroup != null) {
            return (int)reqFcGroup.getInstances().values().stream().filter(x -> x.getComponent().getId().equals(componentId)).count();
        }
        return 0;
    }

    public void setComment(IComponentInstanceConfig instance, String comment, Object caller) {
        instance.setComment(comment);
        this.handleSettingChange(1, caller, Messages.get().Controller_Action_SetComment);
    }

    public void setInstanceToCustomNameMode(IComponentInstanceConfig instance, boolean isCustomName, Object caller) {
        instance.setIsCustomName(isCustomName);
        String message = isCustomName ? Messages.get().APeriphController_EnableCustomName : Messages.get().APeriphController_DisableCustomName;
        this.handleSettingChange(1, caller, message);
    }

    public static String getAutomaticName(IComponentInstanceConfig instance) {
        String peripheral = instance.getPeripheral();
        String name = instance.getComponent().getUIName(instance.getExpressionContext());
        if (peripheral == null) {
            return name;
        }
        if (KEPreferences.isGenerateFullInstanceIdentification()) {
            return name;
        }
        if (instance.getComponent().getId().equals("custom_init")) {
            return String.valueOf(peripheral) + "_" + "custom_init";
        }
        return peripheral;
    }

    public static String getAutomaticName(IComponentConfig component, @Nullable String peripheral) {
        String name = component.getUiName();
        if (peripheral == null) {
            return name.replace(" ", "_");
        }
        if (KEPreferences.isGenerateFullInstanceIdentification()) {
            return name;
        }
        if (component.getComponentId().equals("custom_init")) {
            return String.valueOf(peripheral) + "_" + "custom_init";
        }
        return peripheral;
    }

    protected void regenerateInstanceNames() {
        Runnable runnable = () -> {
            for (IFunctionalGroup group : this.profile.getFunctionalGroups()) {
                ArrayList instances = new ArrayList(group.getInstances().values());
                for (IComponentInstanceConfig instance : instances) {
                    if (instance.isCustomNameEnabled()) continue;
                    String automaticName = APeriphController.getAutomaticName(instance);
                    this.renameComponentInstance(instance, automaticName, Controller.class, false);
                }
            }
        };
        this.runTransaction(runnable);
    }

    public @Nullable ConfigurationComponentTypeId getSystemComponent() {
        return McuFactory.getSystemComponent((AvailableComponents)this.mcu.getAvailableComponents(), (IMcuIdentification)this.mcu.getMcuIdentification());
    }

    protected void handleArrays(IChild updatedSetting) {
        Object optionValue;
        if (updatedSetting.isOptionSet("APPLY_DEFAULTS") && (optionValue = updatedSetting.getOptionValue("APPLY_DEFAULTS")) != null && optionValue instanceof List) {
            this.profile.clearCache();
            List impactedSettings = (List)optionValue;
            for (Object impSetting : impactedSettings) {
                if (impSetting instanceof ArrayConfig) {
                    ((ArrayConfig)impSetting).applyDefaultsToItems();
                    continue;
                }
                if (impSetting instanceof String) {
                    IChild impactedChild = ChildProviderHelper.getChild((ChildContext)this.profile.getChildContext(), (String)impSetting.toString());
                    if (impactedChild == null || !(impactedChild instanceof ArrayConfig)) continue;
                    ((ArrayConfig)impactedChild).applyDefaultsToItems();
                    continue;
                }
                LOGGER.log(Level.SEVERE, String.format("[TOOL] The current type is not supported for APPLY_DEFAULTS option: %1s. Only the array setting instances and string ids are supported.", impSetting));
            }
        }
    }

    public static int getEventTypeWhenSettingChangesValue(IChild child) {
        int eventType = 2;
        if (child.isOptionSet("UI_REFRESH") && child.isOptionAvailable("UI_REFRESH")) {
            eventType = 1;
        }
        return eventType;
    }

    public abstract int getSettingsChangedEvent();

    public void addAutoAddingInstances(IFunctionalGroup group) {
        for (ConfigurationComponentTypeId componentTypeId : this.mcu.getAvailableComponents().getConfigCompTypeIds()) {
            long wantedNumberOfInstances;
            Expression expression = componentTypeId.getConfigurationComponent().getAutoAddInstancesExpression();
            if (expression == null) continue;
            try {
                wantedNumberOfInstances = expression.resolve(group.getExpressionContext()).getLong();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Expression that defines number of auto added instances contains error. See following exception: {0}", e));
                wantedNumberOfInstances = 0L;
            }
            long wantedNumberOfInstancesFinal = wantedNumberOfInstances;
            this.runTransaction(() -> {
                int i = group.getInstancesOfType(componentTypeId.getType()).size();
                while ((long)i < wantedNumberOfInstancesFinal) {
                    this.createComponentInstance(componentTypeId.getTypeId(), null, group.getName(), APeriphController.class);
                    ++i;
                }
            });
        }
    }

    public IComponentInstanceConfig createCopy(IComponentInstanceConfig original, IFunctionalGroup group) {
        StoragePeriphsComponentInstance storageComponent = new StoragePeriphsComponentInstance(original.getStorageComponent());
        storageComponent.setUUID(UUID.randomUUID().toString());
        Collection<@NonNull String> usedNames = this.getUsedNamesInGroupsWithSamePrefix(group.getIdPrefix());
        String newName = storageComponent.getName();
        if (usedNames.contains(newName)) {
            newName = UtilsText.createUniqueName((String)newName, usedNames, (boolean)true, (boolean)KEPreferences.isGenerateFullInstanceIdentification());
        }
        storageComponent.setName(newName);
        ComponentInstanceConfig copyInstance = new ComponentInstanceConfig(original.getComponent(), group, storageComponent, group.getChildContext(), (ICommonMcu)this.mcu);
        this.handleSettingChange(1, APeriphController.class, Messages.get().APeriphController_CopyInstance, true, (IChild)copyInstance, true);
        return copyInstance;
    }

    public abstract @Nullable Display getDisplay();

    public abstract void markPeripheralAsUsed(String var1);

    public abstract boolean isPeripheralMarkedAsUsed(String var1);

    @Deprecated
    public abstract void unmarkPeripheralAsUsed(String var1);

    public boolean isInstanceTypeMarkPeripheralAsUsed(IComponentInstanceConfig instance) {
        return instance.getType().equals("custom_init");
    }

    public List<DependencyResponseConfig> getDependencyResponses(String groupName) {
        IFunctionalGroup group = this.getProfile().getFunctionalGroup(groupName);
        if (group == null) {
            return Collections.emptyList();
        }
        return (List)group.getInstances().values().stream().filter(i -> i.isAvailable() && i.isEnabled()).flatMap(i -> i.getDependencyResponses().stream()).collect(CollectorsUtils.toList());
    }

    public void setEditingLockOfInstance(IComponentInstanceConfig instance, boolean state) {
        instance.setEditingLockState(state);
        this.handleSettingChange(1, APeriphController.class, state ? Messages.get().APeriphController_LockEditingOfInstance : Messages.get().APeriphController_UnlockEditingOfInstance);
    }

    protected @Nullable File getProcessorMex() {
        IMcuIdentification mcuIdentification = this.profile.getMcu().getMcuIdentification();
        return ConfigurationUtils.getPresetMex((String)mcuIdentification.getMcu(), (String)mcuIdentification.getPackage(), (String)mcuIdentification.getSdkVersion());
    }

    public boolean hasProcessorMex() {
        File mex = this.getProcessorMex();
        return mex != null && mex.exists();
    }

    private void syncPresettedSettings(IPresettable presettable) {
        if (presettable instanceof IChildProvidable) {
            List settings = ChildProviderHelper.getAllSettings((IChildProvidable)((IChildProvidable)presettable));
            for (ISettingConfig setting : settings) {
                if (!setting.isSynchronizationEnabled()) continue;
                this.getProfile().getSettingsToSyncByChild((IChild)setting).forEach(x -> x.synchronizeValue((IChild)setting));
            }
        }
    }

    public boolean isOn() {
        return false;
    }
}

