/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.debugger.registry.core;

import com.nxp.s32ds.cle.runtime.debugger.internal.registry.core.DebuggerRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.debugger.registry.Configuration;
import com.nxp.s32ds.cle.runtime.debugger.registry.DebuggerConfigurationDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.registry.DebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.registry.DebuggerRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DebuggerDescriptors {
    public static DebuggerRegistry getDebuggerRegistry() {
        return DebuggerRegistryCoreActivator.getInstance().getDebuggerRegistry();
    }

    public static List<DebuggerDescriptor> getDebuggerDescriptors() {
        DebuggerRegistry familyRegistry = DebuggerRegistryCoreActivator.getInstance().getDebuggerRegistry();
        return familyRegistry.getDebuggerDescriptors();
    }

    public static DebuggerDescriptor getDebuggerDescriptor(String familyId) {
        DebuggerRegistry familyRegistry = DebuggerRegistryCoreActivator.getInstance().getDebuggerRegistry();
        return familyRegistry.getDebuggerDescriptor(familyId);
    }

    public static Map<String, Configuration> getDeviceDebuggerConfiguration(String debugger) {
        DebuggerRegistry registry = DebuggerDescriptors.getDebuggerRegistry();
        HashMap<String, Configuration> deduggerConfigurations = new HashMap<String, Configuration>();
        registry.getDebuggerConfigurationDescriptors().stream().filter(p -> p.getDebugger().equals(debugger)).map(DebuggerConfigurationDescriptor::getConfigurationByDevice).filter(p -> p != null).collect(Collectors.toList()).forEach(e -> deduggerConfigurations.putAll((Map<String, Configuration>)e));
        return deduggerConfigurations;
    }

    public static List<Configuration> getDeviceDebuggerConfiguration(String debugger, String device) {
        DebuggerRegistry registry = DebuggerDescriptors.getDebuggerRegistry();
        return registry.getDebuggerConfigurationDescriptors().stream().filter(p -> p.getDebugger().equals(debugger)).map(DebuggerConfigurationDescriptor::getConfigurationByDevice).map(e -> (Configuration)e.get(device)).filter(p -> p != null).collect(Collectors.toList());
    }

    public static List<Configuration> getDeviceCoreDebuggerConfiguration(String debugger, String deviceCore) {
        DebuggerRegistry registry = DebuggerDescriptors.getDebuggerRegistry();
        return registry.getDebuggerConfigurationDescriptors().stream().filter(p -> p.getDebugger().equals(debugger)).map(DebuggerConfigurationDescriptor::getConfigurationByDeviceCore).map(e -> (Configuration)e.get(deviceCore)).filter(p -> p != null).collect(Collectors.toList());
    }

    public static String getDeviceCoreDebuggerConfigurationPort(String debugger, String deviceCore) {
        List<Configuration> configuration = DebuggerDescriptors.getDeviceCoreDebuggerConfiguration(debugger, deviceCore);
        if (configuration != null && !configuration.isEmpty()) {
            return configuration.get(0).getPort();
        }
        return "";
    }

    public static String getDeviceCoreDebuggerConfigurationScript(String debugger, String deviceCore) {
        List<Configuration> configuration = DebuggerDescriptors.getDeviceCoreDebuggerConfiguration(debugger, deviceCore);
        if (configuration != null && !configuration.isEmpty()) {
            return configuration.get(0).getScript();
        }
        return "";
    }

    public static String getDeviceDebuggerConfigurationScript(String debugger, String device) {
        List<Configuration> configuration = DebuggerDescriptors.getDeviceDebuggerConfiguration(debugger, device);
        if (configuration != null && !configuration.isEmpty()) {
            return configuration.get(0).getScript();
        }
        return "";
    }

    public static boolean getDeviceDebuggerSecureDebuggingAvailable(String debugger, String device) {
        List<Configuration> configuration = DebuggerDescriptors.getDeviceDebuggerConfiguration(debugger, device);
        if (configuration != null && !configuration.isEmpty()) {
            return configuration.get(0).isSecureDebuggingAvailable();
        }
        return false;
    }
}

