/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.gdbjtag.internal.segger;

import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class SeggerLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    private static final String SEGGER_TYPE_PREFIX = "ilg.gnuarmeclipse.debug.gdbjtag.jlink.";
    private static final String SEGGER_LAUNCH_CONFIGURATION_TYPE_ID = "ilg.gnuarmeclipse.debug.gdbjtag.jlink.launchConfigurationType";
    private static final String ATTR_SEGGER_DEVICE_NAME = "ilg.gnuarmeclipse.debug.gdbjtag.jlink.gdbServerDeviceName";
    private static final String ATTR_SEGGER_DEBUG_IN_RAM_NAME = "ilg.gnuarmeclipse.debug.gdbjtag.jlink.doDebugInRam";
    private static final String ATTR_PNE_DEB = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String DEBUGGER_ID = "segger";

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String component;
        IResource launchResource;
        ILaunchConfigurationType debuggerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(SEGGER_LAUNCH_CONFIGURATION_TYPE_ID);
        if (debuggerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(component = LaunchConfigurationUtil.extractComponent(attributes)) + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = debuggerLaunchType.newInstance((IContainer)container, component);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workConfig, Map<String, Object> attributes) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        workConfig.setMappedResources(new IResource[]{project});
        String buildArtifact = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        workConfig.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workConfig.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        String toolchainId = LaunchConfigurationUtil.extractHardwareToolchainId(attributes);
        String deviceCoreId = LaunchConfigurationUtil.extractHardwareDeviceCoreId(attributes);
        workConfig.setAttribute(ATTR_SEGGER_DEVICE_NAME, DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId).getDeviceId());
        String gdbClientValue = LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)DEBUGGER_ID, (String)toolchainId);
        workConfig.setAttribute(ATTR_PNE_DEB, gdbClientValue);
        workConfig.setAttribute(ATTR_SEGGER_DEBUG_IN_RAM_NAME, true);
    }
}

