/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.core;

import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class CoreDescriptors {
    public static CoreRegistry getCoreRegistry() {
        CoreRegistry coreRegistry = HardwareRegistryCoreActivator.getDefault().getCoreRegistry();
        return coreRegistry;
    }

    public static List<CoreDescriptor> getCoreDescriptors() {
        CoreRegistry coreRegistry = HardwareRegistryCoreActivator.getDefault().getCoreRegistry();
        return coreRegistry.getCoreDescriptors();
    }

    public static CoreDescriptor getCoreDescriptor(String coreId) {
        CoreRegistry coreRegistry = HardwareRegistryCoreActivator.getDefault().getCoreRegistry();
        return coreRegistry.getCoreDescriptor(coreId);
    }

    public static List<BoardDescriptor> getBoardDescriptors(String coreId) {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        List deviceCoreDescriptors = deviceRegistry.getDeviceCoreDescriptorsByCoreId(coreId);
        LinkedHashSet<String> deviceIds = new LinkedHashSet<String>();
        for (DeviceCoreDescriptor deviceCoreDescriptor : deviceCoreDescriptors) {
            String deviceId = deviceCoreDescriptor.getDeviceId();
            deviceIds.add(deviceId);
        }
        BoardRegistry boardRegistry = HardwareRegistryCoreActivator.getDefault().getBoardRegistry();
        LinkedHashSet<String> boardIds = new LinkedHashSet<String>();
        for (String deviceId : deviceIds) {
            List boardDeviceDescriptors = boardRegistry.getBoardDeviceDescriptorsByDeviceId(deviceId);
            for (BoardDeviceDescriptor boardDeviceDescriptor : boardDeviceDescriptors) {
                String boardId = boardDeviceDescriptor.getBoardId();
                boardIds.add(boardId);
            }
        }
        ArrayList<BoardDescriptor> boardDescriptors = new ArrayList<BoardDescriptor>();
        for (String boardId : boardIds) {
            BoardDescriptor boardDescriptor = boardRegistry.getBoardDescriptor(boardId);
            boardDescriptors.add(boardDescriptor);
        }
        return boardDescriptors;
    }

    public static List<DeviceDescriptor> getDeviceDescriptors(String coreId) {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        List deviceCoreDescriptors = deviceRegistry.getDeviceCoreDescriptorsByCoreId(coreId);
        LinkedHashSet<String> deviceIds = new LinkedHashSet<String>();
        for (DeviceCoreDescriptor deviceCoreDescriptor : deviceCoreDescriptors) {
            String deviceId = deviceCoreDescriptor.getDeviceId();
            deviceIds.add(deviceId);
        }
        ArrayList<DeviceDescriptor> deviceDescriptors = new ArrayList<DeviceDescriptor>();
        for (String deviceId : deviceIds) {
            DeviceDescriptor deviceDescriptor = deviceRegistry.getDeviceDescriptor(deviceId);
            if (deviceDescriptor == null) continue;
            deviceDescriptors.add(deviceDescriptor);
        }
        return deviceDescriptors;
    }

    public static List<FamilyDescriptor> getFamilyDescriptors(String coreId) {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        List deviceCoreDescriptors = deviceRegistry.getDeviceCoreDescriptorsByCoreId(coreId);
        LinkedHashSet<String> deviceIds = new LinkedHashSet<String>();
        for (DeviceCoreDescriptor deviceCoreDescriptor : deviceCoreDescriptors) {
            String deviceId = deviceCoreDescriptor.getDeviceId();
            deviceIds.add(deviceId);
        }
        FamilyRegistry familyRegistry = HardwareRegistryCoreActivator.getDefault().getFamilyRegistry();
        LinkedHashSet<String> familyIds = new LinkedHashSet<String>();
        for (String deviceId : deviceIds) {
            List boardDeviceDescriptors = familyRegistry.getFamilyDeviceDescriptorsByDeviceId(deviceId);
            for (FamilyDeviceDescriptor boardDeviceDescriptor : boardDeviceDescriptors) {
                String familyId = boardDeviceDescriptor.getFamilyId();
                familyIds.add(familyId);
            }
        }
        ArrayList<FamilyDescriptor> familyDescriptors = new ArrayList<FamilyDescriptor>();
        for (String boardId : familyIds) {
            FamilyDescriptor familyDescriptor = familyRegistry.getFamilyDescriptor(boardId);
            familyDescriptors.add(familyDescriptor);
        }
        return familyDescriptors;
    }

    public static String getBootCoreName(String deviceCoreId) {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        DeviceCoreDescriptor deviceCoreDescriptor = deviceRegistry.getDeviceCoreDescriptor(deviceCoreId);
        if (deviceCoreDescriptor == null) {
            return "";
        }
        String bootCore = deviceCoreDescriptor.getBoot();
        if (bootCore != null && !bootCore.isEmpty() && Boolean.parseBoolean(bootCore)) {
            return deviceCoreDescriptor.getName();
        }
        return "";
    }

    public static String getCoreLabel(CoreDescriptor coreDescriptor) {
        if (coreDescriptor == null) {
            return null;
        }
        return coreDescriptor.getName();
    }
}

