/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core.connection;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.connection.DebuggerUsbConnectionInterface;
import com.nxp.s32ds.debug.ide.core.connection.FirmwareUpdateErrors;
import com.nxp.s32ds.debug.ide.core.connection.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;

public abstract class LinuxDebuggerUsbConnection
implements DebuggerUsbConnectionInterface {
    protected static final String SH_RUNNER_REQUEST = "/bin/sh";
    protected static final String USB_DEVICES_REQUEST = "usb-devices";
    protected static final String USB_DEVICE_PRODUCT = "Product=";
    protected static final String USB_DEVICE_SERIAL_NUMBER = "SerialNumber=";
    protected static final String NMCLI_CONNECTIONS_REQUEST = "nmcli connection show | grep 'ethernet' | awk -F'  ' '{print $1}'";
    protected static final String NMCLI_CONNECTION_MAC_REQUEST = "nmcli connection show '%s' | grep '\\.mac-address:' | awk '{print $2}'";
    protected static final String NMCLI_CONNECTION_DHCP_REQUEST = "nmcli connection show '%s' | grep 'dhcp_server_identifier' | awk -F' = ' '{print $2}'";
    protected static final String UNKNOWN_DEVICE_NAME = "Unknown device";

    protected final List<String> runProcessForOutput(String toExecute) {
        Process process = null;
        String[] linuxExecute = new String[]{SH_RUNNER_REQUEST, "-c", toExecute};
        try {
            List<String> list;
            block16: {
                process = Runtime.getRuntime().exec(linuxExecute);
                Throwable throwable = null;
                Object var5_7 = null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    list = reader.lines().collect(Collectors.toList());
                    if (reader == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ex) {
                        DebuggerCoreActivator.getInstance().logError(String.valueOf(toExecute) + ex.getMessage());
                        List<String> list2 = Collections.emptyList();
                        return list2;
                    }
                }
                reader.close();
            }
            return list;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    @Override
    public Collection<DeviceConnection> getConnectedDevices(DebuggerConnectionDescriptor connectionDescriptor, String vid, String pid) {
        HashSet<DeviceConnection> devices = new HashSet<DeviceConnection>();
        List<String> usbRequestResult = this.runProcessForOutput(USB_DEVICES_REQUEST);
        boolean deviceFound = false;
        String serialNumber = "";
        String product = "";
        for (String resultString : usbRequestResult) {
            int index;
            if (resultString.contains(vid.toLowerCase()) && resultString.contains(pid.toLowerCase())) {
                if (deviceFound) {
                    serialNumber = "";
                    product = "";
                    continue;
                }
                deviceFound = true;
                continue;
            }
            if (!deviceFound) continue;
            if (resultString.contains(USB_DEVICE_PRODUCT)) {
                index = resultString.indexOf(USB_DEVICE_PRODUCT);
                product = resultString.substring(index + USB_DEVICE_PRODUCT.length());
            }
            if (!resultString.contains(USB_DEVICE_SERIAL_NUMBER)) continue;
            index = resultString.indexOf(USB_DEVICE_SERIAL_NUMBER);
            serialNumber = resultString.substring(index + USB_DEVICE_SERIAL_NUMBER.length());
            if (product.isEmpty()) {
                product = connectionDescriptor.getConnectionDescription();
            }
            devices.add(this.createDeviceConnection(connectionDescriptor.getConnectionName(), serialNumber, product));
            serialNumber = "";
            product = "";
            deviceFound = false;
        }
        return devices;
    }

    protected DeviceConnection createDeviceConnection(String connectionName, String serialNumber, String product) {
        DeviceConnection deviceConnection = new DeviceConnection(connectionName, false);
        deviceConnection.setDeviceConnectionData(serialNumber);
        deviceConnection.setDeviceUiFriendlyName(NLS.bind((String)Messages.Debugger_connection_ui_pattern, (Object)serialNumber, (Object)product));
        return deviceConnection;
    }

    protected final String runFirmwareUpateProcess(String toExecute) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(toExecute);
            CompletionStage future = process.onExit().thenApply(p -> {
                Integer exitCode = p.exitValue();
                return FirmwareUpdateErrors.getErrorMessage(exitCode);
            });
            String string = (String)future.get();
            return string;
        }
        catch (IOException e) {
            DebuggerCoreActivator.getInstance().logError(String.valueOf(toExecute) + e.getMessage());
        }
        catch (InterruptedException e) {
            DebuggerCoreActivator.getInstance().logError(String.valueOf(toExecute) + e.getMessage());
        }
        catch (ExecutionException e) {
            DebuggerCoreActivator.getInstance().logError(String.valueOf(toExecute) + e.getMessage());
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return "";
    }
}

