/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.heapusage;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.views.heapusage.Heap;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapBlock;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapRegion;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapType;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import com.nxp.freertos.gdb.tad.view.views.heapusage.Heap5TreeChildItem;
import com.nxp.freertos.gdb.tad.view.views.heapusage.HeapBlockItem;
import java.util.LinkedList;
import java.util.List;

public class HeapItem
extends TadItem {
    private Heap heap;
    private List<HeapBlockItem> heapBlockItems;
    private List<TadItem> treeChildren;

    public HeapItem(Heap heap) {
        super(1);
        this.heap = heap;
        int i = 0;
        this.heapBlockItems = new LinkedList<HeapBlockItem>();
        for (HeapBlock block : heap.getHeapBlocks()) {
            this.heapBlockItems.add(new HeapBlockItem(block, ++i));
        }
        this.treeChildren = new LinkedList<TadItem>();
        if (heap.getType() == HeapType.HEAP_5) {
            i = 0;
            for (HeapRegion region : heap.getHeap5regions()) {
                this.treeChildren.add(new Heap5TreeChildItem(++i, region));
            }
        }
    }

    @Override
    public List<? extends TadItem> getTreeChildren() {
        return this.treeChildren;
    }

    @Override
    public List<? extends TadItem> getChildItems() {
        return this.heapBlockItems;
    }

    @Override
    public int getTextColour() {
        if (!this.hasChildItems()) {
            return 16;
        }
        return super.getTextColour();
    }

    @Override
    public String toString(Separator separator) {
        return super.toString(new TadColumnId[]{TadColumnId.TYPE, TadColumnId.ADDRESS_START, TadColumnId.ADDRESS_END, TadColumnId.USAGE, TadColumnId.FREE_SPACE, TadColumnId.USAGE_GRAPH}, separator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getText(TadColumnId column) {
        try {
            switch (column) {
                case TYPE: {
                    return String.format("%s", this.heap.getType().toString());
                }
                case ADDRESS_START: {
                    return String.format("0x%08x", this.heap.getHeapStart());
                }
                case ADDRESS_END: {
                    return String.format("0x%08x", this.heap.getHeapEnd());
                }
                case USAGE: {
                    return String.format("%s / %s", this.heap.getUsed() != null ? HeapItem.formatBytes(this.heap.getUsed()) : Texts.get("Error.QuestionMark"), HeapItem.formatBytes(this.heap.getSize()));
                }
                case FREE_SPACE: {
                    if (this.heap.getUsed() == null && this.heap.getFree() == 0L) {
                        return Texts.get("Error.Unknown");
                    }
                    return String.format("%.2f%% (%s)", 100.0 - Auxiliary.getPercentage(this.heap.getUsed(), this.heap.getSize()), HeapItem.formatBytes(this.heap.getFree()));
                }
                case USAGE_GRAPH: {
                    if (this.heap.getUsed() == null) {
                        return null;
                    }
                    return String.format("%.2f%%", Auxiliary.getPercentage(this.heap.getUsed(), this.heap.getSize()));
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.exception(e, String.format(Texts.get("Exception.WhileGetTextColumn"), column.toString()));
            return null;
        }
    }

    @Override
    public Long getNumValue(TadColumnId column) {
        switch (column) {
            case ADDRESS_START: {
                return this.heap.getHeapStart();
            }
            case ADDRESS_END: {
                return this.heap.getHeapEnd();
            }
            case USAGE: 
            case USAGE_GRAPH: {
                return this.heap.getUsed();
            }
        }
        return null;
    }

    public Heap getHeap() {
        return this.heap;
    }
}

