/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model.views.tasklist;

import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOS;
import com.nxp.freertos.gdb.tad.model.views.TadObject;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskEventObject;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskPriority;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskStack;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskStackGrowth;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskState;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskType;
import com.nxp.freertos.gdb.tad.strings.Texts;

public class Task
extends TadObject {
    private String name;
    private long address;
    private Long number;
    private Long TCBNumber;
    private TaskState state;
    private TaskStack stack;
    private TaskPriority priority;
    private Long taskRuntime;
    private TaskEventObject eventObject;
    private TaskType type;
    private FreeRTOS freeRTOS;

    public Task(String name, long address, FreeRTOS freeRTOS) {
        this.name = name != null && name.length() > 0 ? name : Texts.get("Error.Unknown");
        this.address = address;
        this.freeRTOS = freeRTOS;
        this.state = TaskState.BLOCKED;
        this.number = null;
        this.TCBNumber = null;
        this.eventObject = new TaskEventObject();
        this.type = TaskType.USER;
    }

    public Long getTCBNumber() {
        return this.TCBNumber;
    }

    public Long getTaskNumber() {
        return this.number;
    }

    public void setNumber(long number, long TCBNumber) {
        this.number = number;
        this.TCBNumber = TCBNumber;
    }

    public TaskPriority getPriority() {
        return this.priority;
    }

    public void setPriority(TaskPriority priority) {
        this.priority = priority;
    }

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public long getAddress() {
        return this.address;
    }

    public boolean isActive() {
        return this.state == TaskState.RUNNING;
    }

    public TaskStack getStack() {
        return this.stack;
    }

    public void setStack(TaskStack stack) {
        this.stack = stack;
    }

    public Long getTaskRuntime() {
        return this.taskRuntime;
    }

    public long getRuntime() {
        return this.freeRTOS.getRuntime();
    }

    public void setTaskRuntime(Long taskRuntime) {
        this.taskRuntime = taskRuntime;
    }

    public TaskStackGrowth getTaskStackGrowth() {
        return this.freeRTOS.getTaskStackGrowth();
    }

    public TaskEventObject getEventObject() {
        return this.eventObject;
    }

    public void setEventObject(TaskEventObject eventObject) {
        this.eventObject = eventObject;
    }

    public TaskType getType() {
        return this.type;
    }
}

