/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.debug.resetbutton;

import com.freescale.s32ds.cdt.debug.resetbutton.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ResetPropertyTester
extends PropertyTester {
    public static final String PROPERTY_NAMESPACE = "com.freescale.s32ds.cdt.debug.resetbutton";
    public static final String PROPERTY_CAN_RESET = "canReset";
    public static final String ATTR_DEFAULT = "unknown";
    public static final String PNE_NAMESPACE = "com.pemicro.debug.gdbjtag.pne.";
    public static final String ATTR_PE_DEVICE_NAME = "com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME";
    public static final String ATTR_PE_SELECTED_CORE_NUMBER = "com.pemicro.debug.gdbjtag.pne.selectedCoreNumber";
    public static final String ATTR_PE_NUMBER_ELVES = "com.pemicro.debug.gdbjtag.pne.NUMBER_ELVES";
    private final List<String> pattern = new ArrayList<String>();

    public ResetPropertyTester() {
        this.pattern.add("Freescale_MAC57D5xx_MAC57D54H");
        this.pattern.add("NXP_MAC57D5xx_MAC57D54H");
        this.pattern.add("Freescale_S32Vxxx_S32V234M100");
        this.pattern.add("NXP_S32Vxxx_S32V234M100");
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        ILaunch launch;
        if (PROPERTY_CAN_RESET.equals(property) && receiver != null && (launch = (ILaunch)Platform.getAdapterManager().getAdapter(receiver, ILaunch.class)) != null && !launch.isTerminated()) {
            ILaunchConfiguration lc = launch.getLaunchConfiguration();
            return this.viewerSelectionContains(lc);
        }
        return false;
    }

    protected boolean viewerSelectionContains(ILaunchConfiguration lc) {
        block4: {
            int coreNumber;
            block5: {
                String deviceName = lc.getAttribute(ATTR_PE_DEVICE_NAME, ATTR_DEFAULT);
                coreNumber = lc.getAttribute(ATTR_PE_SELECTED_CORE_NUMBER, -1);
                int elvesNumber = lc.getAttribute(ATTR_PE_NUMBER_ELVES, -1);
                if (!this.pattern.contains(deviceName)) break block4;
                if (elvesNumber <= 0) break block5;
                return false;
            }
            try {
                if (coreNumber == 1) {
                    return false;
                }
            }
            catch (CoreException e) {
                Activator.log(0, "Can't read attribute", e);
            }
        }
        return true;
    }
}

