/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.IHardware;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.TemplateVariable;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.DataFactory;
import com.freescale.s32ds.cross.core.model.registry.ContextDefinition;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import com.freescale.s32ds.cross.core.model.registry.ParameterRegistry;
import com.freescale.s32ds.cross.core.model.registry.ToolchainRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;

public class Hardware
implements IHardware {
    private static Hardware instance = null;
    public static final String OTHER_PROJECTS_WORKING_SET_NAME = "Other Projects";
    private final Map<String, HWModel> modelMap = new HashMap<String, HWModel>();
    private final String[] dataExtensions = new String[]{"Language", "Library", "IO", "FPU", "Debugger", "INSTRMODE", "OPMODE", "Hardware", "Template"};
    private static final String WIZARD_ID = "wizardId";

    public static IHardware instance() {
        if (instance == null) {
            instance = new Hardware();
        }
        return instance;
    }

    private Hardware() {
        this.init(new ToolchainRegistry());
    }

    protected Hardware(ToolchainRegistry toolchainRegistry) {
        this.init(toolchainRegistry);
    }

    private void init(ToolchainRegistry toolchainRegistry) {
        ParameterRegistry parameterRegistry = this.createParameterRegistry();
        List<ModelRegistry> registries = this.createRegistries(parameterRegistry, toolchainRegistry);
        for (ModelRegistry registry : registries) {
            try {
                this.modelMap.put(registry.getId(), new HWModel(registry));
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    @Override
    public HWModel getModel(String wizardId) {
        return this.modelMap.get(wizardId);
    }

    @Override
    public HWModel getProductModel() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            String property = product.getProperty(WIZARD_ID);
            HWModel hwModel = this.modelMap.get(property);
            return hwModel;
        }
        return null;
    }

    @Override
    public Collection<HWModel> getModels() {
        return this.modelMap.values();
    }

    @Override
    public Set<String> getWizardIds() {
        return this.modelMap.keySet();
    }

    private ParameterRegistry createParameterRegistry() {
        IConfigurationElement cce;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement ce;
        int n3;
        int n4;
        IConfigurationElement[] iConfigurationElementArray2;
        IExtension ext;
        ParameterRegistry parameterRegistry = new ParameterRegistry();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.core.Parameter");
        if (ep == null) {
            return parameterRegistry;
        }
        IExtension[] iExtensionArray = ep.getExtensions();
        int n5 = iExtensionArray.length;
        int n6 = 0;
        while (n6 < n5) {
            ext = iExtensionArray[n6];
            iConfigurationElementArray2 = ext.getConfigurationElements();
            n4 = iConfigurationElementArray2.length;
            n3 = 0;
            while (n3 < n4) {
                ce = iConfigurationElementArray2[n3];
                if ("parameterTypes".equals(ce.getName())) {
                    iConfigurationElementArray = ce.getChildren();
                    n2 = iConfigurationElementArray.length;
                    n = 0;
                    while (n < n2) {
                        cce = iConfigurationElementArray[n];
                        if ("parameterType".equals(cce.getName())) {
                            String tagRef = cce.getAttribute("tagRef");
                            ParameterType refType = parameterRegistry.getParameterType(tagRef);
                            parameterRegistry.registerType(new ParameterType(cce, refType));
                        }
                        ++n;
                    }
                }
                ++n3;
            }
            ++n6;
        }
        iExtensionArray = ep.getExtensions();
        n5 = iExtensionArray.length;
        n6 = 0;
        while (n6 < n5) {
            ext = iExtensionArray[n6];
            iConfigurationElementArray2 = ext.getConfigurationElements();
            n4 = iConfigurationElementArray2.length;
            n3 = 0;
            while (n3 < n4) {
                ce = iConfigurationElementArray2[n3];
                if ("parameters".equals(ce.getName())) {
                    iConfigurationElementArray = ce.getChildren();
                    n2 = iConfigurationElementArray.length;
                    n = 0;
                    while (n < n2) {
                        String tag;
                        ParameterType type;
                        cce = iConfigurationElementArray[n];
                        if ("parameter".equals(cce.getName()) && (type = parameterRegistry.getParameterType(tag = cce.getAttribute("type"))) != null) {
                            parameterRegistry.register(new Parameter(cce, type));
                        }
                        ++n;
                    }
                }
                ++n3;
            }
            ++n6;
        }
        return parameterRegistry;
    }

    private List<ModelRegistry> createRegistries(ParameterRegistry parameterRegistry, ToolchainRegistry toolchainRegistry) {
        int n;
        int n2;
        Object[] objectArray;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.core.NewProjectWizard");
        ArrayList<ModelRegistry> registries = new ArrayList<ModelRegistry>();
        if (ep != null) {
            objectArray = ep.getExtensions();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IExtension ext = objectArray[n];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    try {
                        ModelRegistry r = this.createRegistry(ce, parameterRegistry, toolchainRegistry);
                        if (r != null) {
                            registries.add(r);
                        }
                    }
                    catch (Exception e) {
                        Activator.log(e);
                    }
                    ++n4;
                }
                ++n;
            }
        }
        this.initCdtTemplateToolchains(registries);
        this.initTemplateVariables(registries);
        objectArray = this.dataExtensions;
        n2 = this.dataExtensions.length;
        n = 0;
        while (n < n2) {
            IExtension extension = objectArray[n];
            this.initDataExtensions(registries, (String)extension);
            ++n;
        }
        return registries;
    }

    private ModelRegistry createRegistry(IConfigurationElement wizardElement, ParameterRegistry parameterTypeRegistry, ToolchainRegistry toolchainRegistry) {
        if (!"wizard".equals(wizardElement.getName())) {
            return null;
        }
        String wizardId = wizardElement.getAttribute("id");
        String wizardName = wizardElement.getAttribute("name");
        ModelRegistry registry = new ModelRegistry(wizardId, parameterTypeRegistry, toolchainRegistry);
        registry.setName(wizardName != null ? wizardName : wizardId);
        registry.setValueProvider(ModelUtil.parseWizardValueProvider(wizardElement));
        String description = wizardElement.getAttribute("description");
        if (description != null) {
            registry.setDescription(description);
        }
        registry.addContextDefinition(this.parseContextDefinition(wizardElement, ContextType.PROCESSOR_EXECUTABLE, registry));
        registry.addContextDefinition(this.parseContextDefinition(wizardElement, ContextType.PROCESSOR_LIBRARY, registry));
        registry.addContextDefinition(this.parseContextDefinition(wizardElement, ContextType.PROJECT_EXECUTABLE, registry));
        registry.addContextDefinition(this.parseContextDefinition(wizardElement, ContextType.PROJECT_LIBRARY, registry));
        return registry;
    }

    private IConfigurationElement filterContextElement(ContextType contextType, IConfigurationElement[] ces) {
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (contextType.name().equals(ce.getAttribute("type"))) {
                return ce;
            }
            ++n2;
        }
        return null;
    }

    private IConfigurationElement getFirstChildOf(IConfigurationElement parent, String childTag) {
        if (parent == null) {
            return null;
        }
        IConfigurationElement[] children = parent.getChildren(childTag);
        return children.length > 0 ? children[0] : null;
    }

    private ContextDefinition parseContextDefinition(IConfigurationElement ce, ContextType contextType, ModelRegistry registry) {
        IConfigurationElement[] contextElements = ce.getChildren("context");
        IConfigurationElement contextElement = this.filterContextElement(contextType, contextElements);
        if (contextElement == null) {
            return null;
        }
        ContextDefinition contextDefinition = new ContextDefinition(contextType, contextElement.getAttribute("id"), contextElement.getAttribute("name"), ModelUtil.parseParameterHandler(contextElement), ModelUtil.parseContextStyle(contextElement.getAttribute("style")));
        contextDefinition.setDefaultPart(this.parseContextPart(this.getFirstChildOf(contextElement, "defaultPart"), registry));
        contextDefinition.setTerminationPart(this.parseContextPart(this.getFirstChildOf(contextElement, "terminationPart"), registry));
        return contextDefinition;
    }

    private ContextPart parseContextPart(IConfigurationElement partElement, ModelRegistry registry) {
        if (partElement == null) {
            return null;
        }
        IConfigurationElement[] parameterElements = partElement.getChildren("parameterRef");
        ArrayList<Parameter> pws = new ArrayList<Parameter>();
        IConfigurationElement[] iConfigurationElementArray = parameterElements;
        int n = parameterElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pe = iConfigurationElementArray[n2];
            String pid = pe.getAttribute("parameterId");
            Parameter p = registry.getParameter(pid);
            if (p != null) {
                pws.add(p);
            }
            ++n2;
        }
        return new ContextPart(pws);
    }

    private void initCdtTemplateToolchains(Collection<ModelRegistry> registries) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core.templates");
        if (ep != null) {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] ces;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ces = ext.getConfigurationElements();
                int n3 = ces.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if ("template".equals(ce.getName())) {
                        String id = ce.getAttribute("id");
                        String projectType = ce.getAttribute("projectType");
                        IConfigurationElement tce = this.getFirstChildOf(ce, "toolChain");
                        if (tce != null && tce.getAttribute("id") != null) {
                            for (ModelRegistry registry : registries) {
                                try {
                                    CdtTemplateInfo pt = new CdtTemplateInfo(id, tce.getAttribute("id"), projectType);
                                    registry.registerCdtTemplateInfo(pt);
                                }
                                catch (Exception e) {
                                    Activator.log(e);
                                }
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void initTemplateVariables(List<ModelRegistry> registries) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.core.TemplateVariables");
        if (ep != null) {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] ces;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ces = ext.getConfigurationElements();
                int n3 = ces.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if ("variable".equals(ce.getName())) {
                        TemplateVariable variable = new TemplateVariable(ce);
                        for (ModelRegistry registry : registries) {
                            try {
                                registry.registerTemplateVariable(variable);
                            }
                            catch (Exception e) {
                                Activator.log(e);
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void initDataExtensions(Collection<ModelRegistry> registries, String extensionName) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.core." + extensionName);
        if (ep != null) {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                this.parseDataExtension(registries, ext, extensionName);
                ++n2;
            }
        }
    }

    private void parseDataExtension(Collection<ModelRegistry> registries, IExtension ext, String extensionName) {
        String wizardId = this.findWizardId(ext);
        IConfigurationElement[] ets = ext.getConfigurationElements();
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> elementSets = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = ets;
        int n = ets.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String lcName = ce.getName().toLowerCase();
            if (lcName.endsWith("Set")) {
                elementSets.add(ce);
            } else {
                elements.add(ce);
            }
            ++n2;
        }
        this.initRegistryData(registries, elements, wizardId, extensionName);
        this.initRegistryData(registries, elementSets, wizardId, extensionName);
    }

    private String findWizardId(IExtension ext) {
        IConfigurationElement[] ets;
        IConfigurationElement[] iConfigurationElementArray = ets = ext.getConfigurationElements();
        int n = ets.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String wizardId = ce.getAttribute(WIZARD_ID);
            if (wizardId != null) {
                return wizardId;
            }
            ++n2;
        }
        return null;
    }

    private void initRegistryData(Collection<ModelRegistry> registries, List<IConfigurationElement> elements, String wizardId, String extensionName) {
        boolean isHardware = extensionName.endsWith("Hardware");
        boolean isCommon = wizardId == null && !isHardware;
        for (ModelRegistry registry : registries) {
            if (!isCommon && (!isHardware || !registry.getId().equals(wizardId))) continue;
            this.initRegistryData(registry, elements);
        }
    }

    private void initRegistryData(ModelRegistry registry, List<IConfigurationElement> elements) {
        try {
            for (IConfigurationElement ce : elements) {
                ConfigurationData d = DataFactory.createData(ce, null, registry);
                d.init();
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }
}

