/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.core.servlets.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import java.lang.reflect.Type;
import java.util.Set;

public class CollateralTagsSerializer
implements JsonSerializer<CollateralTag> {
    private CollateralRegistry collateralRegistry;

    public CollateralTagsSerializer(CollateralRegistry collateralRegistry) {
        this.collateralRegistry = collateralRegistry;
    }

    public JsonElement serialize(CollateralTag collateralTag, Type type, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add("id", (JsonElement)new JsonPrimitive(collateralTag.getId()));
        String name = collateralTag.getName();
        if (name != null) {
            result.add("name", (JsonElement)new JsonPrimitive(name));
        }
        Set resourcesByTag = this.collateralRegistry.getResourcesByTag(collateralTag.getId());
        JsonArray jsonDataArray = new JsonArray();
        for (CollateralResource resource : resourcesByTag) {
            jsonDataArray.add(context.serialize((Object)resource));
        }
        result.add("resources", (JsonElement)jsonDataArray);
        return result;
    }
}

