/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controller.validation;

import com.nxp.swtools.bootimage.utils.ABootProblem;
import com.nxp.swtools.bootimage.utils.ABootProblemsManager;
import com.nxp.swtools.bootimage.validation.IProblemSource;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.controller.Messages;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.validation.EfuseProblem;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.IntegerSetting;
import java.util.UUID;

public class EfuseProblemsManager
extends ABootProblemsManager<EfuseProblem> {
    public boolean hasEfuseToolErrors() {
        for (EfuseProblem problem : this.getProblemsList()) {
            if (!problem.isError()) continue;
            return true;
        }
        return false;
    }

    public @Nullable EfuseProblem getEmptyFieldValueProblem(IntegerSetting integerSetting, String textField, String problemSource) {
        if (textField.isEmpty()) {
            UUID id = UUID.randomUUID();
            String fieldValue = "eFUSE: " + Messages.Msg_EmptyFieldValue;
            EfuseProblem problem = new EfuseProblem(2, Messages.Msg_EmptyTextfield, fieldValue, problemSource, Messages.Msg_EmptyTextfield, ABootProblem.Type.EMPTY_VALUE, id, (IProblemSource)integerSetting);
            return !this.hasSourceProblemOfType(problem.getProblemSource(), problem.getType()) ? problem : null;
        }
        return null;
    }

    public @Nullable EfuseProblem getInvalidFieldValueProblem(IntegerSetting integerSetting, String textField, String validationStatusMessage, String problemSource) {
        if (!textField.isEmpty() && !validationStatusMessage.isEmpty()) {
            UUID id = UUID.randomUUID();
            String fieldValue = "eFUSE: " + Messages.Msg_FieldValue + " " + textField;
            EfuseProblem problem = new EfuseProblem(2, validationStatusMessage, fieldValue, problemSource, validationStatusMessage, ABootProblem.Type.INVALID_VALUE, id, (IProblemSource)integerSetting);
            return !this.hasSourceProblemOfType(problem.getProblemSource(), problem.getType()) ? problem : null;
        }
        return null;
    }

    public @Nullable EfuseProblem getAddressLimitProblem(IntegerSetting integerSetting, EnumSetting enumSetting, String problemSource) {
        if (!EfuseControllerUtils.isValueInRange(integerSetting.getConstraintsReferences(), integerSetting.getValueToWrite(), (ABaseUIComponentSetting)enumSetting)) {
            UUID id = UUID.randomUUID();
            String fieldValue = "eFUSE: " + Messages.Msg_FieldValue + " " + integerSetting.getCurrentValue();
            EfuseProblem problem = new EfuseProblem(2, Messages.Msg_AddressLimit, fieldValue, problemSource, Messages.Msg_AddressLimit, ABootProblem.Type.ADDRESS_OUT_OF_RANGE, id, (IProblemSource)integerSetting);
            return !this.hasSourceProblemOfType(problem.getProblemSource(), problem.getType()) ? problem : null;
        }
        return null;
    }
}

