/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controller.report;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IMcu;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class EFuseSummaryGenerator {
    private static final Logger LOGGER = LogManager.getLogger(EFuseSummaryGenerator.class);
    private static String htmlHeader = "";
    private static String htmlFooter = "";
    private static String htmlCopyright = "";
    private static int contentTabs = 0;
    private static Map<String, Supplier<@Nullable String>> templateVariablesResolver;

    private static String getIndent(int indent) {
        return IntStream.range(0, indent).mapToObj(i -> "\t").collect(Collectors.joining(""));
    }

    private static StringBuilder addFormatedLine(StringBuilder sb, String line, int indentLevel) {
        return sb.append(EFuseSummaryGenerator.getIndent(indentLevel)).append(line).append(UtilsText.platformEOL);
    }

    private static int getTabsLevel(String line) {
        int tabsLevel = 0;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!"\t".equals(String.valueOf(c))) break;
            ++tabsLevel;
            ++n2;
        }
        return tabsLevel;
    }

    private static String getFormattedCopyright() {
        String copyright = htmlCopyright;
        for (Map.Entry<String, Supplier<String>> variable : templateVariablesResolver.entrySet()) {
            Supplier<@Nullable String> variableValueProvider = variable.getValue();
            if (variableValueProvider == null) continue;
            String variableValue = variableValueProvider.get();
            if (variableValue == null) {
                variableValue = "N/A";
            }
            copyright = copyright.replace(variable.getKey(), variableValue);
        }
        return copyright;
    }

    private static void initTemplateVariablesResolver() {
        templateVariablesResolver.put("$DATE$", () -> new SimpleDateFormat("EEEE dd-M-yyyy hh:mm:ss").format(new Date()).toString());
        templateVariablesResolver.put("$SDK$", () -> {
            IMcu selectedMcu = EfuseController.getInstance().getMcu();
            if (selectedMcu != null) {
                return selectedMcu.getSdkVersion();
            }
            return "";
        });
        templateVariablesResolver.put("$DATA$", () -> KExProcessorsProvider.getRestApiDataVersion());
        templateVariablesResolver.put("$MCU$", () -> {
            IMcu selectedMcu = EfuseController.getInstance().getMcu();
            if (selectedMcu != null) {
                return selectedMcu.getMcu();
            }
            return "";
        });
        templateVariablesResolver.put("$TOOL$", () -> {
            Bundle bundle = Platform.getBundle((String)"com.nxp.swtools.framework");
            if (bundle == null) {
                return null;
            }
            return bundle.getVersion().getQualifier();
        });
    }

    private static void parseDataHtmlTemplate() {
        if (!"".equals(htmlHeader)) {
            return;
        }
        IMcu selectedMcu = EfuseController.getInstance().getMcu();
        if (selectedMcu != null) {
            Path htmlPath = Paths.get(DataDirectoryUtils.getDataDir((IMcuIdentification)selectedMcu.getMcuIdentification(), (String)"efuse_model"), "report_generation", "efuse_template.html");
            StringJoiner headerBuilder = new StringJoiner(UtilsText.platformEOL);
            StringJoiner footerBuilder = new StringJoiner(UtilsText.platformEOL);
            StringJoiner copyrightBuilder = new StringJoiner(UtilsText.platformEOL);
            boolean markerMet = false;
            boolean copyrightSection = false;
            try {
                List<String> content = Files.readAllLines(htmlPath, StandardCharsets.UTF_8);
                int i = 0;
                while (i < content.size()) {
                    if (content.get(i).contains("$COPYRIGHT_START$")) {
                        copyrightSection = true;
                    } else if (content.get(i).contains("$COPYRIGHT_END$")) {
                        copyrightSection = false;
                    } else if (copyrightSection) {
                        String line = content.get(i);
                        copyrightBuilder.add(line);
                    } else if (content.get(i).contains("$CONTENT$")) {
                        contentTabs = EFuseSummaryGenerator.getTabsLevel(content.get(i));
                        markerMet = true;
                    } else if (markerMet) {
                        footerBuilder.add(content.get(i));
                    } else {
                        headerBuilder.add(content.get(i));
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not read HTML template file for eFUSE Report : " + e);
            }
            htmlHeader = UtilsText.safeString((String)headerBuilder.toString());
            htmlFooter = UtilsText.safeString((String)footerBuilder.toString());
            htmlCopyright = UtilsText.safeString((String)copyrightBuilder.toString());
        }
    }

    private static String getTableRow(FuseWord fuseWord) {
        int position = 31;
        List<FuseField> fuseFieldNotVisibleList = EfuseController.getInstance().getHiddenBootInterfaceFuseField();
        ArrayList fuseFieldList = new ArrayList(fuseWord.getFuseFields());
        Collections.sort(fuseFieldList, (fuse1, fuse2) -> fuse2.getXmlSetting().getOffset() - fuse1.getXmlSetting().getOffset());
        StringBuilder stringBuilder = new StringBuilder();
        String newLine = fuseWord.getValueToWrite() != EfuseControllerUtils.getDefaultFuseWordValue(fuseWord) ? "<td>" + fuseWord.getXmlSetting().getLabel() + "</td><td style=\"background-color:83F881;\">" + "0x" + Long.toHexString(fuseWord.getValueToWrite()) + "</td>" : "<td>" + fuseWord.getXmlSetting().getLabel() + "</td><td>" + "0x" + Long.toHexString(fuseWord.getValueToWrite()) + "</td>";
        stringBuilder.append(newLine);
        for (FuseField fuseField : fuseFieldList) {
            if (fuseFieldNotVisibleList.contains(fuseField)) continue;
            if (position != fuseField.getXmlSetting().getOffset()) {
                int lenghtReservedSpace = position - fuseField.getXmlSetting().getOffset();
                newLine = "<td style=\"background-color:C0BEC8;\" colspan=\"" + lenghtReservedSpace + "\">" + "Reserved" + "</td>";
                stringBuilder.append(newLine);
                position -= lenghtReservedSpace;
            }
            String fuseFieldBinaryFormat = NumberFormatter.formatBinary((long)fuseField.getValueToWrite(), (int)fuseField.getXmlSetting().getSizeValueInBits());
            newLine = fuseField.getValueToWrite() != 0L ? "<td style=\"background-color:83F881;\" colspan=\"" + fuseField.getXmlSetting().getSizeValueInBits() + "\">" + fuseField.getName() + " : " + fuseFieldBinaryFormat + "</td>" : "<td colspan=\"" + fuseField.getXmlSetting().getSizeValueInBits() + "\">" + fuseField.getName() + " : " + fuseFieldBinaryFormat + "</td>";
            stringBuilder.append(newLine);
            position -= fuseField.getXmlSetting().getSizeValueInBits();
        }
        if (fuseFieldList.isEmpty()) {
            stringBuilder.append("<td colspan=\"" + (position + 1) + "\"></td>");
        } else if (position >= 0) {
            stringBuilder.append("<td style=\"background-color:C0BEC8;\" colspan=\"" + (position + 1) + "\">" + "Reserved" + "</td>");
        }
        String tableRow = UtilsText.safeString((String)stringBuilder.toString());
        return !tableRow.isEmpty() ? tableRow : "";
    }

    public static String createTableFromFuseWords(int tabs) {
        EfuseControllerUtils.createHiddenFuseFieldsList();
        StringBuilder stringBuilder = new StringBuilder();
        IMcu mcu = EfuseController.getInstance().getMcu();
        if (mcu != null) {
            List fuseWordList = mcu.getAllFuseWords();
            stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "<table class=\"fuseWordsTable\" border=\"1\">", tabs);
            stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "<tbody>", tabs + 1);
            stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "<tr>", tabs + 2);
            stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "<th>Fuse Word</th>", tabs + 3);
            stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "<th>Value</th>", tabs + 3);
            int i = 31;
            while (i >= 0) {
                stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "<th>" + i + "</th>", tabs + 3);
                --i;
            }
            stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "</tr>", tabs + 2);
            for (FuseWord fuseWord : fuseWordList) {
                stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "<tr>", tabs + 2);
                stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, EFuseSummaryGenerator.getTableRow(fuseWord), tabs + 3);
                stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "</tr>", tabs + 2);
            }
            stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "</tbody>", tabs + 2);
            String table = UtilsText.safeString((String)(stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, "</table>", tabs + 2)).toString());
            return table != null ? table : "";
        }
        return "";
    }

    private static String getHtmlReportConfig() {
        EFuseSummaryGenerator.parseDataHtmlTemplate();
        templateVariablesResolver = new HashMap<String, Supplier<String>>();
        EFuseSummaryGenerator.initTemplateVariablesResolver();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, htmlHeader, 0);
        stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, EFuseSummaryGenerator.createTableFromFuseWords(contentTabs), 0);
        stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, EFuseSummaryGenerator.getFormattedCopyright(), 0);
        stringBuilder = EFuseSummaryGenerator.addFormatedLine(stringBuilder, htmlFooter, 0);
        String report = UtilsText.safeString((String)stringBuilder.toString());
        return !report.isEmpty() ? report : "";
    }

    public static String getReportConfiguration() {
        return UtilsText.safeString((String)EFuseSummaryGenerator.getHtmlReportConfig());
    }
}

