/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controller;

import com.nxp.swtools.bootimage.utils.ABootProblemsManager;
import com.nxp.swtools.codemanager.ICodeGenerator;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.controller.AController;
import com.nxp.swtools.efuse.controller.Messages;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.utils.StorageEfuseUtils;
import com.nxp.swtools.efuse.controller.validation.EfuseProblemsManager;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.EmptyMcu;
import com.nxp.swtools.efuse.model.mcu.IMcu;
import com.nxp.swtools.efuse.model.mcu.McuFactory;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.xml.settings.EfuseXmlConfiguration;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageEfuseConfiguration;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageEfuseTool;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageFuseField;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageFuseWord;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleBooleanProperty;
import org.eclipse.swt.widgets.Display;

public class EfuseController
extends AController
implements ICodeGenerator {
    private static final Logger LOGGER = LogManager.getLogger(EfuseController.class);
    private final ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
    @Nullable
    private ISharedConfigurationListener sharedConfigListener;
    private IMcu mcu;
    private SimpleBooleanProperty isEnabled = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty isOn = new SimpleBooleanProperty();
    private SimpleBooleanProperty isDisposed = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty isSaved = new SimpleBooleanProperty(false);
    private AtomicBoolean shouldUpdateConfiguration = new AtomicBoolean(true);
    @Nullable
    private Display display = SWToolsProperties.isHeadlessOn() ? null : Display.getCurrent();
    private EfuseXmlConfiguration eFuseXmlConfig;
    @Nullable
    private Object configurationUpdateSource = null;
    @Nullable
    protected ABootProblemsManager<?> problemsManager;
    private List<FuseField> hiddenBootInterfaceFuseField = new ArrayList<FuseField>();

    private EfuseController() {
        this.mcu = this.getMcuFromSharedConfig(this.getSharedConfig());
        this.setMcu(this.mcu);
        this.eFuseXmlConfig = this.mcu.getEfuseXmlConfig();
        this.problemsManager = new EfuseProblemsManager();
        this.storeEfuseTool();
        this.reloadFromSharedConfig(this.getSharedConfig(), ConfigChangeReason.UNKNOWN);
        this.sharedConfigListener = new SharedConfigurationAdapter(){

            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
                if (reason.equals((Object)ConfigChangeReason.LOAD_CONFIG) || reason.equals((Object)ConfigChangeReason.RELOAD)) {
                    EfuseControllerUtils.clearAdvancedFusesArray();
                }
                EfuseController.this.reloadFromSharedConfig(sharedConfiguration, reason);
            }

            public void commonConfigurationChanged(@NonNull ISharedConfiguration sharedConfiguration) {
                IMcu currentMcu = EfuseController.this.getMcu();
                if (currentMcu != null && !sharedConfiguration.getCommonConfig().getMcuIdentification().equals(currentMcu.getMcuIdentification())) {
                    this.configurationReloaded(EfuseController.this.getSharedConfig(), ConfigChangeReason.UNKNOWN);
                }
            }

            public void configurationChanged(@NonNull ISharedConfiguration sharedConfiguration, @NonNull IConfigChangeContext changeContext) {
                CommonConfigImpl commonConfigImpl;
                ProcessorCore selectedCore;
                Object source = changeContext.getSource();
                if (source instanceof StorageEfuseTool) {
                    if (((StorageEfuseTool)source).isEnabled() != EfuseController.this.isToolEnabled().get()) {
                        this.configurationReloaded(sharedConfiguration, ConfigChangeReason.UNKNOWN);
                    }
                } else if (source instanceof CommonConfigImpl && (selectedCore = (commonConfigImpl = (CommonConfigImpl)source).getSelectedCore()) != null) {
                    EfuseController.this.handleSettingChange(4, EfuseController.this.getSharedConfig(), null, null);
                }
            }
        };
        this.getSharedConfig().addListener(Objects.requireNonNull(this.sharedConfigListener));
    }

    public static EfuseController getInstance() {
        try {
            EfuseController controller = (EfuseController)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(EfuseController.class));
            if (controller.isDisposed().get()) {
                throw new IllegalStateException("eFUSE Controller is disposed");
            }
            return controller;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain user-singleton instance of: " + EfuseController.class.getSimpleName(), e);
        }
    }

    protected IMcu getMcuFromSharedConfig(ISharedConfiguration sharedConfiguration) {
        ICommonConfig commonConfig = sharedConfiguration.getCommonConfig();
        EmptyMcu selectedMcu = null;
        if (!commonConfig.getMcu().isEmpty()) {
            IMcu currentMcu = this.getMcu();
            if (currentMcu != null && commonConfig.getMcuIdentification().equals(currentMcu.getMcuIdentification()) && !SWToolsProperties.isVerificationOn() && !(currentMcu instanceof EmptyMcu)) {
                selectedMcu = currentMcu;
            } else {
                ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                selectedMcu = McuFactory.create((ISupportedDerivativesForSwTools)derivatives, (ICommonConfig)commonConfig);
            }
        } else {
            selectedMcu = new EmptyMcu(Messages.Msg_NoMcuSelected);
        }
        return selectedMcu == null ? new EmptyMcu(Messages.Msg_CorruptedMcuData) : selectedMcu;
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfiguration, ConfigChangeReason reason) {
        if (this.getSharedConfig() != sharedConfiguration) {
            LOGGER.log(Level.SEVERE, "Unexpected change of shared configuration for eFUSE tool");
            throw new IllegalArgumentException("Unexpected change of shared configuration");
        }
        this.mcu = this.getMcuFromSharedConfig(sharedConfiguration);
        this.setMcu(this.mcu);
        this.setEfuseXmlConfig();
        this.getProblemsManager().clearAllProblems();
        StorageEfuseTool stEfuseTool = sharedConfiguration.getTools().getEfuseTool();
        this.setToolEnabled(stEfuseTool == null || stEfuseTool.isEnabled());
        if (this.isToolEnabled().get()) {
            this.storeEfuseTool();
            this.loadEfuseConfiguration(reason);
        } else {
            this.mcu = new EmptyMcu(Messages.Msg_ToolDisabled);
            this.setMcu(this.mcu);
        }
        this.setToolOn(this.isToolEnabled().get());
        this.handleSettingChange(2, this.getSharedConfig(), null, null);
    }

    private void loadEfuseConfiguration(ConfigChangeReason reason) {
        EfuseControllerUtils.associateUISettingsWithFusesElements(this.mcu);
        EfuseControllerUtils.initAllComponentsState(this.mcu);
        StorageEfuseTool stEfuseTool = this.getSharedConfig().getTools().getEfuseTool();
        if (stEfuseTool != null) {
            StorageEfuseConfiguration stEfuseConfig = stEfuseTool.getEfuseConfiguration();
            if (stEfuseConfig == null || reason.equals((Object)ConfigChangeReason.CLEAR_CONFIG)) {
                EfuseControllerUtils.initAllComponentsValues(this.mcu);
                stEfuseConfig = new StorageEfuseConfiguration();
                stEfuseTool.setEfuseConfiguration(stEfuseConfig);
            } else {
                this.loadFuseWordsFromStorage(stEfuseConfig.getFuseWords());
            }
            EfuseControllerUtils.computeAllGuiComponentsExpressions(this.mcu);
            EfuseControllerUtils.initAllComponentsState(this.mcu);
            EfuseControllerUtils.calculateAllFuseWordsValues(this.mcu);
            StorageEfuseUtils.initializeAllStorageFuseWords(this.mcu, stEfuseTool);
        }
        if (reason.equals((Object)ConfigChangeReason.UNDO_REDO)) {
            EfuseControllerUtils.addModifiedFusesInAdvancedArray();
            this.handleSettingChange(16, this.getSharedConfig(), null, null);
        } else {
            this.handleSettingChange(8, this.getSharedConfig(), null, null);
        }
    }

    private void loadFuseWordsFromStorage(List<StorageFuseWord> stFuseWords) {
        for (StorageFuseWord stFuseWord : stFuseWords) {
            FuseWord fuseWord;
            String eccValue;
            ABaseUIComponentSetting eccComponent;
            boolean fuseWordPopulated = false;
            List stFuseFields = stFuseWord.getFieldsList();
            ABaseUIComponentSetting fuseWordComponent = EfuseUtils.getComponentSettingByFuseWord((IMcu)this.mcu, (String)stFuseWord.getId());
            if (fuseWordComponent != null) {
                EfuseControllerUtils.setUIComponentValue(fuseWordComponent, stFuseWord.getValue());
                fuseWordPopulated = true;
            }
            if ((eccComponent = EfuseUtils.getEccProtectedComponentSettingByFuseWord((IMcu)this.mcu, (String)stFuseWord.getId())) != null && (eccValue = Integer.toString(stFuseWord.isEccProtected() ? 1 : 0)) != null) {
                EfuseControllerUtils.setUIComponentValue(eccComponent, eccValue);
            }
            if (!fuseWordPopulated && (fuseWord = EfuseUtils.getFuseWordByID((List)this.mcu.getAllFuseWords(), (String)stFuseWord.getId())) != null) {
                fuseWord.setValueToWrite(Long.decode(stFuseWord.getValue()).longValue());
            }
            for (StorageFuseField stFuseField : stFuseFields) {
                ABaseUIComponentSetting fuseFieldComponent = null;
                fuseFieldComponent = EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IMcu)this.mcu, (String)stFuseField.getId()) ? EfuseControllerUtils.getComponentSettingBasedOnConstraints(stFuseWords, stFuseField.getId()) : EfuseUtils.getComponentSettingById((IMcu)this.mcu, (String)stFuseField.getId());
                if (fuseFieldComponent == null) continue;
                EfuseControllerUtils.setUIComponentValue(fuseFieldComponent, stFuseField.getValue());
            }
        }
    }

    public @Nullable IMcu getMcu() {
        return this.mcu;
    }

    public void setMcu(IMcu mcu) {
        this.mcu = mcu;
    }

    public ISharedConfiguration getSharedConfig() {
        return this.sharedConfig;
    }

    public SimpleBooleanProperty isToolEnabled() {
        return this.isEnabled;
    }

    public void setToolEnabled(boolean value) {
        this.isEnabled.set(value);
    }

    public SimpleBooleanProperty isToolOn() {
        return this.isOn;
    }

    public void setToolOn(boolean value) {
        this.isOn.set(value);
    }

    public SimpleBooleanProperty isDisposed() {
        return this.isDisposed;
    }

    public void setDisposed(boolean value) {
        this.isDisposed.set(value);
    }

    public SimpleBooleanProperty isSaved() {
        return this.isSaved;
    }

    public void setSaved(boolean value) {
        this.isSaved.set(value);
    }

    public AtomicBoolean getShouldUpdateConfiguration() {
        return this.shouldUpdateConfiguration;
    }

    public void setShouldUpdateConfiguration(boolean value) {
        this.shouldUpdateConfiguration.set(value);
    }

    protected StorageEfuseTool storeEfuseTool() {
        StorageEfuseTool stEfuseTool = this.getSharedConfig().getTools().getEfuseTool();
        if (stEfuseTool == null) {
            stEfuseTool = new StorageEfuseTool();
            this.getSharedConfig().getTools().setEfuseTool(stEfuseTool);
        }
        return stEfuseTool;
    }

    public static boolean isMcuSupported(IMcu mcuToCheck) {
        return !(mcuToCheck instanceof EmptyMcu);
    }

    public boolean isMcuSupported(IMcuIdentification mcuId, String fileType) {
        return !UtilsText.isEmpty((String)DataDirectoryUtils.getDbFile((IMcuIdentification)mcuId, (String)fileType));
    }

    public synchronized void dispose() {
        this.setDisposed(true);
        ISharedConfigurationListener listenerLoc = this.sharedConfigListener;
        if (listenerLoc != null) {
            this.getSharedConfig().removeListener(listenerLoc);
        }
    }

    public void forceCodeRegeneration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable Object inputObject, @Nullable String actionLabel) {
        ISharedConfiguration currentSharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        EfuseController efuseController = this;
        synchronized (efuseController) {
            IMcu currentMcu = this.getMcu();
            if (currentMcu != null && this.getShouldUpdateConfiguration().get() && this.isToolEnabled().get() && EfuseController.isMcuSupported(currentMcu)) {
                if (eventOriginator != currentSharedConfig) {
                    StorageEfuseTool stEfuseTool = this.storeEfuseTool();
                    currentSharedConfig.getTools().setEfuseTool(stEfuseTool);
                    this.setDirty(currentSharedConfig, "eFUSE", stEfuseTool, actionLabel, IConfigChangeContext.ConfigChangeType.TOOL_SETTING_CHANGE);
                }
                this.setSaved(false);
            }
        }
        UIJobHelper.runNowOrInJob(() -> this.fireListeners(new ToolEvent.Builder(eventType).setObject(inputObject).setOriginator(eventOriginator).build()), (String)"Refresh eFUSE tool", (Display)this.display);
    }

    public EfuseXmlConfiguration getEfuseXmlConfig() {
        return this.eFuseXmlConfig;
    }

    public void setEfuseXmlConfig() {
        this.eFuseXmlConfig = this.mcu.getEfuseXmlConfig();
    }

    public void setHiddenBootInterfaceFuseField(List<FuseField> hiddenBootInterfaceFuseField) {
        this.hiddenBootInterfaceFuseField = hiddenBootInterfaceFuseField;
    }

    public List<FuseField> getHiddenBootInterfaceFuseField() {
        return this.hiddenBootInterfaceFuseField;
    }

    public synchronized void stateShouldUpdate(Object source, boolean shouldUpdate) {
        if (this.configurationUpdateSource == null) {
            this.configurationUpdateSource = source;
        } else if (source.equals(this.configurationUpdateSource)) {
            this.configurationUpdateSource = null;
        } else {
            return;
        }
        this.shouldUpdateConfiguration.set(shouldUpdate);
    }

    public EfuseProblemsManager getProblemsManager() {
        return (EfuseProblemsManager)this.problemsManager;
    }

    public void resetToProcessorDefaults() {
        this.getProblemsManager().clearAllProblems();
        EfuseControllerUtils.clearAdvancedFusesArray();
        this.loadEfuseConfiguration(ConfigChangeReason.CLEAR_CONFIG);
        this.handleSettingChange(4, (Object)this, null, UtilsText.safeString((String)Messages.Controller_Action_ResetToProcessorDefaults));
    }
}

