/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.s32debugger;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.ide.debugger.registry.core.DebuggerLaunchConfigurationDescriptors;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.DebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class GdbClientPathResolver {
    private static final String CONFIG_ID_ATTR = "org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR";
    private static Map<String, String> oldGdbPathToNew = new HashMap<String, String>();

    static {
        oldGdbPathToNew.put("${S32DS_GDB_CLIENT_ARM32_EXECUTABLE_PATH}", "${S32DS_GDB_ARM32_PY}");
        oldGdbPathToNew.put("${S32DS_GDB_CLIENT_ARM64_EXECUTABLE_PATH}", "${S32DS_GDB_ARM64_PY}");
    }

    public static String resolve(ILaunchConfigurationWorkingCopy workingCopy, IProject project) throws CoreException {
        ProjectContextSettings projectContextSettings = new ProjectContextSettings(project);
        String deviceCoreId = projectContextSettings.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        String configId = workingCopy.getAttribute(CONFIG_ID_ATTR, "");
        String toolchainId = GdbClientPathResolver.extractToolchainId(project, configId);
        String debuggerId = GdbClientPathResolver.extractDebuggerId(workingCopy.getType());
        if (deviceCoreId.isEmpty() || toolchainId.isEmpty() || debuggerId.isEmpty()) {
            return GdbClientPathResolver.resolveFromMap(workingCopy);
        }
        return LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)debuggerId, (String)toolchainId);
    }

    private static String extractToolchainId(IProject project, String configId) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] configurations = buildInfo.getManagedProject().getConfigurations();
        return Arrays.stream(configurations).filter(cfg -> cfg.getId().equals(configId)).map(cfg -> cfg.getToolChain().getBaseId()).findFirst().orElse("");
    }

    private static String extractDebuggerId(ILaunchConfigurationType type) {
        String lcTypeId = type.getIdentifier();
        return DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry().getDebuggerLaunchConfigurationDescriptorsByLaunchId(lcTypeId).stream().map(DebuggerLaunchConfigurationDescriptor::getDebuggerId).findFirst().orElse("");
    }

    private static String resolveFromMap(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        String gdbOldValue = workingCopy.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "");
        if (gdbOldValue.isEmpty()) {
            return gdbOldValue;
        }
        return oldGdbPathToNew.computeIfAbsent(gdbOldValue, k -> "");
    }
}

