/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.wizard;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SvdSelectPathComposite
extends Composite {
    public static final String ALL_EXT = "*";
    public static final String ALL_NAME = Messages.SvdSelectPathComposite_all;
    protected static final IStatus OK_STATUS = CdtSvdUiActivator.getInstance().createStatus(0, "");
    protected Label label;
    protected Text field;
    protected Button button;
    private int dialogStyle = 8192;
    private String[] extensions = new String[]{"*"};
    private String[] names = new String[]{ALL_NAME};
    private String labelText = Messages.SvdSelectPathComposite_file;
    private String buttonText = Messages.SvdSelectPathComposite_browse;

    public SvdSelectPathComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 0);
        this.label.setText(this.getLabelText());
        this.field = new Text((Composite)this, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.field.setLayoutData((Object)gridData);
        this.button = new Button((Composite)this, 8);
        this.button.setText(this.getButtonText());
        this.button.addListener(13, e -> this.handleBrowseButtonPressed());
    }

    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.field.setEnabled(enabled);
        this.button.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void addModifyListener(ModifyListener listener) {
        this.field.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.field.removeModifyListener(listener);
    }

    public int getDialogStyle() {
        return this.dialogStyle;
    }

    public void setDialogStyle(int dialogStyle) {
        this.dialogStyle = dialogStyle;
    }

    public String[] getFilterExtensions() {
        return this.extensions;
    }

    public void setFilterExtensions(String ... extensions) {
        this.extensions = extensions;
    }

    public String[] getFilterNames() {
        return this.extensions;
    }

    public void setFilterNames(String ... names) {
        this.names = names;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    protected void handleBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getShell(), this.getDialogStyle());
        dialog.setFilterExtensions((String[])Arrays.stream(this.extensions).map(s -> "*." + s).toArray(String[]::new));
        dialog.setFilterNames(this.names);
        dialog.setText(Messages.SvdSelectPathComposite_select_file);
        String file = dialog.open();
        if (file != null) {
            this.field.setText(file);
        }
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String text) {
        this.field.setText(text);
    }

    public IStatus validate() {
        Path path;
        String text = this.field.getText();
        if (text == null || text.trim().isEmpty()) {
            return CdtSvdUiActivator.getInstance().createStatus(4, Messages.SvdSelectPathComposite_no_file_selected);
        }
        try {
            text = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(text);
        }
        catch (CoreException e) {
            return CdtSvdUiActivator.getInstance().createStatus(4, NLS.bind((String)Messages.SvdSelectPathComposite_string_substitution_error_0, (Object)e.getStatus().getMessage()));
        }
        try {
            path = Paths.get(text, new String[0]);
        }
        catch (InvalidPathException e) {
            return CdtSvdUiActivator.getInstance().createStatus(4, NLS.bind((String)Messages.SvdSelectPathComposite_path_is_invalid_0, (Object)e.getMessage()));
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return CdtSvdUiActivator.getInstance().createStatus(4, Messages.SvdSelectPathComposite_selected_path_is_a_directory);
        }
        if (!Files.exists(path, new LinkOption[0]) && path.getParent() != null && !Files.exists(path.getParent(), new LinkOption[0])) {
            return CdtSvdUiActivator.getInstance().createStatus(4, Messages.SvdSelectPathComposite_path_to_file_does_not_exist);
        }
        return OK_STATUS;
    }

    public Path getFilePath() {
        String text = this.field.getText();
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        try {
            text = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(text);
        }
        catch (CoreException coreException) {
            return null;
        }
        return Paths.get(text, new String[0]);
    }
}

