/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view;

import com.nxp.s32ds.cdt.svd.dsf.SvdDsfUtil;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInput;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerStructureChangedListener;
import com.nxp.s32ds.cdt.svd.internal.ui.view.comparator.SvdViewerFieldComparator;
import com.nxp.s32ds.cdt.svd.internal.ui.view.memento.SvdTreeViewerExpandCollapceMemento;
import com.nxp.s32ds.cdt.svd.internal.ui.view.memento.SvdTreeViewerMemento;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelCompositeProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelPeripheralsProviders;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProviders;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdContentModelGroupProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdContentPeripheralProvider;
import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class SvdTreeViewerBase
extends TreeViewer {
    protected static final int DESCRIPTION_COLUMN_WIDTH = 300;
    protected static final int ADDRESS_COLUMN_WIDTH = 100;
    protected static final int PERIPHERAL_COLUMN_WIDTH = 250;
    private final TreeColumnLayout layout;
    private final ITreeContentProvider modelFlatContentProvider;
    private final ITreeContentProvider modelStructuredContentProvider;
    protected final ViewerComparator defaultComparator;
    private final String mementoId;
    private ITreeContentProvider contentProvider;
    private boolean showStructure;
    private final List<TreeViewerColumn> columns = new ArrayList<TreeViewerColumn>();
    private final ListenerList<SvdTreeViewerStructureChangedListener> structureChangedListeners = new ListenerList();
    private boolean bigEndian;

    public void addStructureChangedListener(SvdTreeViewerStructureChangedListener listener) {
        this.structureChangedListeners.add((Object)listener);
    }

    public void removeStructureChangedListener(SvdTreeViewerStructureChangedListener listener) {
        this.structureChangedListeners.remove((Object)listener);
    }

    protected void fireStructureChanged() {
        for (final SvdTreeViewerStructureChangedListener listener : this.structureChangedListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.structureChanged(SvdTreeViewerBase.this);
                }
            });
        }
    }

    public SvdTreeViewerBase(Composite parent, String mementoId) {
        super(parent, 66306);
        this.mementoId = mementoId;
        this.layout = new TreeColumnLayout();
        parent.setLayout((Layout)this.layout);
        this.modelFlatContentProvider = this.createFlatContentProvider();
        this.modelStructuredContentProvider = this.createStructuredContentProvider();
        this.updateContentProvider();
        this.getTree().setLinesVisible(true);
        this.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.initColumns();
        this.defaultComparator = this.createDefaultComparator();
        this.setComparator(this.defaultComparator);
        new SvdTreeViewerMemento(mementoId).restoreFromMemento((Object)this);
    }

    protected ViewerComparator createDefaultComparator() {
        return new SvdViewerFieldComparator();
    }

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        super.internalRefresh(element, updateLabels);
        this.fireStructureChanged();
    }

    protected ITreeContentProvider createFlatContentProvider() {
        return new SvdContentPeripheralProvider();
    }

    protected ITreeContentProvider createStructuredContentProvider() {
        return new SvdContentModelGroupProvider();
    }

    public ITreeContentProvider createContentProvider() {
        if (this.showStructure) {
            return this.createStructuredContentProvider();
        }
        return this.createFlatContentProvider();
    }

    public SvdTreeViewerInput getInput() {
        return (SvdTreeViewerInput)super.getInput();
    }

    public Optional<DsfSession> getDsfSession() {
        return Optional.ofNullable(this.getInput()).map(i -> i.launch).map(l -> l.getSession());
    }

    public void setInput(SvdTreeViewerInput input) {
        this.saveExpandCollapceToMemento();
        super.setInput((Object)input);
        this.bigEndian = false;
        if (input != null) {
            new SvdTreeViewerExpandCollapceMemento(String.valueOf(this.mementoId) + input.model.getUID()).restoreFromMemento((Object)this);
            if (input.launch != null && input.idmContext != null) {
                GdbLaunch launch = input.launch;
                IDMContext idmContext = input.idmContext;
                DsfSession session = launch.getSession();
                if (session != null) {
                    this.bigEndian = SvdDsfUtil.isBigEndian((DsfSession)session, (IDMContext)idmContext);
                }
            }
        }
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void saveToMemento() {
        new SvdTreeViewerMemento(this.mementoId).saveToMemento((Object)this);
        this.saveExpandCollapceToMemento();
    }

    private void saveExpandCollapceToMemento() {
        SvdTreeViewerInput input = this.getInput();
        if (input != null) {
            new SvdTreeViewerExpandCollapceMemento(String.valueOf(this.mementoId) + input.model.getUID()).saveToMemento((Object)this);
        }
    }

    protected void addToColumnsList(TreeViewerColumn column) {
        this.columns.add(column);
    }

    protected final void initColumns() {
        this.createColumns();
        this.setDefaultColumnLayout();
    }

    protected abstract void createColumns();

    protected TreeViewerColumn createDescriptionColumn() {
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this, 0);
        this.addToColumnsList(column);
        column.getColumn().setText(Messages.SvdModelPage_description);
        column.getColumn().setMoveable(true);
        column.setLabelProvider(this.createDescriptionColumnLabelProviders());
        return column;
    }

    protected SvdColumnLabelProvider<?> createDescriptionColumnLabelProviders() {
        return new SvdColumnLabelProviders.DescriptionLabelProvider();
    }

    protected TreeViewerColumn createAddressColumn() {
        final TreeViewerColumn addressColumn = new TreeViewerColumn((TreeViewer)this, 0);
        this.addToColumnsList(addressColumn);
        addressColumn.getColumn().setText(Messages.SvdModelPage_address);
        addressColumn.getColumn().setMoveable(true);
        addressColumn.setLabelProvider(this.createAddressColumnLabelProvider());
        addressColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvdTreeViewerBase.this.setSortColumn(addressColumn);
            }
        });
        return addressColumn;
    }

    protected SvdColumnLabelProvider<?> createAddressColumnLabelProvider() {
        return new SvdColumnLabelProviders.AddressLabelProvider();
    }

    protected TreeViewerColumn createPeripheralsColumn() {
        final TreeViewerColumn peripheralsColumn = new TreeViewerColumn((TreeViewer)this, 0);
        this.addToColumnsList(peripheralsColumn);
        peripheralsColumn.getColumn().setText(Messages.SvdModelPage_peripherals);
        peripheralsColumn.getColumn().setMoveable(false);
        peripheralsColumn.getColumn().addListener(10, e -> this.applyColumnMoved());
        peripheralsColumn.setLabelProvider((CellLabelProvider)this.createPeripheralColumnLabelProvider());
        peripheralsColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvdTreeViewerBase.this.setSortColumn(peripheralsColumn);
            }
        });
        return peripheralsColumn;
    }

    protected ColumnLabelProvider createPeripheralColumnLabelProvider() {
        return new SvdColumnLabelCompositeProvider(this.createPeripheralColumnLabelProviders());
    }

    public SvdColumnLabelProvider<?>[] createPeripheralColumnLabelProviders() {
        return SvdColumnLabelPeripheralsProviders.getProviders();
    }

    private void applyColumnMoved() {
        int[] order = this.getTree().getColumnOrder();
        if (order.length < 2 || order[0] == 0) {
            return;
        }
        int columnNumber = order[0];
        order[0] = 0;
        int i = 1;
        while (i < order.length) {
            int tmp = order[i];
            order[i] = columnNumber;
            columnNumber = tmp;
            if (columnNumber == 0) break;
            ++i;
        }
        this.getTree().setColumnOrder(order);
    }

    public void setDefaultColumnLayout() {
        int[] columnWeights = this.getDefaultColumnWeight();
        int[] columnMinimumWidths = this.getDefaultColumnMinimumWidth();
        TreeViewerColumn[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            this.layout.setColumnData((Widget)columns[i].getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWeights[i], columnMinimumWidths[i]));
            ++i;
        }
    }

    public int[] getDefaultColumnWeight() {
        return SvdTreeViewerBase.widthToWeight(this.getDefaultColumnMinimumWidth());
    }

    public abstract int[] getDefaultColumnMinimumWidth();

    public void setDefaultColumnOrder() {
        this.getTree().setColumnOrder(IntStream.range(0, this.getColumns().length).toArray());
    }

    public abstract void setSortColumn(TreeViewerColumn var1);

    protected void treeColumnClicked(TreeColumn treeColumn, ViewerComparator comparator) {
        Tree tree = treeColumn.getParent();
        if (treeColumn.equals(tree.getSortColumn())) {
            switch (tree.getSortDirection()) {
                case 128: {
                    tree.setSortDirection(1024);
                    this.refresh();
                    break;
                }
                case 1024: {
                    tree.setSortDirection(0);
                    tree.setSortColumn(null);
                    this.setComparator(this.defaultComparator);
                    break;
                }
            }
        } else {
            tree.setSortColumn(treeColumn);
            tree.setSortDirection(128);
            this.setComparator(comparator);
        }
    }

    public boolean showStructure() {
        return this.showStructure;
    }

    public void showStructure(boolean showStructure) {
        if (this.showStructure != showStructure) {
            this.showStructure = showStructure;
            this.getControl().setRedraw(false);
            try {
                SvdTreeViewerExpandCollapceMemento memento = new SvdTreeViewerExpandCollapceMemento(this.mementoId);
                memento.saveToMemento((Object)this);
                this.updateContentProvider();
                memento.restoreFromMemento((Object)this);
            }
            finally {
                this.getControl().setRedraw(true);
            }
        }
    }

    private void updateContentProvider() {
        this.contentProvider = this.showStructure ? this.modelStructuredContentProvider : this.modelFlatContentProvider;
        this.setContentProvider((IContentProvider)this.contentProvider);
    }

    public void select(Object object) {
        this.contentProvider.getParent(object);
        ArrayDeque<Object> deque = new ArrayDeque<Object>();
        Object parent = object;
        while (parent != null) {
            deque.addFirst(parent);
            parent = this.contentProvider.getParent(parent);
        }
        if (deque.isEmpty()) {
            return;
        }
        this.setSelection((ISelection)new TreeSelection(new TreePath(deque.toArray())), true);
    }

    public TreeViewer getTreeViewer() {
        return this;
    }

    public TreeColumnLayout getLayout() {
        return this.layout;
    }

    public TreeViewerColumn[] getColumns() {
        return this.columns.toArray(new TreeViewerColumn[this.columns.size()]);
    }

    public static int[] widthToWeight(int[] widths) {
        int totalWidth = Arrays.stream(widths).sum();
        double onePercent = (double)totalWidth / 100.0;
        int[] weights = new int[widths.length];
        int totalWeight = 0;
        int i = 0;
        while (i < widths.length - 1) {
            weights[i] = (int)((double)widths[i] / onePercent);
            totalWeight += weights[i];
            ++i;
        }
        weights[widths.length - 1] = 100 - totalWeight;
        return weights;
    }

    public void expandAndSelect(SvdChildElement element) {
        if (element == null) {
            return;
        }
        try {
            this.getControl().setRedraw(false);
            this.refresh();
            this.expandToLevel(element, 0);
            this.select(element);
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public SvdChildElement findNextToSelect(Collection<SvdChildElement> toDeleteList) {
        if (toDeleteList.size() == 0) {
            return null;
        }
        long count = toDeleteList.stream().filter(e -> e instanceof SvdRegister).count();
        if (count > 10L) {
            return null;
        }
        HashSet<SvdChildElement> toDeleteSet = new HashSet<SvdChildElement>(toDeleteList);
        ArrayList<SvdChildElement> topElements = new ArrayList<SvdChildElement>();
        for (SvdChildElement childElement : toDeleteList) {
            if (toDeleteSet.contains(this.contentProvider.getParent((Object)childElement))) continue;
            topElements.add(childElement);
        }
        SvdChildElement topElement = (SvdChildElement)topElements.get(0);
        toDeleteSet.clear();
        toDeleteSet.addAll(topElements);
        TreeItem item = SvdTreeViewerBase.findTreeItem(this.getTree().getItems(), topElement);
        if (item == null) {
            return null;
        }
        return this.findNextToSelect(item, toDeleteSet);
    }

    private SvdChildElement findNextToSelect(TreeItem item, Set<SvdChildElement> toDeleteSet) {
        TreeItem[] neighbors = this.getNeighbors(item, toDeleteSet);
        if (neighbors.length == 1) {
            TreeItem parent = item.getParentItem();
            if (parent == null) {
                return null;
            }
            return (SvdChildElement)parent.getData();
        }
        TreeItem next = SvdTreeViewerBase.findNext(neighbors, item);
        if (next != null) {
            return (SvdChildElement)next.getData();
        }
        TreeItem previous = SvdTreeViewerBase.findPrevious(neighbors, item);
        if (previous != null) {
            return (SvdChildElement)previous.getData();
        }
        return null;
    }

    private static TreeItem findPrevious(TreeItem[] neighbors, TreeItem item) {
        int i = 0;
        while (i < neighbors.length) {
            if (neighbors[i] == item) {
                if (i == 0) {
                    return null;
                }
                return neighbors[i - 1];
            }
            ++i;
        }
        return null;
    }

    private static TreeItem findNext(TreeItem[] neighbors, TreeItem item) {
        int i = 0;
        while (i < neighbors.length) {
            if (neighbors[i] == item) {
                if (i == neighbors.length - 1) {
                    return null;
                }
                return neighbors[i + 1];
            }
            ++i;
        }
        return null;
    }

    private TreeItem[] getNeighbors(TreeItem item, Set<SvdChildElement> toDeleteSet) {
        TreeItem parent = item.getParentItem();
        TreeItem[] items = parent == null ? this.getTree().getItems() : parent.getItems();
        return (TreeItem[])Arrays.stream(items).filter(e -> e == item || !toDeleteSet.contains(e.getData())).toArray(TreeItem[]::new);
    }

    private static TreeItem findTreeItem(TreeItem[] items, SvdChildElement element) {
        TreeItem item;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            item = treeItemArray[n2];
            if (element == item.getData()) {
                return item;
            }
            ++n2;
        }
        treeItemArray = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = treeItemArray[n2];
            TreeItem found = SvdTreeViewerBase.findTreeItem(item.getItems(), element);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    public boolean showFullPath() {
        return false;
    }
}

