/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.wizard.core;

import com.freescale.s32ds.cdt.core.OSFamily;
import com.freescale.s32ds.cross.core.model.ConfigurationDescriptor;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.DataFactory;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.nxp.s32ds.cle.ide.debugger.registry.core.DebuggerLaunchConfigurationDescriptors;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.DebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.registry.DebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.registry.DebuggerRegistry;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.CoreDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.reservation.registry.core.HardwareReservationDescriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class WizardProjectContextUtil {
    private static final String NPW_RESTRICTED_DEBUGGERS = "s32ds.npw.restricted.debuggers";

    public static DataSet getDebugerDataSetByContextParameter(CProjectContext projectContext, Parameter parameter) {
        if (!parameter.getTag().equals("debugger")) {
            return null;
        }
        List<ConfigurationData> configs = WizardProjectContextUtil.getDebuggerConfigurationDataByToolChain(projectContext, parameter.getTag());
        return WizardProjectContextUtil.createDataSetByConfigurationData("debuggerSet", (AbstractContext)projectContext, configs);
    }

    public static List<ConfigurationData> getDebuggerConfigurationData(String deviceId, String tag, ModelRegistry registry) {
        List deviceDebuggerDescriptors = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)deviceId);
        return WizardProjectContextUtil.getDebuggerConfigurationData(tag, registry, deviceDebuggerDescriptors);
    }

    public static List<ConfigurationData> getDebuggerConfigurationDataByToolChain(CProjectContext projectContext, String tag) {
        List debuggers;
        String toolchain = projectContext.getToolChainId();
        String device = projectContext.getStringValue("deviceId");
        String family = projectContext.getStringValue("family");
        String platform = projectContext.getStringValue("platform");
        String deviceRevision = projectContext.getStringValue("revision");
        String core = projectContext.getStringValue("hardwareCoreId");
        WizardProjectContextUtil.verify(family, device, core);
        ModelRegistry registry = projectContext.getRegistry();
        ArrayList<ConfigurationData> configs = new ArrayList<ConfigurationData>();
        List<DebuggerDescriptor> debuggerDescriptors = WizardProjectContextUtil.getSuitableDebuggerDescriptors(device, deviceRevision, family, toolchain, platform);
        if (!debuggerDescriptors.isEmpty()) {
            debuggerDescriptors.forEach(descriptor -> {
                boolean bl = configs.add((ConfigurationData)new ConfigurationDescriptor(descriptor, tag, registry));
            });
        }
        if (!device.isEmpty()) {
            debuggers = DeviceCoreDebuggerDescriptors.getDebuggersByDeviceConditions((String)device, (String)toolchain, (String)core, (String)deviceRevision, (String)platform, null);
            if (debuggers.isEmpty()) {
                debuggers = DeviceCoreDebuggerDescriptors.getDebuggersByFamilyConditions((String)family, (String)toolchain, (String)core, (String)deviceRevision, (String)platform, null);
            }
        } else {
            debuggers = DeviceCoreDebuggerDescriptors.getDebuggersByFamilyConditions((String)family, (String)toolchain, (String)core, (String)deviceRevision, (String)platform, null);
        }
        debuggers = WizardProjectContextUtil.removeNPWRestrictedDebuggers(debuggers);
        DebuggerRegistry debuggerRegistry = DebuggerDescriptors.getDebuggerRegistry();
        debuggers.stream().map(c -> debuggerRegistry.getDebuggerDescriptor(c)).forEach(debuggerDescriptor -> {
            if (WizardProjectContextUtil.isAccepted(debuggerDescriptor)) {
                configs.add((ConfigurationData)new ConfigurationDescriptor(debuggerDescriptor, tag, registry));
            }
        });
        return configs;
    }

    @Deprecated
    private static List<DebuggerDescriptor> getSuitableDebuggerDescriptors(String device, String deviceRevision, String family, String toolchain, String platform) {
        ArrayList<DebuggerDescriptor> acceptedDescriptors = new ArrayList<DebuggerDescriptor>();
        List<Object> deviceDebuggerDescriptors = new ArrayList<DeviceDebuggerDescriptor>();
        if (device != null && !device.isEmpty() && deviceRevision != null && !deviceRevision.isEmpty()) {
            deviceDebuggerDescriptors = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)device, (String)deviceRevision, (String)toolchain);
        } else if (device != null && !device.isEmpty() && (deviceRevision == null || deviceRevision.isEmpty())) {
            deviceDebuggerDescriptors = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)device, (String)toolchain);
        } else if ((device == null || device.isEmpty()) && family != null && !family.isEmpty()) {
            deviceDebuggerDescriptors = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptorByFamily((String)family, (String)toolchain);
        }
        WizardProjectContextUtil.sortingByRank(deviceDebuggerDescriptors);
        for (DeviceDebuggerDescriptor descriptor : deviceDebuggerDescriptors) {
            String dbgToolchainId = descriptor.getToolchainId();
            if (dbgToolchainId != null && !dbgToolchainId.isEmpty() && !toolchain.equals(dbgToolchainId)) continue;
            DebuggerRegistry debuggerRegistry = DebuggerDescriptors.getDebuggerRegistry();
            DebuggerDescriptor debuggerDescriptor = debuggerRegistry.getDebuggerDescriptor(descriptor.getDebuggerId());
            if (!WizardProjectContextUtil.isResolvedRequirements(descriptor, platform) || !WizardProjectContextUtil.isAccepted(debuggerDescriptor)) continue;
            acceptedDescriptors.add(debuggerDescriptor);
        }
        return acceptedDescriptors;
    }

    private static void verify(String family, String device, String core) {
        CoreDescriptor coreDescriptor;
        DeviceDescriptor deviceDescriptor;
        FamilyDescriptor familyDescriptor = FamilyDescriptors.getFamilyDescriptor((String)family);
        if (familyDescriptor == null) {
            String msg = NLS.bind((String)"Family desriptor was not found by id: {0}", (Object)family);
            S32DSWizardPlugin.logWarning(msg);
        }
        if ((deviceDescriptor = DeviceDescriptors.getDeviceDescriptor((String)device)) == null) {
            String msg = NLS.bind((String)"Device desriptor was not found by id: {0}", (Object)device);
            S32DSWizardPlugin.logWarning(msg);
        }
        if ((coreDescriptor = CoreDescriptors.getCoreDescriptor((String)core)) == null) {
            String msg = NLS.bind((String)"Core desriptor was not found by id: {0}", (Object)core);
            S32DSWizardPlugin.logWarning(msg);
        }
    }

    private static void sortingByRank(List<DeviceDebuggerDescriptor> deviceDebuggerDescriptors) {
        Collections.sort(deviceDebuggerDescriptors, new Comparator<DeviceDebuggerDescriptor>(){

            @Override
            public int compare(DeviceDebuggerDescriptor o1, DeviceDebuggerDescriptor o2) {
                if (o1.getRank() > o2.getRank()) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public static List<ConfigurationData> getDebuggerConfigurationData(String tag, ModelRegistry registry) {
        ArrayList<ConfigurationData> configs = new ArrayList<ConfigurationData>();
        List debuggerDescriptors = DebuggerDescriptors.getDebuggerRegistry().getDebuggerDescriptors();
        for (DebuggerDescriptor descriptor : debuggerDescriptors) {
            if (!WizardProjectContextUtil.isAccepted(descriptor)) continue;
            configs.add((ConfigurationData)new ConfigurationDescriptor(descriptor, tag, registry));
        }
        return configs;
    }

    private static List<ConfigurationData> getDebuggerConfigurationData(String tag, ModelRegistry registry, List<DeviceDebuggerDescriptor> deviceDebuggerDescriptors) {
        ArrayList<ConfigurationData> configs = new ArrayList<ConfigurationData>();
        for (DeviceDebuggerDescriptor descriptor : deviceDebuggerDescriptors) {
            DebuggerDescriptor debuggerDescriptor = DebuggerDescriptors.getDebuggerRegistry().getDebuggerDescriptor(descriptor.getDebuggerId());
            if (!WizardProjectContextUtil.isAccepted(debuggerDescriptor)) continue;
            configs.add((ConfigurationData)new ConfigurationDescriptor(debuggerDescriptor, tag, registry));
        }
        return configs;
    }

    private static boolean isResolvedRequirements(DeviceDebuggerDescriptor descriptor, String platfrom) {
        String[] expression;
        String requirement = descriptor.getRequirement();
        if (requirement == null || requirement.isEmpty()) {
            return true;
        }
        String[] requirements = requirement.split("::");
        if ("bundle".equals(requirements[0])) {
            Version restrictionByVersion;
            Bundle[] bundles;
            String[] bundleRequirements = requirements[1].split(";");
            if (bundleRequirements.length > 1 && (bundles = Platform.getBundles((String)bundleRequirements[0], (String)(restrictionByVersion = new Version(bundleRequirements[1])).toString())) != null) {
                Bundle[] bundleArray = bundles;
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    Version originalVersion = bundle.getVersion();
                    if (originalVersion.getMajor() == restrictionByVersion.getMajor() && originalVersion.getMinor() == restrictionByVersion.getMinor() && originalVersion.getMicro() == restrictionByVersion.getMicro()) {
                        return true;
                    }
                    ++n2;
                }
            }
        } else if ("platform".equals(requirements[0]) && (expression = requirements[1].split(";")).length == 2) {
            String condition = expression[0];
            String conditionValue = expression[1];
            if (condition.isEmpty()) {
                condition = "equal";
            }
            if (condition.equals("equal")) {
                return platfrom.equals(conditionValue);
            }
            if (condition.equals("notequal")) {
                return !platfrom.equals(conditionValue);
            }
        }
        return false;
    }

    public static DataSet createDataSetByConfigurationData(String tag, AbstractContext context, List<ConfigurationData> configurationDescriptors) {
        DataSet defDataSet = context.getDataSet(tag);
        if (defDataSet == null) {
            return DataFactory.createDataSet((String)tag, (ModelRegistry)context.getRegistry(), null, configurationDescriptors);
        }
        return DataFactory.createDataSetFrom((DataSet)defDataSet, configurationDescriptors);
    }

    private static boolean isAccepted(DebuggerDescriptor debuggerDescriptor) {
        if (debuggerDescriptor == null) {
            return false;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        List configurations = DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry().getDebuggerLaunchConfigurationDescriptorsByDebuggerId(debuggerDescriptor.getId());
        if (configurations.isEmpty()) {
            return false;
        }
        for (DebuggerLaunchConfigurationDescriptor configuration : configurations) {
            String launchConfigurationTypeId = configuration.getLaunchConfigurationTypeIdentifier();
            ILaunchConfigurationType launchCfg = launchManager.getLaunchConfigurationType(launchConfigurationTypeId);
            if (launchCfg != null) continue;
            return false;
        }
        return true;
    }

    public static List<String> removeNPWRestrictedDebuggers(List<String> debuggerIds) {
        HardwareReservationDescriptors.getHardwareReservationDescriptorByType((String)NPW_RESTRICTED_DEBUGGERS).stream().forEach(descriptor -> {
            String debuggerId = descriptor.getBuildObject();
            OSFamily restrictedOS = descriptor.getOperatingSystem();
            if (debuggerIds.contains(debuggerId)) {
                if (restrictedOS != null) {
                    if (restrictedOS.isCurrent()) {
                        debuggerIds.remove(debuggerId);
                    }
                } else {
                    debuggerIds.remove(debuggerId);
                }
            }
        });
        return debuggerIds;
    }
}

