/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.template.AddFilesByConditions;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExcludeResources
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String[] conditions = args[0].getSimpleArrayValue();
        String projectName = args[1].getSimpleValue();
        String configName = args[2].getSimpleValue();
        final String[] files = args[3].getSimpleArrayValue();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            throw new ProcessFailureException(Messages.ExcludeResources_no_CDT_project);
        }
        boolean executeProc = AddFilesByConditions.checkConditions(conditions);
        if (!executeProc) {
            return;
        }
        IConfiguration tmp_conf = null;
        IConfiguration[] iConfigurationArray = info.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration c = iConfigurationArray[n2];
            if (c.getName().equalsIgnoreCase(configName)) {
                tmp_conf = c;
                break;
            }
            ++n2;
        }
        if (tmp_conf == null) {
            S32DSWizardPlugin.logWarning(String.format(Messages.ExcludeResources_no_configuration, configName));
            return;
        }
        final IConfiguration conf = tmp_conf;
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IPath lPath = proxy.requestFullPath();
                if (proxy.getType() == 1 || proxy.getType() == 2) {
                    boolean isDerived = false;
                    IResource res = proxy.requestResource();
                    while (res != null) {
                        isDerived |= res.isDerived();
                        res = res.getParent();
                    }
                    if (!isDerived) {
                        IResourceConfiguration resourceConfig = conf.getResourceConfiguration(lPath.toString());
                        String[] stringArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String f = stringArray[n2];
                            if (lPath.toString().matches(f)) {
                                if (resourceConfig == null) {
                                    resourceConfig = conf.createFileInfo(proxy.requestResource().getFullPath().removeFirstSegments(1));
                                }
                                if (resourceConfig == null) break;
                                resourceConfig.setExclude(true);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                return true;
            }
        };
        try {
            project.accept(visitor, 2);
            if (info.isDirty()) {
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            }
        }
        catch (CoreException ce) {
            throw new ProcessFailureException((Throwable)ce);
        }
    }
}

