/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.backend;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.LibraryContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class WizardUtils {
    private static final String KEY_SDK_UCT = "uctSdk";
    private static final String KEY_SDK_EXTERNAL_ID = "sdkExternalId";

    private WizardUtils() {
    }

    public static Map<String, List<ILanguageSettingsProvider>> removeLanguageSettingsProviders(IProject project) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        HashMap<String, List<ILanguageSettingsProvider>> result = new HashMap<String, List<ILanguageSettingsProvider>>();
        ICProjectDescription cProject = CCorePlugin.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cProject.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            ILanguageSettingsProvidersKeeper keeper = (ILanguageSettingsProvidersKeeper)cfg;
            result.put(cfg.getId(), keeper.getLanguageSettingProviders());
            keeper.setLanguageSettingProviders(Collections.emptyList());
            ++n2;
        }
        mngr.setProjectDescription(project, cProject);
        return result;
    }

    public static void addLanguageSettingsProviders(Map<String, List<ILanguageSettingsProvider>> listeners, IProject project) throws CoreException {
        ICConfigurationDescription[] projectConfigs;
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription cProject = CCorePlugin.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projectConfigs = cProject.getConfigurations();
        int n = projectConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            ILanguageSettingsProvidersKeeper keeper = (ILanguageSettingsProvidersKeeper)cfg;
            if (listeners.containsKey(cfg.getId())) {
                keeper.setLanguageSettingProviders(listeners.get(cfg.getId()));
            } else {
                String configId = ((BuildConfigurationData)cfg.getConfigurationData()).getConfiguration().getParent().getId();
                ICConfigurationDescription[] iCConfigurationDescriptionArray2 = projectConfigs;
                int n3 = projectConfigs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String parentId;
                    ICConfigurationDescription conf = iCConfigurationDescriptionArray2[n4];
                    if (!conf.equals(cfg) && configId.equals(parentId = ((BuildConfigurationData)conf.getConfigurationData()).getConfiguration().getParent().getId())) {
                        keeper.setLanguageSettingProviders(listeners.get(conf.getId()));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        mngr.setProjectDescription(project, cProject);
    }

    public static Map<String, String> mapProjectContext(ProjectContext projectContext) {
        String coreValue;
        List uctSdks;
        Map attachedSdksByTags;
        Map<String, String> contextMap = projectContext.getParameters().stream().map(Parameter::getTag).collect(Collectors.toMap(Function.identity(), arg_0 -> ((ProjectContext)projectContext).getStringValue(arg_0)));
        if (projectContext instanceof CProjectContext && (attachedSdksByTags = SdkManagementUtils.getSdksGroupByTags((List)((CProjectContext)projectContext).getSdkList())) != null && (uctSdks = (List)attachedSdksByTags.get("uct")) != null) {
            for (SdkDescriptor sdk : uctSdks) {
                contextMap.put(KEY_SDK_UCT, sdk.getId());
                contextMap.put(KEY_SDK_EXTERNAL_ID, sdk.getExternalId());
                contextMap.put(sdk.getId(), sdk.getBasePath());
            }
        }
        if (projectContext instanceof LibraryContext && ((coreValue = contextMap.get("core")) == null || coreValue.isEmpty())) {
            LibraryContext libContext = (LibraryContext)projectContext;
            String core = libContext.getGeneralContext().getCurrentProcessorContext().getStringValue("core");
            contextMap.put("core", core);
        }
        IProject project = projectContext.getProject();
        ProjectContextSettings contextProvider = new ProjectContextSettings(project);
        contextMap.putAll(contextProvider.getProjectContextAttributes());
        return contextMap;
    }
}

