/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.backend;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.freescale.s32ds.cross.core.model.DefaultWizardValueProvider;
import com.freescale.s32ds.cross.core.model.IWizardValueProvider;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ExecutableContext;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.gnu.S32DSBuiltinSpecsDetector;
import com.freescale.s32ds.cross.wizard.EmbSysSettingsUtil;
import com.freescale.s32ds.cross.wizard.IWizardParticipant;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardHandler;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.backend.ProjectGenerationContext;
import com.freescale.s32ds.cross.wizard.backend.WizardBackendException;
import com.freescale.s32ds.cross.wizard.backend.WizardUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachProcessor;
import com.nxp.s32ds.cle.runtime.debugger.registry.DebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.CoreDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import com.nxp.s32ds.ext.ide.core.IProjectParticipant;
import com.nxp.s32ds.ext.rcp.datacollection.core.DataCollections;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class WizardBackend {
    private static final String PATH = "PATH";
    private GeneralContext currentContext;
    private final LinkedList<ProjectGenerationContext> generatedProjects = new LinkedList();
    private List<IAdaptable> iad;
    private IConfigurationElement fConfigElement;
    public static final String PROJECT_NAME = "projectName";
    public static final String BASE_NAME = "baseName";
    public static final String CORE_NAME = "CORE_PROJECT_NAME";
    public static final String BASE_NAME_LOWER = "baseNameLower";
    public static final String BASE_NAME_UPPER = "baseNameUpper";
    public static final String LOCATION = "location";
    public static final String OP_COPROC_APU = "APU";
    public static final String OP_COPROC_APU_GRAPH = "APU_GRAPH";
    public static final String OP_COPROC_ISP = "ISP";
    public static final String OP_COPROC_ISP_GRAPH = "ISP_GRAPH";
    public static final String OP_COPROC_ISP_STATIC_SEQUENCER = "ISP_STATIC_SEQUENCER";
    public static final String EMPTY_STRING = "";
    public static final String FILE_MAIN_C = "src/main.c";
    public static final String FILE_MAIN_CPP = "src/main.cpp";
    private static final String DEBUG_OUTPUT_FOLDER = "Debug";
    private static final String RELEASE_OUTPUT_FOLDER = "Release";
    private static final String ELF_FILE = ".elf";
    private static final String WORKSPACE_LOCATION = "workspaceLocation";
    final List<IWizardParticipant> wizardParticipants = S32DSWizardPlugin.getDefault().getWizardParticipants();
    final List<IProjectParticipant> projectParticipants = S32DSWizardPlugin.getDefault().getProjectParticipants();
    private IWizard wizard;

    public void create(IWizard wizard, GeneralContext context, IRunnableContext container, IProgressMonitor monitor) throws WizardBackendException {
        this.wizard = wizard;
        this.currentContext = context;
        Instant start = Instant.now();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.S32DSMultiProjectWizard_creating_projects, (int)2);
        this.doCheck();
        subMonitor.worked(1);
        this.doCreate(container, (IProgressMonitor)subMonitor);
        subMonitor.worked(1);
        this.logTime(start);
        for (ProjectGenerationContext projectContext : this.generatedProjects) {
            IProject project = projectContext.getProject();
            ProjectContextSettings settings = new ProjectContextSettings(project);
            String deviceCore = settings.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
            DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCore);
            if (deviceCoreDescriptor == null || !Boolean.parseBoolean(deviceCoreDescriptor.getBoot())) continue;
            IFile maincFile = project.getFile(FILE_MAIN_C);
            if (maincFile.exists()) {
                WizardBackend.openFile(maincFile);
                continue;
            }
            IFile maincppFile = project.getFile(FILE_MAIN_CPP);
            if (!maincppFile.exists()) continue;
            WizardBackend.openFile(maincppFile);
        }
    }

    public IProject createTempProject(IWizard wizard, GeneralContext context, IRunnableContext container, IProgressMonitor monitor) throws WizardBackendException {
        this.wizard = wizard;
        this.currentContext = context;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.S32DSMultiProjectWizard_creating_projects, (int)2);
        this.createProjects((IProgressMonitor)subMonitor);
        try {
            try {
                container.run(false, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(this.runSetDescriptions(this.currentContext.getResultProjectContexts())));
            }
            catch (InterruptedException | InvocationTargetException e) {
                this.clearProject();
                Thread.currentThread().interrupt();
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            S32DSWizardPlugin.log(e);
            if (e instanceof Exception) {
                throw new WizardBackendException((Exception)e);
            }
            throw new WizardBackendException(e.getMessage());
        }
        return this.generatedProjects.get(0).getProject();
    }

    public static void openFile(final IFile outputTxt) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null) {
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)outputTxt);
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)activeWorkbenchWindow.getShell(), (String)Messages.OpenFileDialog_title, (String)e.getMessage());
                    }
                }
            }
        });
    }

    private void logTime(Instant start) {
        Instant end = Instant.now();
        Duration timeElapsed = Duration.between(start, end);
        String msg = NLS.bind((String)Messages.S32DSProjectWizard_project_creation_time, (Object)((double)timeElapsed.toMillis() / 1000.0));
        S32DSWizardPlugin.logInfo(msg);
    }

    private void doCheck() throws WizardBackendException {
        if (this.currentContext.getResultProjectContexts().isEmpty()) {
            throw new WizardBackendException("ResultProjectContexts is empty");
        }
        WizardBackend.checkExistingProject(this.currentContext);
    }

    private void doCreate(IRunnableContext container, IProgressMonitor monitor) throws WizardBackendException {
        S32DSBuiltinSpecsDetector.setInCreateProjects((boolean)true);
        this.iad = new ArrayList<IAdaptable>();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        String workingSetName = this.currentContext.isArggregateFolderNeed() ? this.currentContext.getProjectBaseName() : "Other Projects";
        IWorkingSet workingSet = workingSetManager.createWorkingSet(workingSetName, new IAdaptable[0]);
        IWorkingSet[] workingSets = new IWorkingSet[]{workingSet};
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        this.createProjects((IProgressMonitor)subMonitor);
        subMonitor.worked(1);
        this.applyParticipantsToCreatedProjects(container, workingSets);
        subMonitor.worked(1);
        this.addWorkingSetsToCreatedProjects(workingSet, workingSets);
        subMonitor.worked(1);
        try {
            try {
                try {
                    container.run(false, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(this.runSetDescriptions(this.currentContext.getResultProjectContexts())));
                }
                catch (InterruptedException | InvocationTargetException e) {
                    this.clearProject();
                    Thread.currentThread().interrupt();
                    throw e.getCause();
                }
            }
            catch (Throwable e) {
                S32DSWizardPlugin.log(e);
                if (e instanceof Exception) {
                    throw new WizardBackendException((Exception)e);
                }
                throw new WizardBackendException(e.getMessage());
            }
        }
        finally {
            S32DSBuiltinSpecsDetector.setInCreateProjects((boolean)false);
            S32DSBuiltinSpecsDetector.clearDiscoveredProjects();
        }
        subMonitor.worked(1);
        this.attachElfToCreatedProjects();
        subMonitor.worked(1);
        this.attachSdksToCreatedProjects();
        subMonitor.worked(1);
        this.currentContext.reset();
    }

    private void createProjects(IProgressMonitor monitor) throws WizardBackendException {
        for (ProjectContext projectContext : this.currentContext.getResultProjectContexts()) {
            ProjectGenerationContext projectGenerationContext = ProjectGenerationContext.start(this.currentContext, projectContext);
            this.generatedProjects.addFirst(projectGenerationContext);
            IProject newProject = this.createProject(projectGenerationContext, true, monitor);
            if (newProject != null) continue;
            S32DSWizardPlugin.logWarning(Messages.S32DSMultiProjectWizard_cannot_create_prj);
            throw new WizardBackendException(Messages.S32DSMultiProjectWizard_cannot_create_prj);
        }
    }

    private void applyParticipantsToCreatedProjects(IRunnableContext container, IWorkingSet[] workingSets) throws WizardBackendException {
        for (ProjectGenerationContext projectGenerationContext : this.generatedProjects) {
            MultiStatus participantCreatingStatus;
            block6: {
                IProject project = projectGenerationContext.getProject();
                participantCreatingStatus = new MultiStatus("com.freescale.s32ds.cross.wizard", 0, EMPTY_STRING, null);
                try {
                    try {
                        ProjectContext projectContext = projectGenerationContext.getProjectContext();
                        this.applyWizardParticipants(container, workingSets, projectContext, projectGenerationContext);
                        participantCreatingStatus.add((IStatus)this.applyProjectParticipants(container, projectContext, projectGenerationContext));
                        this.setupCDT(project);
                    }
                    catch (CoreException e) {
                        participantCreatingStatus.add(e.getStatus());
                        this.iad.add((IAdaptable)project);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.iad.add((IAdaptable)project);
                    throw throwable;
                }
                this.iad.add((IAdaptable)project);
            }
            if (participantCreatingStatus.isOK()) continue;
            S32DSWizardPlugin.log((IStatus)participantCreatingStatus);
        }
    }

    private void attachSdksToCreatedProjects() {
        this.generatedProjects.stream().map(ProjectGenerationContext::getProjectContext).filter(projectContext -> projectContext instanceof CProjectMasterContext).map(projectContext -> (CProjectMasterContext)projectContext).forEach(this::attachSdksToProject);
    }

    private void attachElfToCreatedProjects() {
        this.generatedProjects.stream().map(ProjectGenerationContext::getProjectContext).filter(projectContext -> projectContext instanceof CProjectMasterContext).map(projectContext -> (CProjectMasterContext)projectContext).forEach(this::attachElfToProject);
    }

    private void addWorkingSetsToCreatedProjects(IWorkingSet workingSet, IWorkingSet[] workingSets) {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        this.getIAd().forEach(a -> workingSetManager.addToWorkingSets(a, workingSets));
        if (workingSetManager.getWorkingSet(workingSet.getName()) == null) {
            workingSetManager.addWorkingSet(workingSet);
        }
    }

    private MultiStatus applyProjectParticipants(IRunnableContext container, ProjectContext pc, ProjectGenerationContext pgc) {
        MultiStatus mtStatus = new MultiStatus("com.freescale.s32ds.cross.wizard", 0, EMPTY_STRING, null);
        List<IProjectParticipant> applicableParticipants = this.filterApplicableProjectParticipant(pc);
        for (IProjectParticipant participant : applicableParticipants) {
            final IWorkspaceRunnable operation = participant.participate(WizardUtils.mapProjectContext(pc), pgc.getProject());
            if (operation == null) continue;
            try {
                container.run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        operation.run(monitor);
                    }
                });
            }
            catch (Exception e) {
                String message = NLS.bind((String)Messages.S32DSMultiProjectWizard_error_exec, (Object)participant.getId(), (Object)pgc.getProjectName());
                Status status = new Status(4, "com.freescale.s32ds.cross.wizard", message, (Throwable)e);
                S32DSWizardPlugin.log((IStatus)status);
                mtStatus.add((IStatus)status);
            }
        }
        return mtStatus;
    }

    private void applyWizardParticipants(IRunnableContext container, IWorkingSet[] workingSets, ProjectContext pc, ProjectGenerationContext pgc) throws WizardBackendException {
        List<IWizardParticipant> applicableParticipants = this.filterApplicableWizardParticipant(pc);
        for (IWizardParticipant participant : applicableParticipants) {
            WorkspaceModifyOperation operation = participant.participate(pc, pgc.getProject(), workingSets);
            if (operation == null) continue;
            try {
                container.run(false, true, (IRunnableWithProgress)operation);
            }
            catch (Exception e) {
                String message = NLS.bind((String)Messages.S32DSMultiProjectWizard_error_exec, (Object)participant.getId(), (Object)pgc.getProjectName());
                S32DSWizardPlugin.log(e, message);
                throw new WizardBackendException(e);
            }
        }
    }

    private void setupCDT(IProject project) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project, true);
        if (des != null && des.isCdtProjectCreating()) {
            des = mngr.getProjectDescription(project, true);
            des.setCdtProjectCreated();
            mngr.setProjectDescription(project, des, false, null);
        }
    }

    private void attachSdksToProject(CProjectMasterContext projectContext) {
        List sdksToAttachIds = projectContext.getSdkList();
        if (!sdksToAttachIds.isEmpty()) {
            IProject project = projectContext.getProject();
            try {
                Map<String, List<ILanguageSettingsProvider>> settings = WizardUtils.removeLanguageSettingsProviders(project);
                SdkAttachProcessor.attachSdksToProject((Collection)sdksToAttachIds, (IProject)project);
                WizardUtils.addLanguageSettingsProviders(settings, project);
            }
            catch (CoreException ce) {
                S32DSWizardPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", NLS.bind((String)"Unable to attach SDK(s) to project {0} due to error.", (Object)project.getName(), (Object)((Object)ce))));
            }
        }
    }

    private void attachElfToProject(CProjectMasterContext projectContext) {
        IProject project;
        String elfToAttachId = projectContext.getElf();
        if (!elfToAttachId.isBlank() && (project = projectContext.getProject()) != null) {
            this.createElfFile(DEBUG_OUTPUT_FOLDER, elfToAttachId, project);
            this.createElfFile(RELEASE_OUTPUT_FOLDER, elfToAttachId, project);
        }
    }

    private void createElfFile(String folderName, String elfToAttachId, IProject project) {
        IFolder targetFolder = project.getFolder((IPath)new Path(folderName));
        IFile elfFile = targetFolder.getFile((IPath)new Path(String.valueOf(project.getName()) + ELF_FILE));
        if (!targetFolder.exists()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream in = new FileInputStream(elfToAttachId);){
                    WizardBackend.createFolders((IContainer)targetFolder);
                    if (!elfFile.exists()) {
                        elfFile.create((InputStream)in, true, null);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                S32DSWizardPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", NLS.bind((String)"Unable to attach Elf to project {0} due to error.", (Object)project.getName(), (Object)e)));
            }
        }
    }

    private static void createFolders(IContainer container) throws CoreException {
        if (container.exists()) {
            return;
        }
        if (container instanceof IFolder) {
            WizardBackend.createFolders(container.getParent());
            ((IFolder)container).create(true, true, null);
        }
    }

    private static void saveProjectPrefs(ProjectContext pcxt, IProject project) {
        DeviceCoreDescriptor deviceCoreDescriptor;
        CProjectContext projectContext = (CProjectContext)pcxt;
        ProjectContextSettings settings = new ProjectContextSettings(project);
        String familyId = EMPTY_STRING;
        String deviceId = EMPTY_STRING;
        String coreId = EMPTY_STRING;
        String deviceCoreId = EMPTY_STRING;
        settings.setLang2Context(projectContext.getStringValue("language"));
        settings.setBootableCore(projectContext.isAutoStart());
        ProcessorData procData = projectContext.getProcessor();
        if (procData != null) {
            settings.setPlatform2Context(procData.getPlatform());
            settings.setDeviceRevision2Context(procData.getDeviceRevision());
        }
        if ((deviceCoreDescriptor = WizardBackend.getDeviceCoreByProjectContext(projectContext)) != null) {
            deviceCoreId = deviceCoreDescriptor.getId();
            deviceId = deviceCoreDescriptor.getDeviceId();
            coreId = deviceCoreDescriptor.getCoreId();
            List lstFmDescriptors = DeviceDescriptors.getFamilyDescriptors((String)deviceId);
            if (!lstFmDescriptors.isEmpty()) {
                familyId = ((FamilyDescriptor)lstFmDescriptors.get(0)).getId();
            }
        } else {
            String msg = NLS.bind((String)Messages.S32DSProjectWizard_deviceCore_not_defined_error, (Object)projectContext.getCoreNatureId());
            S32DSWizardPlugin.log((IStatus)new Status(2, "com.freescale.s32ds.cross.wizard", msg));
            coreId = WizardBackend.getCoreByProjectContext(projectContext);
            familyId = WizardBackend.getFamilyByProjectContext(projectContext);
        }
        settings.setFamily2Context(familyId);
        settings.setDevice2Context(deviceId);
        settings.setCore2Context(coreId);
        settings.setDeviceCore2Context(deviceCoreId);
        if (pcxt instanceof ExecutableContext) {
            settings.setArchType2Context("application");
        } else {
            settings.setArchType2Context("library");
        }
        settings.storeProjectContextMap();
        WizardBackend.sendEventsCollectionData(projectContext, familyId, deviceId, coreId, deviceCoreId);
    }

    private static void sendEventsCollectionData(CProjectContext context, String familyId, String deviceId, String coreId, String deviceCoreId) {
        Optional<DebuggerDescriptor> optDescriptor;
        Object debugger;
        DataCollections.sendEventCollectHardware((String)familyId, (String)deviceId, (String)deviceCoreId);
        IToolChain toolChain = context.getToolChain();
        if (toolChain != null) {
            DataCollections.sendEventCollectToolChain((String)toolChain.getId(), (String)toolChain.getName(), (String)deviceId, (String)coreId);
        }
        if ((debugger = context.getValue("debugger")) instanceof String && (optDescriptor = DebuggerDescriptors.getDebuggerDescriptors().stream().filter(p -> p.getId().equals(debugger)).findAny()).isPresent()) {
            DebuggerDescriptor debuggerDescriptor = optDescriptor.get();
            DataCollections.sendEventCollectDebugger((String)debuggerDescriptor.getId(), (String)debuggerDescriptor.getName(), (String)deviceCoreId);
        }
    }

    private static DeviceCoreDescriptor getDeviceCoreByProjectContext(CProjectContext projectContext) {
        String deviceCoreLockedId = projectContext.getContextValue("opmodeCoreId");
        if (deviceCoreLockedId != null && !deviceCoreLockedId.isEmpty()) {
            return DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreLockedId);
        }
        return DeviceDescriptors.getDeviceCoreDescriptor((String)projectContext.getCoreNatureId());
    }

    private static String getCoreByProjectContext(CProjectContext projectContext) {
        CoreDescriptor descriptor;
        String core = projectContext.getStringValue("hardwareCoreId");
        if (core != null && (descriptor = CoreDescriptors.getCoreDescriptor((String)core)) != null) {
            return descriptor.getId();
        }
        String msg = NLS.bind((String)Messages.S32DSProjectWizard_core_not_defined_error, (Object)core);
        S32DSWizardPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", msg));
        return EMPTY_STRING;
    }

    private static String getFamilyByProjectContext(CProjectContext projectContext) {
        FamilyDescriptor descriptor;
        String family = projectContext.getStringValue("family");
        if (family != null && (descriptor = FamilyDescriptors.getFamilyDescriptor((String)family)) != null) {
            return descriptor.getId();
        }
        String msg = NLS.bind((String)Messages.S32DSProjectWizard_family_not_defined_error, (Object)family);
        S32DSWizardPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", msg));
        return EMPTY_STRING;
    }

    private IProject createProject(ProjectGenerationContext pgc, boolean onFinish, IProgressMonitor monitor) {
        IProgressMonitor fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        pgc.setProject(null);
        fMonitor.beginTask(CUIPlugin.getResourceString((String)"CProjectWizard.op_description"), 100);
        fMonitor.worked(10);
        try {
            IProject newProject = this.createIProject(pgc, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)fMonitor, (int)40));
            if (newProject != null) {
                ProjectContext projectContext = pgc.getProjectContext();
                projectContext.setProject(newProject);
                if (projectContext instanceof CProjectContext) {
                    WizardBackend.saveProjectPrefs(projectContext, newProject);
                    S32DSWizardHandler h = new S32DSWizardHandler(EMPTY_STRING, this, (CProjectContext)projectContext, this.wizard);
                    h.createProject(newProject, true, onFinish, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)fMonitor, (int)40));
                }
            }
            fMonitor.worked(10);
            IProject iProject = newProject;
            return iProject;
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
        }
        finally {
            fMonitor.done();
        }
        return null;
    }

    public static void checkExistingProject(GeneralContext currentContext) throws WizardBackendException {
        try {
            for (ProjectContext pc : currentContext.getResultProjectContexts()) {
                String projectLocation = new ProjectGenerationContext(currentContext, pc).getLocation();
                IFileStore fs = EFS.getStore((URI)Paths.get(projectLocation, new String[0]).toUri());
                IFileInfo f = fs.fetchInfo();
                if (!f.exists() || !f.isDirectory() || !fs.getChild(".project").fetchInfo().exists()) continue;
                throw new WizardBackendException(String.valueOf(Messages.S32DSMultiProjectWizard_prj_already_exists) + ": " + pc.getProjectName());
            }
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
            throw new WizardBackendException((Exception)((Object)e));
        }
    }

    public void clearProject() {
        this.generatedProjects.forEach(pgc -> {
            if (pgc.getProjectName() == null) {
                return;
            }
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pgc.getProjectName());
                project.delete(!pgc.isLastProjectLocationExists(), true, null);
            }
            catch (CoreException e) {
                S32DSWizardPlugin.log(e);
            }
        });
    }

    public List<IAdaptable> getIAd() {
        return this.iad;
    }

    private IProject createIProject(ProjectGenerationContext pgc, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("CREATING PROJECT", 100);
        if (pgc.getProject() != null) {
            return pgc.getProject();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject newProjectHandle = root.getProject(pgc.getProjectName());
        if (!newProjectHandle.exists()) {
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            String location = pgc.getLocation();
            description.setLocation((IPath)new Path(location));
            pgc.setProject(CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)25)));
        } else {
            IWorkspaceRunnable runnable = monitor1 -> newProjectHandle.refreshLocal(2, monitor1);
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)25));
            pgc.setProject(newProjectHandle);
        }
        if (!pgc.getProject().isOpen()) {
            pgc.getProject().open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)25));
        }
        this.setNatures(pgc);
        monitor.done();
        return pgc.getProject();
    }

    private void setNatures(ProjectGenerationContext pgc) {
        if (pgc.getProjectContext() instanceof CProjectContext && ((CProjectContext)pgc.getProjectContext()).getTargetTemplate() == null) {
            try {
                CProjectNature.addCNature((IProject)pgc.getProject(), null);
                CCProjectNature.addCCNature((IProject)pgc.getProject(), null);
            }
            catch (CoreException e) {
                S32DSWizardPlugin.log(e);
            }
        }
    }

    private IRunnableWithProgress runSetDescriptions(List<ProjectContext> resultProjectContexts) {
        return monitor -> {
            List newProjects = GeneralContext.getProjectsFromContexts((List)resultProjectContexts);
            resultProjectContexts.forEach(projectContext -> {
                IProject currentProject = projectContext.getProject();
                if (currentProject == null) {
                    S32DSWizardPlugin.logWarning(String.format(Messages.S32DSMultiProjectWizard_no_project_for_ctx, projectContext.getContextId()));
                    return;
                }
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format(Messages.S32DSMultiProjectWizard_making_refs, currentProject.getName()), (int)40);
                    LinkedList refsList = new LinkedList(newProjects);
                    refsList.remove(currentProject);
                    monitor.worked(10);
                    IProject[] refs = refsList.toArray(new IProject[refsList.size()]);
                    WizardBackend.updateProjectDescription(projectContext, refs, (IProgressMonitor)subMonitor);
                    this.removeReferences((ProjectContext)projectContext, (IProgressMonitor)subMonitor);
                }
                catch (CoreException e) {
                    S32DSWizardPlugin.log(e);
                }
                monitor.done();
            });
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.getfConfigElement());
        };
    }

    private void removeReferences(ProjectContext projectContext, IProgressMonitor monitor) throws CoreException {
        IProject project = projectContext.getProject();
        IProjectDescription description = project.getDescription();
        description.setReferencedProjects(new IProject[0]);
        project.setDescription(description, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10));
    }

    private static void updateProjectDescription(ProjectContext projectContext, IProject[] refs, IProgressMonitor imonitor) throws CoreException {
        Map<Object, Object> refMap;
        if (!(projectContext instanceof CProjectContext)) {
            S32DSWizardPlugin.logWarning(projectContext + " is not " + projectContext);
            return;
        }
        IProject project = projectContext.getProject();
        CProjectContext cProjectContext = (CProjectContext)projectContext;
        boolean autoStart = cProjectContext.isAutoStart();
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription projectDescription = coreModel.getProjectDescription(project);
        Map<Object, Object> map = refMap = autoStart ? WizardBackend.createProjectReferenceMap(refs) : Collections.emptyMap();
        if (projectDescription != null) {
            IContributedEnvironment ice = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
            EmbSysSettingsUtil.setEmbsysDescriptionData(project, autoStart, projectDescription);
            String path = WizardBackend.getVariablesNames(cProjectContext);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
                ice.addVariable(PATH, path, 3, File.pathSeparator, cfg);
                if (!refMap.isEmpty()) {
                    Map<String, String> refMapCfg = WizardBackend.createProjectCfgReferenceMap(cfg, refs);
                    if (!refMapCfg.isEmpty()) {
                        cfg.setReferenceInfo(refMapCfg);
                    } else {
                        cfg.setReferenceInfo(refMap);
                    }
                }
                ++n2;
            }
        }
        coreModel.setProjectDescription(project, projectDescription, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)imonitor, (int)10));
    }

    private static Map<String, String> createProjectReferenceMap(IProject[] refs) {
        HashMap<String, String> refMap = new HashMap<String, String>();
        IProject[] iProjectArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject ref = iProjectArray[n2];
            refMap.put(ref.getName(), EMPTY_STRING);
            ++n2;
        }
        return refMap;
    }

    private static String getVariablesNames(CProjectContext projectContext) {
        StringBuilder variableNames = new StringBuilder();
        IStringVariableManager stringVarManager = VariablesPlugin.getDefault().getStringVariableManager();
        for (String var : projectContext.getTemplate().getValueVariables()) {
            IValueVariable vv = stringVarManager.getValueVariable(var);
            if (vv == null || variableNames.toString().contains(vv.getName())) continue;
            variableNames.append("${");
            variableNames.append(vv.getName());
            variableNames.append("}" + File.pathSeparator);
        }
        return variableNames.toString();
    }

    private static Map<String, String> createProjectCfgReferenceMap(ICConfigurationDescription cfg, IProject[] refs) {
        HashMap<String, String> refMap = new HashMap<String, String>();
        String cfgName = cfg.getName();
        IProject[] iProjectArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgProject;
            IProject ref = iProjectArray[n2];
            String curCfgName = null;
            ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(ref);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
            int n3 = iCConfigurationDescriptionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                cfgProject = iCConfigurationDescriptionArray[n4];
                if (cfgProject.getName().equalsIgnoreCase(cfgName)) {
                    curCfgName = cfgProject.getId();
                    break;
                }
                ++n4;
            }
            if (curCfgName == null) {
                iCConfigurationDescriptionArray = projectDescription.getConfigurations();
                n3 = iCConfigurationDescriptionArray.length;
                n4 = 0;
                while (n4 < n3) {
                    cfgProject = iCConfigurationDescriptionArray[n4];
                    if (cfgName.contains(cfgProject.getName())) {
                        curCfgName = cfgProject.getId();
                        break;
                    }
                    ++n4;
                }
            }
            if (curCfgName != null) {
                refMap.put(ref.getName(), curCfgName);
            }
            ++n2;
        }
        return refMap;
    }

    public IConfigurationElement getfConfigElement() {
        return this.fConfigElement;
    }

    public void setfConfigElement(IConfigurationElement fConfigElement) {
        this.fConfigElement = fConfigElement;
    }

    public String getLocation() {
        return this.currentContext.getBaseProjectPath() == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : this.currentContext.getBaseProjectPath();
    }

    public Map<String, String> getProjectData(ProjectContext projectContext) {
        IWizardValueProvider valueProvider;
        HashMap<String, String> data = new HashMap<String, String>();
        if (projectContext == null) {
            S32DSWizardPlugin.logWarning("Context for project not found !");
            return data;
        }
        String projectName = projectContext.getProjectName();
        String baseName = projectName;
        int dot = baseName.lastIndexOf(46);
        if (dot != -1) {
            baseName = baseName.substring(dot + 1);
        }
        if ((dot = baseName.indexOf(32)) != -1) {
            baseName = baseName.substring(0, dot);
        }
        data.put(PROJECT_NAME, projectName);
        data.put(BASE_NAME, baseName);
        data.put(BASE_NAME_UPPER, baseName.toUpperCase());
        data.put(BASE_NAME_LOWER, baseName.toLowerCase());
        String location = ProjectGenerationContext.getLocation(this.currentContext, projectContext);
        data.put(LOCATION, location);
        data.put(WORKSPACE_LOCATION, Platform.getLocation().toOSString());
        if (projectContext instanceof CProjectContext) {
            CoreNatureData coreNature = ((CProjectContext)projectContext).getCoreNature();
            data.put(CORE_NAME, coreNature.getSuffix());
            ProcessorData processor = ((CProjectContext)projectContext).getProcessor();
            FamilyData family = ((CProjectContext)projectContext).getFamily();
            WizardBackend.putNotNull(OP_COPROC_APU, projectContext.getStringValue("apuCoProcessorEnable"), data);
            WizardBackend.putNotNull(OP_COPROC_APU_GRAPH, projectContext.getStringValue("apuCoProcessorGraphEnable"), data);
            WizardBackend.putNotNull(OP_COPROC_ISP, projectContext.getStringValue("ispCoProcessorEnable"), data);
            WizardBackend.putNotNull(OP_COPROC_ISP_GRAPH, projectContext.getStringValue("ispCoProcessorGraphEnable"), data);
            WizardBackend.putNotNull(OP_COPROC_ISP_STATIC_SEQUENCER, projectContext.getStringValue("ispCoProcessorStaticSequencerEnable"), data);
            WizardBackend.parseParams(family.getStringValue("params"), data);
            WizardBackend.parseParams(processor.getStringValue("params"), data);
            WizardBackend.parseParams(coreNature.getStringValue("params"), data);
        }
        if ((valueProvider = projectContext.getRegistry().getValueProvider()) == null) {
            valueProvider = new DefaultWizardValueProvider();
        }
        data.putAll(valueProvider.createValueMap(projectContext, location));
        return data;
    }

    private static String putNotNull(String key, String value, Map<String, String> data) {
        if (value != null) {
            return data.put(key, value);
        }
        return null;
    }

    private static void parseParams(String parms, Map<String, String> res) {
        if (parms == null) {
            return;
        }
        String[] stringArray = parms.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] ps = s.split("=");
            if (ps.length == 2) {
                String key = ps[0].trim();
                res.put(key, ps[1].trim());
            } else if (s.trim().length() > 0) {
                S32DSWizardPlugin.logWarning("Bad extra parameter: <" + s + "> in " + parms);
            }
            ++n2;
        }
    }

    private List<IWizardParticipant> filterApplicableWizardParticipant(ProjectContext pc) {
        ArrayList<IWizardParticipant> applicableParticipants = new ArrayList<IWizardParticipant>();
        for (IWizardParticipant participant : this.wizardParticipants) {
            boolean applicable = participant.isApplicable(pc);
            if (!applicable) continue;
            applicableParticipants.add(participant);
        }
        return applicableParticipants;
    }

    private List<IProjectParticipant> filterApplicableProjectParticipant(ProjectContext pc) {
        ArrayList<IProjectParticipant> applicableParticipants = new ArrayList<IProjectParticipant>();
        for (IProjectParticipant participant : this.projectParticipants) {
            boolean applicable = participant.isApplicable(WizardUtils.mapProjectContext(pc));
            if (!applicable) continue;
            applicableParticipants.add(participant);
        }
        return applicableParticipants;
    }
}

