/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.ui;

import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoUIMessage;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpdatePasswordDialog
extends TitleAreaDialog {
    private static final int MAX_PASS_SIZE = 255;
    private static final char NULL_TERMINATOR_CHAR = '\u0000';
    private static final char HIDDEN_CHAR_PLACEHOLDER = '\u25cf';
    private Button butOK;
    private Button butShowPassword;
    private Text txtInput1;
    private Text txtInput2;
    private String txtLabelInput1;
    private String txtLabelInput2;
    private String input1 = "";
    private String input2 = "";
    private boolean resisableOnInit = true;
    private boolean forInitialPassword;

    public UpdatePasswordDialog(Shell parentShell) {
        super(parentShell);
        this.txtLabelInput1 = VolkanoUIMessage.Volkano_enter_current_password_message;
        this.txtLabelInput2 = VolkanoUIMessage.Volkano_enter_new_password_message;
        this.forInitialPassword = false;
    }

    public UpdatePasswordDialog(Shell parentShell, String txtLabelInput1, String txtLabelInput2, boolean forInitialPassword) {
        super(parentShell);
        this.txtLabelInput1 = txtLabelInput1;
        this.txtLabelInput2 = txtLabelInput2;
        this.forInitialPassword = forInitialPassword;
    }

    public void create() {
        super.create();
        this.setTitle(VolkanoUIMessage.Volkano_smartcard_update_password_message);
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = new Composite(parent, 2048);
        GridData horizontalFill = new GridData(4, 16, true, false);
        innerComposite.setLayoutData((Object)horizontalFill);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 15;
        innerComposite.setLayout((Layout)gridLayout);
        SWTUtils.createLabel((Composite)innerComposite, (String)this.txtLabelInput1);
        this.txtInput1 = SWTUtils.createWideText((Composite)innerComposite, (int)0x400804, (boolean)true, (int)1);
        this.txtInput1.setEditable(true);
        this.txtInput1.addModifyListener(listener -> this.validateInput());
        SWTUtils.createLabel((Composite)innerComposite, (String)this.txtLabelInput2);
        this.txtInput2 = SWTUtils.createWideText((Composite)innerComposite, (int)0x400804, (boolean)true, (int)1);
        this.txtInput2.setEditable(true);
        this.txtInput2.addModifyListener(listener -> this.validateInput());
        this.butShowPassword = SWTUtils.createButtonWithHorizontalSpan((Composite)innerComposite, (String)VolkanoUIMessage.Volkano_show_password_message, (int)32, (int)2);
        this.butShowPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UpdatePasswordDialog.this.butShowPassword.getSelection()) {
                    UpdatePasswordDialog.this.txtInput1.setEchoChar('\u0000');
                    UpdatePasswordDialog.this.txtInput2.setEchoChar('\u0000');
                } else {
                    UpdatePasswordDialog.this.txtInput1.setEchoChar('\u25cf');
                    UpdatePasswordDialog.this.txtInput2.setEchoChar('\u25cf');
                }
            }
        });
        this.getShell().setText(VolkanoUIMessage.Volkano_smartcard_password_title);
        this.setHelpAvailable(false);
        this.setMessage(null);
        return innerComposite;
    }

    private void validateInput() {
        String input1Text = this.txtInput1.getText();
        String input2Text = this.txtInput2.getText();
        if (this.butOK != null) {
            if (input1Text.isEmpty() || input2Text.isEmpty()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_empty_input_fields);
            } else if (input1Text.length() > 255 || input2Text.length() > 255) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_password_too_long_message);
            } else if (this.forInitialPassword && !input1Text.equals(input2Text)) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_passwords_do_not_match);
            } else {
                this.butOK.setEnabled(true);
                this.setErrorMessage(null);
            }
        }
    }

    protected boolean isResizable() {
        return this.resisableOnInit;
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        Point currentSize = super.getInitialSize();
        super.getShell().pack();
        Point newSize = super.getShell().getSize();
        super.getShell().setSize(currentSize.x, newSize.y);
        this.resisableOnInit = false;
        this.validateInput();
        return butBar;
    }

    protected void okPressed() {
        this.input1 = this.txtInput1.getText();
        this.input2 = this.txtInput2.getText();
        super.okPressed();
    }

    public String getInput1() {
        return this.input1;
    }

    public String getInput2() {
        return this.input2;
    }
}

