/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.externaltools;

import com.nxp.s32ds.ext.ide.externaltools.ProgramLaunchConfiguration;
import com.nxp.s32ds.ext.ide.internal.externaltools.Messages;
import java.io.File;
import java.util.UUID;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.osgi.util.NLS;

public class ProgramLauncher {
    private static final String PLUGIN_ID = "com.nxp.s32ds.ext.ide.externaltools";

    private ProgramLauncher() {
    }

    public static void launch(ProgramLaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ProgramLauncher.launch(configuration, false, monitor);
    }

    public static void launch(ProgramLaunchConfiguration configuration, boolean isSync, IProgressMonitor monitor) throws CoreException {
        ProgramLauncher.validate(configuration);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        IContainer container = configuration.getContainer();
        ILaunchConfigurationWorkingCopy configurationWorkingCopy = type.newInstance(container, String.valueOf(configuration.getName()) + "-" + UUID.randomUUID());
        configurationWorkingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", configuration.getLocation());
        configurationWorkingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", configuration.getWorkingDirectory());
        configurationWorkingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", configuration.getArguments());
        if (container != null) {
            configurationWorkingCopy.setAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, "${resource:" + container.getFullPath() + "}");
        }
        if (isSync) {
            configurationWorkingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        }
        configurationWorkingCopy.launch("run", monitor);
        configurationWorkingCopy.delete();
    }

    public static void validate(ProgramLaunchConfiguration configuration) throws CoreException {
        ProgramLauncher.validateLocation(configuration);
        ProgramLauncher.validateWorkingDirectory(configuration);
    }

    private static void validateLocation(ProgramLaunchConfiguration configuration) throws CoreException {
        if (configuration.getLocation() == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, Messages.ProgramLauncher_the_location_is_not_defined));
        }
        String expandedLocation = ProgramLauncher.getStringVariableManager().performStringSubstitution(configuration.getLocation());
        if (expandedLocation.length() == 0) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, Messages.ProgramLauncher_the_location_is_not_defined));
        }
        if (!new File(expandedLocation).isFile()) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)Messages.ProgramLauncher_the_location_0_does_not_exist, (Object)expandedLocation)));
        }
    }

    private static void validateWorkingDirectory(ProgramLaunchConfiguration configuration) throws CoreException {
        if (configuration.getWorkingDirectory() == null) {
            return;
        }
        String expandedLocation = ProgramLauncher.getStringVariableManager().performStringSubstitution(configuration.getWorkingDirectory());
        if (expandedLocation.length() > 0 && !new File(expandedLocation).isDirectory()) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)Messages.ProgramLauncher_the_working_directory_0_does_not_exist, (Object)expandedLocation)));
        }
    }

    private static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }
}

