/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.view.providers;

import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.rtos.IRtosConfig;
import com.nxp.s32ds.tad.common.rtos.Rtos;
import com.nxp.s32ds.tad.common.view.column.TadColumn;
import com.nxp.s32ds.tad.common.view.items.TadItem;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TadItemColumnLabelProvider
extends ColumnLabelProvider {
    protected TadColumn column;
    protected IRtosConfig dependency;
    protected Rtos rtos;

    public TadItemColumnLabelProvider(TadColumn column) {
        this.column = column;
        this.dependency = column.getDependency();
    }

    public Image getImage(Object element) {
        if (element instanceof TadItem) {
            TadItem item = (TadItem)element;
            if (item.isParent() && this.dependency != null) {
                if (this.dependency.getInfo() != null && !this.rtos.isMacroEnabled(this.dependency)) {
                    return TadModel.INFORMATION_IMG_DESC.createImage();
                }
                if (item.getText(this.column.getId()) == null) {
                    return TadModel.WARNING_IMG;
                }
            }
            return item.getImage(this.column.getId());
        }
        return null;
    }

    public String getToolTipText(Object element) {
        TadItem item;
        if (element instanceof TadItem && (item = (TadItem)element).isParent() && this.dependency != null) {
            if (this.dependency.getInfo() != null) {
                return this.dependency.getInfo();
            }
            if (item.getText(this.column.getId()) == null) {
                return String.format(this.dependency.toString(), new Object[0]);
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TadItem) {
            return ((TadItem)element).getText(this.column.getId());
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof TadItem) {
            TadItem item = (TadItem)element;
            if (item.getTextColour() != null) {
                return item.getTextColour();
            }
            if (!item.isValid()) {
                return Display.getCurrent().getSystemColor(3);
            }
        }
        return null;
    }
}

