/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.view.providers;

import com.nxp.s32ds.tad.common.model.Auxiliary;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.rtos.IRtosConfig;
import com.nxp.s32ds.tad.common.view.column.ITadColumnId;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public abstract class TadBarGraphProvider
extends StyledCellLabelProvider {
    protected IRtosConfig dependency;
    protected ITadColumnId columnId;
    protected String columnName;
    protected boolean showWarning = false;

    protected void paintBarGraph(Event event, double percentage, String text, boolean showWarning) {
        this.showWarning = showWarning;
        GC gc = event.gc;
        Color oldColor = gc.getBackground();
        Display DISPLAY = Display.getDefault();
        Color whiteColor = DISPLAY.getSystemColor(1);
        int startX = 0;
        if (showWarning) {
            gc.drawImage(TadModel.WARNING_IMG, event.x, event.y);
            startX = TadModel.WARNING_IMG.getBounds().width;
        }
        if (text != null && percentage >= 0.0 && percentage <= 100.0) {
            int fullHeight = event.height - 1;
            int fullWidth = ((TreeViewerColumn)this.getColumn()).getColumn().getWidth() - 1;
            int width = (int)((double)fullWidth * (percentage / 100.0));
            float hue = percentage > 90.0 ? 0 : (percentage > 75.0 ? 30 : (percentage > 50.0 ? 55 : (percentage > 30.0 ? 90 : 125)));
            gc.setBackground(new Color((Device)Display.getCurrent(), new RGBA(hue, 1.0f, 1.0f, 120.0f)));
            gc.fillRectangle(startX + event.x, event.y, width, fullHeight);
            gc.setBackground(whiteColor);
            gc.fillRectangle(width + event.x, event.y, fullWidth - width, fullHeight);
            gc.setForeground(Auxiliary.getContrastColor(gc.getBackground()));
            gc.setFont(Display.getDefault().getSystemFont());
            gc.drawString(text, event.x + fullWidth / 2 - gc.textExtent((String)text).x / 2, event.y, true);
            gc.setBackground(oldColor);
        }
    }

    public abstract String getToolTipText(Object var1);

    public void setDependency(IRtosConfig dependency) {
        this.dependency = dependency;
    }

    public void setColumnId(ITadColumnId columnId) {
        this.columnId = columnId;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }
}

