/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.view.action;

import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.messages.Separator;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.view.items.TadItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SaveToClipboard
extends Action {
    private TadModel tadModel;
    private Shell parentShell;
    private TreeViewer viewer;

    public SaveToClipboard(TadModel tadModel, Shell parentShell, TreeViewer viewer) {
        this.tadModel = tadModel;
        this.parentShell = parentShell;
        this.viewer = viewer;
    }

    public void run() {
        String tadItemStr;
        Clipboard clipboard = new Clipboard(this.parentShell.getDisplay());
        TreeItem[] selected = this.viewer.getTree().getSelection();
        if (clipboard != null && selected.length > 0 && selected[0].getData() instanceof TadItem && (tadItemStr = ((TadItem)selected[0].getData()).toString(Separator.TAB)) != null && !tadItemStr.isEmpty()) {
            try {
                clipboard.setContents(new Object[]{tadItemStr}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (IllegalArgumentException e) {
                this.tadModel.getLogger().exception(e);
            }
        }
        clipboard.dispose();
    }

    public String getText() {
        return Messages.Label_CopyLine;
    }

    public String getToolTipText() {
        return Messages.Label_CopyLine;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
    }
}

