/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.model.readers;

import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.model.TadModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIDataReadMemoryBytes;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryBytesInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;

public class MemoryReader {
    private TadModel tadModel;
    private IRunControl.IExecutionDMContext context;
    private static final int DEFAULT_READ_TIMEOUT_MS = 5000;
    private int readTimeout = 5000;

    public MemoryReader(TadModel tadModel) {
        this.tadModel = tadModel;
    }

    private static long getAlignedAddress(long address) {
        return address & 0xFFFFFFFFFFFFFFFCL;
    }

    private static long getAlignedSize(long size) {
        long alignedSize = size;
        if ((size & 3L) > 0L) {
            alignedSize = (size & 0xFFFFFFFFFFFFFFFCL) + 4L;
        }
        return alignedSize;
    }

    public synchronized List<Integer> getMemoryBlock(long address, long length) throws DebugException {
        long lengthAligned;
        long addressAligned = MemoryReader.getAlignedAddress(address);
        MemoryByte[] bytes = this.readBytes(addressAligned, lengthAligned = MemoryReader.getAlignedSize(length + Math.abs(address - addressAligned)));
        if (bytes != null && bytes.length > 0) {
            long startIndex;
            LinkedList<Integer> memory = new LinkedList<Integer>();
            long startAddr = Math.max(address, addressAligned);
            long i = startIndex = Math.abs(startAddr - Math.min(address, addressAligned));
            while (i < startIndex + length) {
                memory.add(this.convertToUnsigned(bytes[(int)i].getValue()));
                ++i;
            }
            return memory;
        }
        this.tadModel.getLogger().error(String.format(Messages.Error_CouldNotGetMemoryBlock, address, length));
        return null;
    }

    public synchronized List<Long> getMemoryBlock(long address, long length, int bytes) throws DebugException {
        List<Integer> block = this.getMemoryBlock(address, length);
        if (block != null) {
            LinkedList<Long> list = new LinkedList<Long>();
            if (bytes > 0) {
                int numBlocks = (block.size() + bytes - 1) / bytes;
                int i = 0;
                while (i < numBlocks) {
                    int addr = i * bytes;
                    long item = 0L;
                    int j = 0;
                    while (j < bytes && (long)(addr + j) < length) {
                        item |= (long)block.get(addr + j).intValue() << j * 8;
                        ++j;
                    }
                    list.add(item);
                    ++i;
                }
            }
            return list;
        }
        return null;
    }

    public synchronized List<Integer> readMemoryUntilZero(long address) throws DebugException {
        LinkedList<Integer> memory = new LinkedList<Integer>();
        boolean go = true;
        int counter = 0;
        while (go) {
            MemoryByte[] bytes = this.readBytes(address + (long)(counter * 32), 32L);
            if (bytes == null) break;
            MemoryByte[] memoryByteArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte b = memoryByteArray[n2];
                int value = this.convertToUnsigned(b.getValue());
                if (value == 0) {
                    go = false;
                    break;
                }
                memory.add(value);
                ++n2;
            }
            ++counter;
        }
        return memory;
    }

    private MemoryByte[] readBytes(long address, long length) {
        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), this.getContext().getSessionId());
        try {
            IStack stack = (IStack)tracker.getService(IStack.class);
            MIDataReadMemoryBytes mi = new MIDataReadMemoryBytes((IDMContext)this.getContext(), "0x" + Long.toString(address, 16), 0L, (int)length);
            final CountDownLatch gate = new CountDownLatch(1);
            final List list = Collections.synchronizedList(new ArrayList());
            DataRequestMonitor<MIDataReadMemoryBytesInfo> rm = new DataRequestMonitor<MIDataReadMemoryBytesInfo>((Executor)stack.getExecutor(), null){

                public void handleSuccess() {
                    list.add(((MIDataReadMemoryBytesInfo)this.getData()).getMIMemoryBlock());
                    gate.countDown();
                }

                protected void handleError() {
                    super.handleError();
                }
            };
            ICommandControl cc = (ICommandControl)tracker.getService(ICommandControl.class);
            cc.queueCommand((ICommand)mi, (DataRequestMonitor)rm);
            try {
                gate.await(this.readTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
            if (list.isEmpty()) {
                this.tadModel.getLogger().error(Messages.Error_ReadBytesTimout);
                return null;
            }
            MemoryByte[] memoryByteArray = (MemoryByte[])list.get(0);
            return memoryByteArray;
        }
        finally {
            tracker.dispose();
        }
    }

    private int convertToUnsigned(int i) {
        return i < 0 ? i & 0xFF : i;
    }

    public IRunControl.IExecutionDMContext getContext() {
        return this.context;
    }

    public void setContext(IRunControl.IExecutionDMContext context) {
        this.context = context;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

