/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common;

import com.nxp.s32ds.tad.common.TadCommonActivator;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractCommonActivator
extends AbstractUIPlugin {
    private static final String EMPTY_STRING = "";
    public static final String DELIMITER = ";";
    private static final String DATA_PATH = "Data";
    public static final String P_BIN_DIRS = "directories.bin";
    protected static final String IMAGE_PREFIX = "icons/";
    protected static final String IMAGE_SUFFIX = "gif";
    protected String pluginID = null;
    protected boolean dataPathsInitialized = false;
    protected String localPluginDataPath = null;
    protected String externalPluginDataPath = null;
    protected Bundle bundle = null;

    public static boolean showMessageBox(String title, String message, int type) {
        return false;
    }

    protected ImageDescriptor declareImage(String img) {
        Path imgPath = new Path(IMAGE_PREFIX, img);
        String ext = imgPath.getFileExtension();
        if (ext == null || ext.length() == 0) {
            imgPath = imgPath.addFileExtension(IMAGE_SUFFIX);
        }
        String key = this.getKey(img);
        Optional optional = ResourceLocator.imageDescriptorFromBundle((String)this.pluginID, (String)imgPath.toString());
        try {
            if (this.getImageRegistry().getDescriptor(key) == null) {
                this.getImageRegistry().put(key, (ImageDescriptor)optional.get());
            }
        }
        catch (Exception exception) {}
        return (ImageDescriptor)optional.get();
    }

    public void registerImage(ImageRegistry registry, String key, String pluginID, String filePath) {
        try {
            Path imgPath = new Path(IMAGE_PREFIX, filePath);
            Optional desc = ResourceLocator.imageDescriptorFromBundle((String)pluginID, (String)imgPath.toString());
            registry.put(key, (ImageDescriptor)desc.get());
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    private String replaceSystemVariables(String buffer) {
        String newBuffer;
        if (buffer == null) {
            return buffer;
        }
        try {
            newBuffer = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(buffer, false);
        }
        catch (Exception exception) {
            newBuffer = buffer;
        }
        return newBuffer;
    }

    public String[] getDirectoriesFromPref(String prefName) {
        IPreferenceStore prefStore = TadCommonActivator.getDefault().getPreferenceStore();
        String dirs = prefStore.getString(prefName);
        return dirs.split(DELIMITER);
    }

    public File findInDirs(String file, boolean trySytemPath) {
        return this.findInDirs(this.getDirectoriesFromPref(P_BIN_DIRS), file, trySytemPath);
    }

    public File findInDirs(String[] dirs, String file, boolean trySystemPath) {
        File findFile = null;
        String[] stringArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            Path dirPath = new Path(dir);
            IPath exePath = dirPath.append(file);
            File find = exePath.toFile();
            if (find.exists()) {
                findFile = find;
                break;
            }
            ++n2;
        }
        if (findFile == null && trySystemPath) {
            String fileName = "${system_path:" + file + "}";
            String fullFile = this.replaceSystemVariables(fileName);
            findFile = new File(fullFile);
        }
        return findFile;
    }

    private String findDataDirectory(IPath base) {
        File homeDir;
        String dataDir = null;
        if (base != null && (homeDir = base.toFile()).isDirectory()) {
            dataDir = homeDir.getAbsolutePath().concat(File.separator);
        }
        return dataDir;
    }

    private String getKey(String img) {
        return img.toLowerCase();
    }

    public Image getImage(String img) {
        String key = this.getKey(img);
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            String msg = String.format("Internal error: cannot find image %s", img);
            this.log(1, msg, null);
        }
        if (image == null || image.isDisposed()) {
            ImageDescriptor id = this.getImageRegistry().getDescriptor(key);
            if (id == null) {
                this.log(4, String.format("Image not found:%s", key), null);
            } else {
                image = id.createImage();
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String img) {
        String key = this.getKey(img);
        ImageDescriptor image = this.getImageRegistry().getDescriptor(key);
        if (image == null) {
            String msg = String.format("Internal error: cannot find image %s", img);
            this.trace(msg);
        }
        return image;
    }

    public File getPluginDataFile(String fileName) {
        File[] files = this.getPluginDataFiles(fileName);
        File lastFile = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            lastFile = file = fileArray[n2];
            if (file.exists()) {
                return file;
            }
            ++n2;
        }
        return lastFile;
    }

    public File[] getPluginDataFiles(String fileName) {
        ArrayList<File> files = new ArrayList<File>();
        if (!this.dataPathsInitialized) {
            try {
                this.setPluginDataPaths(this.getBundle());
            }
            catch (Exception e) {
                this.reportException(e);
            }
        }
        File dataFile = null;
        String extFilename = String.valueOf(this.externalPluginDataPath) + File.separator + fileName;
        dataFile = new File(extFilename);
        files.add(dataFile);
        String localFilename = String.valueOf(this.localPluginDataPath) + File.separator + fileName;
        dataFile = new File(localFilename);
        files.add(dataFile);
        return files.toArray(new File[files.size()]);
    }

    public File getPluginDataFile(String fileName, String envVar) {
        String filePath;
        File envDir;
        String envDirName;
        if (!this.dataPathsInitialized) {
            try {
                this.setPluginDataPaths(this.getBundle());
            }
            catch (Exception e) {
                this.reportException(e);
            }
        }
        File dataFile = null;
        if (envVar != null && (envDirName = System.getenv(envVar)) != null && !envDirName.equals(EMPTY_STRING) && (envDir = new File(envDirName)).isDirectory() && (dataFile = new File(filePath = String.valueOf(envDir.getAbsolutePath()) + File.separator + fileName)).exists()) {
            return dataFile;
        }
        dataFile = this.findInDirs(fileName, true);
        if (dataFile != null && dataFile.exists()) {
            return dataFile;
        }
        return this.getPluginDataFile(fileName);
    }

    public String[] getPluginDataFileNames() {
        if (!this.dataPathsInitialized) {
            try {
                this.setPluginDataPaths(this.getBundle());
            }
            catch (Exception e) {
                this.reportException(e);
            }
        }
        return new String[]{this.externalPluginDataPath, this.localPluginDataPath};
    }

    public String getPluginID() {
        return this.pluginID;
    }

    private ResourceBundle getResourceBundle() {
        return Platform.getResourceBundle((Bundle)this.getBundle());
    }

    public String getResourceString(String key) {
        ResourceBundle bundle = this.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public boolean isTracing() {
        return false;
    }

    public void log(int severity, String msg, Exception e) {
        this.getLog().log((IStatus)new Status(severity, this.getPluginID(), 0, msg, (Throwable)e));
    }

    public void log(Exception e) {
        this.log(4, "Exception logged", e);
    }

    public abstract void post_start(BundleContext var1) throws Exception;

    public void reportError(String message) {
        this.log(4, message, null);
    }

    public void reportException(Exception e) {
        this.log(4, e.getLocalizedMessage(), e);
    }

    public void reportException(Exception e, String additional) {
        this.reportException(e);
    }

    public boolean reportExceptionQuery(Exception e, String query) {
        this.reportException(e);
        return true;
    }

    private void setPluginDataPaths(Bundle bundle) throws Exception {
        try {
            if (this.localPluginDataPath == null) {
                Path path = new Path(DATA_PATH);
                URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                if (url == null) {
                    URL thisurl = TadCommonActivator.getDefault().getBundle().getEntry(".");
                    if (thisurl == null) {
                        this.log(4, "internal: Unable to getEntry('.')", null);
                    } else {
                        url = FileLocator.resolve((URL)thisurl);
                    }
                }
                if (url == null) {
                    this.log(4, String.format("Unable to find home for %1$s (%2$s)", this.pluginID, DATA_PATH), null);
                } else {
                    url = FileLocator.toFileURL((URL)url);
                    this.localPluginDataPath = url.getFile();
                }
            }
        }
        catch (Exception e) {
            this.log(4, e.getLocalizedMessage(), e);
        }
        this.dataPathsInitialized = true;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.pluginID = this.getBundle().getSymbolicName();
        this.trace(String.valueOf(this.pluginID) + ":start");
        this.post_start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public void trace(Throwable e) {
    }

    public void trace(Object[] objects) {
    }

    public void trace(String string) {
    }
}

