/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.core;

import com.nxp.s32ds.cle.runtime.debugger.registry.Configuration;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import com.nxp.s32ds.ext.cdt.dsf.session.DsfSessionDsfServiceTrackerManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerLaunchUtils {
    public static void addDefaultParametersToLaunch(ILaunchConfigurationWorkingCopy lcWorkingCopy, String deviceCoreId, String deviceRevision, String gdbClientValue) {
        S32DebuggerParams params = new S32DebuggerParams();
        params.setDeviceCoreId(deviceCoreId);
        DeviceCoreDescriptor descriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        String deviceId = descriptor.getDeviceId();
        List configs = DebuggerDescriptors.getDeviceDebuggerConfiguration((String)"s32debugger", (String)deviceId);
        configs.addAll(DebuggerDescriptors.getDeviceCoreDebuggerConfiguration((String)"s32debugger", (String)deviceCoreId));
        String initializationScriptPath = !configs.isEmpty() ? ((Configuration)configs.get(configs.size() - 1)).getScript() : DeviceCoreDebuggerDescriptors.getInitScript((String)deviceCoreId, (String)"s32debugger");
        params.setInitializationScript(initializationScriptPath);
        params.setClientCommands(S32DebuggerCoreActivator.getDeviceClientCommands().get(deviceCoreId));
        params.setClientExecutable(gdbClientValue);
        if (deviceRevision != null) {
            params.setDeviceRevision(deviceRevision);
        }
        params.applyParams(lcWorkingCopy);
    }

    public static void queueCommand(S32DSGdbLaunch s32dsLaunch, String command) {
        S32DebuggerLaunchUtils.queueCommand(s32dsLaunch, command, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void queueCommand(S32DSGdbLaunch s32dsLaunch, String command, final IProgressMonitor monitor) {
        DsfSession session = s32dsLaunch.getSession();
        final CompletableFuture future = new CompletableFuture();
        try {
            IGDBControl gdbControl = (IGDBControl)DsfSessionDsfServiceTrackerManager.getInstance().computeIfAbsent(session).getService(IGDBControl.class);
            CLICommand cliCommand = new CLICommand((IDMContext)gdbControl.getContext(), command);
            gdbControl.queueCommand((ICommand)cliCommand, (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(){

                protected void handleSuccess() {
                    future.complete(new DsfResponse(null));
                    monitor.done();
                }

                protected void handleCancel() {
                    future.cancel(false);
                }

                protected void handleErrorOrWarning() {
                    future.completeExceptionally(this.getStatus().getException());
                }
            });
        }
        catch (DsfSessionInactiveException e) {
            S32DebuggerCoreActivator.getDefault().logError("Session inactive error", e);
        }
    }

    public static boolean hardwareMatchesLaunch(String device, String core, GdbLaunch launch) {
        String deviceCoreId;
        block3: {
            try {
                deviceCoreId = launch.getLaunchConfiguration().getAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.deviceCoreId", "");
                if (deviceCoreId != null) break block3;
                return false;
            }
            catch (CoreException e) {
                S32DebuggerCoreActivator.getDefault().logError("Attribute reading error", e);
                return false;
            }
        }
        DeviceCoreDescriptor descriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        return descriptor.getDeviceId().equals(device) && descriptor.getCoreId().equals(core);
    }
}

