/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach.ConflictingSdkProjectFilesTreeViewer;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ConflictingSdkProjectFilesDialog
extends Dialog {
    private static final String HELP_CONTEXT_ID = "com.freescale.s32ds.cross.sdk.support.SDK_conflicted_files_context";
    private static final String PATH_MATCHER_TEMPLATE = "glob:{%s}";
    private SdkDescriptor sdkDescriptor;
    private IProject project;
    private Map<String, Set<ResourceSdkDescriptor>> conflictingResources;
    private Map<String, Set<ResourceSdkDescriptor>> filesToOverride;
    private Map<ResourceSdkDescriptor, IResource> sdkResourcesToProjectResources;
    private boolean isBackupFiles;
    private ConflictingSdkProjectFilesTreeViewer tree;

    public ConflictingSdkProjectFilesDialog(Shell parentShell, SdkDescriptor sdkDescriptor, IProject project, Map<String, Set<ResourceSdkDescriptor>> conflictingResources) {
        super(parentShell);
        this.sdkDescriptor = Objects.requireNonNull(sdkDescriptor, "SDK must not be null");
        this.project = Objects.requireNonNull(project, "Project must not be null");
        this.conflictingResources = Objects.requireNonNull(conflictingResources);
        this.sdkResourcesToProjectResources = new HashMap<ResourceSdkDescriptor, IResource>();
        for (Map.Entry<String, Set<ResourceSdkDescriptor>> e : conflictingResources.entrySet()) {
            for (ResourceSdkDescriptor sdkResource : e.getValue()) {
                IResource projectResource = null;
                SdkDescriptor resourceSdk = SdkDescriptors.getSdkDescriptor((String)e.getKey());
                String sdkId = sdkDescriptor.getId();
                projectResource = SdkModulesHelper.isSdkContainsRefModuleSdk((String)sdkId, (String)resourceSdk.getId()) ? SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)sdkResource, (SdkDescriptor)resourceSdk, (IProject)project, (SdkDescriptor)sdkDescriptor) : SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)sdkResource, (SdkDescriptor)sdkDescriptor, (IProject)project, null);
                if (projectResource == null) continue;
                this.sdkResourcesToProjectResources.put(sdkResource, projectResource);
            }
        }
        this.filesToOverride = new HashMap<String, Set<ResourceSdkDescriptor>>();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ConflictingSdkProjectFilesDialog_text);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite viewerComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(700, 500).create())).create((Widget)parentComposite);
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(String.format(PATH_MATCHER_TEMPLATE, String.join((CharSequence)",", this.sdkResourcesToProjectResources.values().stream().map(resource -> resource.getLocation().toString()).collect(Collectors.toList()))));
        this.tree = new ConflictingSdkProjectFilesTreeViewer(this.sdkResourcesToProjectResources, this.sdkDescriptor, this.project, viewerComposite, pathMatcher);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)viewerComposite, HELP_CONTEXT_ID);
        return viewerComposite;
    }

    public Map<String, Set<ResourceSdkDescriptor>> getResourcesToOverride() {
        return this.filesToOverride;
    }

    public boolean isBackupFiles() {
        return this.isBackupFiles;
    }

    protected void okPressed() {
        for (ResourceSdkDescriptor checkedResource : this.tree.getResourcesForOverride()) {
            this.conflictingResources.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(checkedResource)).map(Map.Entry::getKey).forEach(sdkId -> {
                boolean bl = this.filesToOverride.computeIfAbsent((String)sdkId, s -> new LinkedHashSet()).add(checkedResource);
            });
        }
        this.isBackupFiles = this.tree.isBackupFiles();
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
        MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)NLS.bind((String)Messages.ConflictingSdkProjectFilesDialog_on_cancel_warning_text, (Object)SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)this.sdkDescriptor, (boolean)false), (Object)this.project.getName()));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.PROCEED_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

