/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.Variable;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHolder;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VariablesHelper {
    private VariablesHelper() {
    }

    public static VariablesHolder getMergedVariables(VariablesHolder localVariables, VariablesHolder globalVariables) {
        VariablesHolder mergedVariables = new VariablesHolder();
        if (globalVariables != null) {
            globalVariables.getVariables().entrySet().stream().map(Map.Entry::getValue).filter(variable -> !localVariables.containsVariable((Variable)variable)).forEach(mergedVariables::addVariable);
        }
        if (localVariables != null) {
            localVariables.getVariables().entrySet().stream().map(Map.Entry::getValue).filter(Objects::nonNull).forEach(mergedVariables::addVariable);
        }
        return mergedVariables;
    }

    public static void performSdkVariablesSubstitution(Element element, VariablesHolder variables) {
        if (variables == null) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            String nodeName = node.getNodeName();
            String nodeValue = node.getNodeValue();
            Pattern variableReferencePattern = Pattern.compile("\\$\\[(.*?)\\]");
            Matcher matcher = variableReferencePattern.matcher(nodeValue);
            while (matcher.find()) {
                int groupsCount = matcher.groupCount();
                if (groupsCount <= 0) continue;
                String quotedFullMatch = Pattern.quote(matcher.group(0));
                int j = 1;
                while (j <= groupsCount) {
                    nodeValue = nodeValue.replaceAll(quotedFullMatch, Matcher.quoteReplacement(variables.getVariableValue(matcher.group(j))));
                    ++j;
                }
            }
            element.setAttribute(nodeName, nodeValue);
            ++i;
        }
    }
}

