/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.SourceEntriesUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.SourceEntriesUpdater;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourcesHandler;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;

public class SdkAttachSourcePathsProcessor {
    private SdkAttachSourcePathsProcessor() {
    }

    public static void updateProjectSourceEntries(IProject project, SdkDescriptor sdkDescriptor, IConfiguration configuration, MultiStatus result) {
        String targetFolderName;
        String configurationName = configuration.getName();
        List<ICSourceEntry> initialSourceEntries = SdkAttachSourcePathsProcessor.getSourceEntries(project, configurationName);
        String sdkFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project);
        IPath sdkFolderPath = Path.fromOSString((String)sdkFolderName);
        targetFolderName = sdkFolderPath.segmentCount() > 0 ? (targetFolderName = sdkFolderPath.uptoSegment(1).toString()) : sdkFolderName;
        SdkAttachSourcePathsProcessor.removeSdkTargetFolderSourceEntry(project, configurationName, sdkFolderPath);
        ProjectSettingsUpdater sourceEntriesUpdater = ProjectSettingsUpdaters.getSourceEntriesUpdater();
        Set<String> excludedPaths = SdkAttachSourcePathsProcessor.getFolderEnclosedExcludedPaths(initialSourceEntries, targetFolderName, sdkFolderName, project);
        sourceEntriesUpdater.update(configuration, null, SdkAttachSourcePathsProcessor.getSourcePaths(project, targetFolderName, sdkDescriptor, configuration), UpdateOperation.ADD);
        if (excludedPaths != null && !excludedPaths.isEmpty()) {
            sourceEntriesUpdater.update(configuration, null, excludedPaths, UpdateOperation.REPLACE_EXISTING);
        }
        SdkAttachSourcePathsProcessor.updateSourceEntriesStatus(project, configurationName, initialSourceEntries, result);
    }

    public static void removeSdkSourceEntries(IProject project, SdkDescriptor sdkDescriptor, String oldNamingTargetFolderPath) {
        String targetFolderPath = oldNamingTargetFolderPath.isEmpty() ? SdkAttachSourcePathsProcessor.getSdkTargetPath(project, sdkDescriptor) : oldNamingTargetFolderPath;
        for (IConfiguration configuration : ProjectConfigurationUtils.getProjectConfigurations((IProject)project)) {
            SdkAttachSourcePathsProcessor.removeSdkSourceEntries(sdkDescriptor, configuration);
            if (targetFolderPath == null) continue;
            ProjectSettingsUpdaters.getSourceEntriesUpdater().update(configuration, null, targetFolderPath, UpdateOperation.REMOVE);
        }
    }

    public static IStatus removeMissingSdkSourceEntries(IProject project, IConfiguration configuration, String sdkId) {
        String sourceEntryPath = SdkAttachDataHelper.getSourceEntryPath(project, sdkId, configuration);
        if (sourceEntryPath == null) {
            sourceEntryPath = SdkAttachSourcePathsProcessor.getOldSdkLocation(project);
        }
        return ProjectSettingsUpdaters.getSourceEntriesUpdater().update(configuration, null, sourceEntryPath, UpdateOperation.REMOVE);
    }

    public static void removeSdkSourceEntries(SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        String sdkId = sdkDescriptor.getId();
        SourceEntriesUpdateStatus sourceEntriesUpdateStatus = SdkAttachSourcePathsProcessor.getSourceEntriesUpdateStatus(sdkId, configuration);
        if (sourceEntriesUpdateStatus == null) {
            return;
        }
        ICSourceEntry[] sourceEntriesToRemove = sourceEntriesUpdateStatus.getSourceEntries();
        if (sourceEntriesToRemove == null) {
            return;
        }
        HashSet<String> sourcePathsToRemove = new HashSet<String>();
        IProject project = configuration.getOwner().getProject();
        String targetFolder = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project);
        ICSourceEntry[] iCSourceEntryArray = sourceEntriesToRemove;
        int n = sourceEntriesToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            IPath containerPath;
            ICSourceEntry sourceEntry = iCSourceEntryArray[n2];
            String sourceEntryPath = sourceEntry.getValue();
            if (sourceEntryPath.equals((containerPath = project.getFolder(Path.fromOSString((String)targetFolder).uptoSegment(1)).getFullPath()).toString())) {
                sourceEntryPath = SdkAttachSourcePathsProcessor.getSdkTargetPath(project, sdkDescriptor);
            }
            if (sourceEntryPath != null) {
                sourcePathsToRemove.add(sourceEntryPath);
            }
            ++n2;
        }
        ProjectSettingsUpdaters.getSourceEntriesUpdater().update(configuration, null, sourcePathsToRemove, UpdateOperation.REMOVE);
    }

    private static Set<String> getSourceFolders(IProject project, SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        HashSet<String> result = new HashSet<String>();
        String sdkId = sdkDescriptor.getId();
        ToolChainSdkDescriptor rootToolChainDescriptor = ToolChainSdkDescriptors.getRootToolChainSdkDescriptor((String)sdkId);
        String rootToolChainId = rootToolChainDescriptor != null ? rootToolChainDescriptor.getToolChainId() : null;
        ArrayList sourceDescriptors = new ArrayList();
        sourceDescriptors.addAll(ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdkId, (String)rootToolChainId));
        IToolChain toolChain = configuration.getToolChain();
        if (toolChain != null) {
            sourceDescriptors.addAll(ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdkId, (String)toolChain.getBaseId()));
        }
        sourceDescriptors.stream().filter(resource -> ResourcesHandler.isResourceAccepted(resource, ResourceSdkGroup.SOURCE_RESOURCES, configuration)).map(resource -> SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)sdkDescriptor, (IProject)project)).forEach(resource -> SdkAttachSourcePathsProcessor.addSourceFolderPath(resource, project, result));
        return result;
    }

    private static void addSourceFolderPath(IResource resource, IProject project, Set<String> result) {
        if (resource == null || 1 == resource.getType() && resource.getParent().equals((Object)project)) {
            return;
        }
        IPath fullPath = resource.getParent().getFullPath();
        if (fullPath.segmentCount() > 1) {
            result.add(fullPath.uptoSegment(2).toString());
        }
    }

    private static SourceEntriesUpdateStatus getSourceEntriesUpdateStatus(String configurationName, MultiStatus updateStatuses) {
        Optional<SourceEntriesUpdateStatus> optional = Arrays.stream(updateStatuses.getChildren()).filter(updateStatus -> updateStatus instanceof SourceEntriesUpdateStatus).map(updateStatus -> (SourceEntriesUpdateStatus)updateStatus).filter(updateStatus -> configurationName.equals(updateStatus.getConfigurationName())).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        SourceEntriesUpdateStatus updateStatus2 = new SourceEntriesUpdateStatus(configurationName);
        updateStatuses.add((IStatus)updateStatus2);
        return updateStatus2;
    }

    private static SourceEntriesUpdateStatus getSourceEntriesUpdateStatus(String sdkId, IConfiguration configuration) {
        return SdkAttachDataHelper.getAttachUpdateStatuses(sdkId, configuration).stream().filter(updateStatus -> updateStatus instanceof SourceEntriesUpdateStatus).map(updateStatus -> (SourceEntriesUpdateStatus)updateStatus).findFirst().orElse(null);
    }

    private static String getSdkTargetPath(IProject project, SdkDescriptor sdkDescriptor) {
        String targetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project);
        String containerFolder = Path.fromOSString((String)targetFolderName).uptoSegment(1).toString();
        String targetPath = project.getFolder(containerFolder).getFullPath().toString();
        try {
            if (Arrays.stream(project.getFolder(containerFolder).members()).map(resource -> resource.getProjectRelativePath().toOSString()).anyMatch(path -> !targetFolderName.equals(path))) {
                targetPath = project.getFolder(targetFolderName).getFullPath().toString();
            }
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().log(ce.getStatus());
            return null;
        }
        return targetPath;
    }

    private static void updateSourceEntriesStatus(IProject project, String configurationName, List<ICSourceEntry> initialSourceEntries, MultiStatus result) {
        List<ICSourceEntry> updatedSourceEntries = SdkAttachSourcePathsProcessor.getSourceEntries(project, configurationName);
        SourceEntriesUpdateStatus sourceEntriesUpdateStatus = SdkAttachSourcePathsProcessor.getSourceEntriesUpdateStatus(configurationName, result);
        sourceEntriesUpdateStatus.setSourceEntries(updatedSourceEntries.stream().filter(sourceEntry -> !initialSourceEntries.contains(sourceEntry)).collect(Collectors.toList()).toArray(new ICSourceEntry[0]));
    }

    private static void removeSdkTargetFolderSourceEntry(IProject project, String configurationName, IPath targetFolderPath) {
        try {
            ICProjectDescription pd = CoreModel.getDefault().getProjectDescription(project);
            ICConfigurationDescription cd = pd.getConfigurationByName(configurationName);
            ArrayList<ICSourceEntry> sourceEntries = new ArrayList<ICSourceEntry>(Arrays.asList(cd.getSourceEntries()));
            String containerFolder = project.getFolder(targetFolderPath.uptoSegment(1)).getFullPath().toString();
            IPath sdkSubFolder = Path.fromOSString((String)targetFolderPath.lastSegment());
            Optional<ICSourceEntry> optional = sourceEntries.stream().filter(sourceEntry -> containerFolder.equals(sourceEntry.getValue()) && Arrays.asList(sourceEntry.getExclusionPatterns()).contains(sdkSubFolder)).findFirst();
            if (optional.isPresent()) {
                sourceEntries.remove(optional.get());
                cd.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[0]));
                CoreModel.getDefault().setProjectDescription(project, pd);
            }
        }
        catch (WriteAccessException | CoreException e) {
            SdkCoreActivator.getInstance().logError(e.getMessage());
        }
    }

    private static Set<String> getFolderEnclosedExcludedPaths(List<ICSourceEntry> sourceEntries, String targetFolderName, String sdkFolderName, IProject project) {
        IPath sdkFolderPath = Path.fromOSString((String)sdkFolderName);
        IPath targetFolderPath = project.getFolder(Path.fromOSString((String)targetFolderName)).getFullPath();
        ICSourceEntry sourceEntry = SourceEntriesUpdater.getMatchedEnclosedSourceEntry((IPath)targetFolderPath, sourceEntries);
        if (sourceEntry != null) {
            return Arrays.stream(sourceEntry.getExclusionPatterns()).map(Object::toString).collect(Collectors.toSet());
        }
        if (targetFolderName.equals(sdkFolderName)) {
            return Collections.emptySet();
        }
        return SdkAttachSourcePathsProcessor.getExcludedFolderChildren(targetFolderName, project, sdkFolderPath);
    }

    private static Set<String> getExcludedFolderChildren(String targetFolderName, IProject project, IPath sdkFolderPath) {
        IFolder targetFolder = project.getFolder(targetFolderName);
        try {
            return Arrays.stream(targetFolder.members()).filter(folder -> folder.getType() == 2).map(IResource::getFullPath).filter(folderPath -> !folderPath.lastSegment().equals(sdkFolderPath.lastSegment())).map(Object::toString).collect(Collectors.toSet());
        }
        catch (CoreException e) {
            SdkCoreActivator.getInstance().logError(e.getMessage());
            return Collections.emptySet();
        }
    }

    private static List<ICSourceEntry> getSourceEntries(IProject project, String configurationName) {
        ICConfigurationDescription configurationDescription = CoreModel.getDefault().getProjectDescription(project).getConfigurationByName(configurationName);
        return Arrays.asList(configurationDescription.getSourceEntries());
    }

    private static Set<String> getSourcePaths(IProject project, String targetFolderName, SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        HashSet<String> sourcePaths = new HashSet<String>();
        sourcePaths.add(project.getFolder(targetFolderName).getFullPath().toString());
        sourcePaths.addAll(SdkAttachSourcePathsProcessor.getSourceFolders(project, sdkDescriptor, configuration));
        return sourcePaths;
    }

    private static String getOldSdkLocation(IProject project) {
        String targetFolderName = "SDK";
        String oldSdkFolderName = "platform";
        return String.valueOf(project.getFullPath().toOSString()) + File.separator + targetFolderName + File.separator + oldSdkFolderName;
    }
}

